/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.nE2Link.ui.discover;

import com.ismacontrolli.nE2Link.BNanoBaseComponent;
import com.ismacontrolli.nE2Link.BNanoDiscoverExtension;
import com.ismacontrolli.nE2Link.actions.BNanoPropertyChangedArg;
import com.ismacontrolli.nE2Link.parser.binary.BResponseCode;
import com.ismacontrolli.nE2Link.parser.binary.BResponseResults;
import com.ismacontrolli.nE2Link.ui.discover.DiscoverSlotEntry;
import java.util.Map;
import java.util.WeakHashMap;
import javax.baja.gx.BInsets;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatusString;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BScrollBarPolicy;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.pane.BTextEditorPane;
import javax.baja.ui.text.BTextEditor;
import javax.baja.util.Lexicon;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

@NiagaraType
@NiagaraActions(value={@NiagaraAction(name="okPressed", flags=4), @NiagaraAction(name="cancelPressed", flags=4)})
public class BDiscoverParamsDialog
extends BDialog {
    public static final Action okPressed = BDiscoverParamsDialog.newAction((int)4, null);
    public static final Action cancelPressed = BDiscoverParamsDialog.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType(BDiscoverParamsDialog.class);
    protected static Lexicon LEX = Lexicon.make(BDiscoverParamsDialog.class);
    protected static double MARGIN = 8.0;
    Context callContext;
    BButton btnOk = new BButton();
    BButton btnCancel = new BButton();
    BEdgePane content = new BEdgePane();
    BBorderPane mainContent = new BBorderPane();
    BGridPane discoverPropertyGrid = new BGridPane(2);
    BNanoBaseComponent target;
    BNanoDiscoverExtension discoverExtension;
    Map<String, DiscoverSlotEntry> discoverSlotMap = new WeakHashMap<String, DiscoverSlotEntry>();
    int result;

    public void okPressed() {
        this.invoke(okPressed, null, null);
    }

    public void cancelPressed() {
        this.invoke(cancelPressed, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public static int open(BWidget owner, String title, BNanoBaseComponent target, Context callContext) {
        BNanoDiscoverExtension discoverExtension = target.getDiscoveryExtensionOfType(null);
        if (discoverExtension == null) {
            return 1;
        }
        BDiscoverParamsDialog dialog = new BDiscoverParamsDialog(owner, title, target, callContext);
        dialog.setBoundsCenteredOnOwner();
        dialog.open();
        return dialog.result;
    }

    private BDiscoverParamsDialog(BWidget owner, String title, BNanoBaseComponent target, Context callContext) {
        super(owner, title, true);
        this.callContext = callContext;
        this.target = target;
        this.discoverExtension = target.getDiscoveryExtensionOfType(null);
        this.btnOk.setText(LEX.get("DiscoverDialog.ok", "OK"));
        this.btnCancel.setText(LEX.get("DiscoverDialog.cancel", "Cancel"));
        BGridPane buttonGrid = new BGridPane(2);
        buttonGrid.setValign(BValign.center);
        buttonGrid.add("ok", (BValue)this.btnOk);
        buttonGrid.add("cancel", (BValue)this.btnCancel);
        this.content.setBottom((BWidget)buttonGrid);
        this.mainContent.setMargin(BInsets.make((double)MARGIN, (double)MARGIN, (double)MARGIN, (double)MARGIN));
        this.mainContent.setPadding(BInsets.make((double)MARGIN, (double)MARGIN, (double)MARGIN, (double)MARGIN));
        BScrollPane sp = new BScrollPane((BWidget)this.mainContent);
        sp.setHpolicy(BScrollBarPolicy.asNeeded);
        sp.setVpolicy(BScrollBarPolicy.asNeeded);
        this.content.setCenter((BWidget)sp);
        this.setContent((BWidget)this.content);
        this.linkTo("lkOk", (BComponent)this.btnOk, (Slot)BButton.actionPerformed, (Slot)okPressed);
        this.linkTo("lkCancel", (BComponent)this.btnCancel, (Slot)BButton.actionPerformed, (Slot)cancelPressed);
        this.init(target, callContext);
    }

    protected void init(BNanoBaseComponent target, Context context) {
        String[] discoverSlotNames;
        String discoverParamSlotName = this.discoverExtension.getHostNameForExtensionSlot("discoverParameters");
        Property discoverParamSlot = discoverParamSlotName != null ? target.getProperty(discoverParamSlotName) : null;
        String discoverParams = discoverParamSlot != null && discoverParamSlot.getType().is(BStatusString.TYPE) ? ((BStatusString)target.get(discoverParamSlot)).getValue() : null;
        String[] stringArray = discoverSlotNames = discoverParams != null ? discoverParams.split(",") : null;
        if (discoverParams == null || discoverSlotNames == null || discoverSlotNames.length <= 0) {
            BTextEditor textEditor = new BTextEditor(LEX.getText("DiscoverDialog.noParams", new Object[]{this.btnOk.getText()}), false);
            BTextEditorPane textPane = new BTextEditorPane(textEditor, 20, 110);
            this.mainContent.setContent((BWidget)textPane);
        } else {
            this.discoverPropertyGrid.setColumnGap(MARGIN);
            this.discoverPropertyGrid.setRowGap(MARGIN);
            for (String discoverSlotName : discoverSlotNames) {
                BLabel lblDiscoverSlotName = new BLabel(discoverSlotName);
                lblDiscoverSlotName.setEnabled(false);
                this.discoverPropertyGrid.add(discoverSlotName, (BValue)lblDiscoverSlotName);
                DiscoverSlotEntry discoverSlotEntry = new DiscoverSlotEntry(target, this.discoverExtension, discoverSlotName);
                this.discoverSlotMap.put(discoverSlotName, discoverSlotEntry);
                BWbFieldEditor discoverSlotFE = BWbFieldEditor.makeFor((BObject)discoverSlotEntry.getOriginalValue(), (Context)discoverSlotEntry.getSuppressWriteContext(context));
                discoverSlotFE.loadValue((BObject)discoverSlotEntry.getOriginalValue(), discoverSlotEntry.getSuppressWriteContext(context));
                this.discoverPropertyGrid.add(discoverSlotName + "FE", (BValue)discoverSlotFE);
            }
            this.mainContent.setContent((BWidget)this.discoverPropertyGrid);
        }
    }

    public BButton getDefaultButton() {
        return this.btnOk;
    }

    public void doCancelPressed() {
        this.result = 2;
        this.close();
    }

    public void doOkPressed() {
        for (String key : this.discoverSlotMap.keySet()) {
            DiscoverSlotEntry discoverSlotEntry = this.discoverSlotMap.get(key);
            BWbFieldEditor fieldEditor = (BWbFieldEditor)this.discoverPropertyGrid.get(discoverSlotEntry.getSlotName() + "FE");
            try {
                fieldEditor.saveValue(discoverSlotEntry.getOriginalContext(this.callContext));
                BValue newValue = this.target.get(discoverSlotEntry.getResolvedProperty()).newCopy();
                BNanoPropertyChangedArg changedArg = new BNanoPropertyChangedArg(this.target, discoverSlotEntry.getResolvedProperty(), discoverSlotEntry.getOriginalValue().newCopy(), newValue);
                BResponseResults result = this.target.getNe2DeviceExt().syncNanoPropertyValueChange(changedArg);
                if (result.getResponseCode().equals((Object)BResponseCode.ok)) continue;
                String msg = result.getItem().getLocalizedMessage();
                BDialog.info((BWidget)this, (String)LEX.get("DiscoverDialog.error.title"), (Object)msg);
                this.revertChanges(fieldEditor, changedArg);
                return;
            }
            catch (Exception e) {
                BDialog.error((BWidget)this, (String)LEX.get("DiscoverDialog.exception.title"), (Object)LEX.get("DiscoverDialog.exception"), (Throwable)e);
                return;
            }
        }
        this.result = 1;
        this.close();
    }

    private void revertChanges(BWbFieldEditor fieldEditor, BNanoPropertyChangedArg changedArg) {
        BNanoBaseComponent comp = changedArg.getSourceComponent();
        Property changedProp = changedArg.getChangedProperty();
        comp.set(changedProp, changedArg.getOldValue().newCopy(), Context.decoding);
        fieldEditor.loadValue((BObject)changedArg.getOldValue());
    }
}

