/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.nE2Link.ui.commands;

import com.ismacontrolli.nE2Link.BNanoBaseComponent;
import com.ismacontrolli.nE2Link.BNe2DeviceExt;
import com.tridium.workbench.util.BReorderPad;
import java.util.ArrayList;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIPropertyContainer;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;

public class NanoReorderCommand
extends Command {
    NanoPropertyFilter filter;
    private BIPropertyContainer component;
    protected static final Lexicon lex = Lexicon.make(NanoReorderCommand.class);

    public NanoReorderCommand(BWidget owner, BComponent component) {
        this(owner, (BIPropertyContainer)component);
    }

    public NanoReorderCommand(BWidget owner, BIPropertyContainer container) {
        super(owner, UiLexicon.bajaui().module, "commands.reorder");
        this.component = container;
        this.filter = new NanoPropertyFilter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommandArtifact doInvoke() throws Exception {
        if (!(this.component instanceof BNanoBaseComponent)) {
            return null;
        }
        BNe2DeviceExt ne2DeviceExt = ((BNanoBaseComponent)this.component).getNe2DeviceExt();
        ne2DeviceExt.lease(3);
        if (ne2DeviceExt.getConfig().getCommunicationSettings().getStatus().getOrdinal() != 0) {
            BDialog.error((BWidget)this.getOwner(), (Object)lex.get("deviceStatus.warning.notconnected"));
            ((BWbShell)this.getShell()).getRefreshCommand().invoke();
            return null;
        }
        String title = UiLexicon.bajaui().getText("reorder.title");
        title = title + " " + this.component.getDisplayName(null);
        BReorderPad pad = new BReorderPad(this.component, (BReorderPad.PropertyFilter)this.filter);
        int r = BDialog.open((BWidget)this.getOwner(), (String)title, (Object)pad, (int)3);
        if (r == 2) {
            return null;
        }
        Property[] oldOrder = pad.oldOrder();
        Property[] newOrder = pad.newOrder();
        ArrayList<Property> dynProp = this.getDynamicPropertiesArray(this.component);
        for (Property prop : newOrder) {
            dynProp.add(prop);
        }
        BWidgetShell shell = this.getShell();
        if (shell != null) {
            shell.enterBusy();
        }
        try {
            this.component.reorder(dynProp.toArray(new Property[dynProp.size()]), null);
            CommandArtifact commandArtifact = null;
            return commandArtifact;
        }
        finally {
            if (shell != null) {
                shell.exitBusy();
            }
        }
    }

    ArrayList<Property> getDynamicPropertiesArray(BIPropertyContainer container) {
        ArrayList<Property> v = new ArrayList<Property>();
        container.loadSlots();
        SlotCursor c = container.getProperties();
        while (c.next()) {
            Property p = c.property();
            if (p.isFrozen() || this.filter.include(container, p)) continue;
            v.add(p);
        }
        return v;
    }

    public static class NanoPropertyFilter
    extends BReorderPad.PropertyFilter {
        public boolean include(BIPropertyContainer comp, Property prop) {
            return prop.getType().is(BNanoBaseComponent.TYPE);
        }
    }
}

