/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.nE2Link.ui.commands;

import com.ismacontrolli.nE2Link.BNanoBase;
import com.ismacontrolli.nE2Link.BNanoBaseComponent;
import com.ismacontrolli.nE2Link.BNanoConfig;
import com.ismacontrolli.nE2Link.BNe2DeviceExt;
import com.ismacontrolli.nE2Link.actions.BNanoComponentsMoveArg;
import com.ismacontrolli.nE2Link.parser.binary.BResponseCode;
import com.ismacontrolli.nE2Link.parser.binary.BResponseResults;
import com.ismacontrolli.nE2Link.ui.wiresheet.BWireSheet;
import com.tridium.wiresheet.BWsCanvas;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.baja.gx.BImage;
import javax.baja.space.Mark;
import javax.baja.sys.BComplex;
import javax.baja.sys.BObject;
import javax.baja.sys.LocalizableException;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.commands.PasteCommand;
import javax.baja.ui.transfer.BTransferWidget;
import javax.baja.ui.transfer.Clipboard;
import javax.baja.ui.transfer.TransferEnvelope;
import javax.baja.ui.transfer.TransferFormat;
import javax.baja.ui.transfer.UnsupportedFormatException;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;
import javax.baja.util.Version;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.nav.tree.BNavTree;

public class NanoPasteCommand
extends PasteCommand {
    protected static final Lexicon LEX = Lexicon.make(BNanoBase.class);
    protected static final Lexicon lex = Lexicon.make(NanoPasteCommand.class);

    public NanoPasteCommand(BTransferWidget owner) {
        super(owner);
    }

    public CommandArtifact doInvoke() throws Exception {
        try {
            TransferEnvelope envelope = Clipboard.getDefault().getContents();
            if (envelope != null && envelope.supports(TransferFormat.mark)) {
                Mark mark = (Mark)envelope.getData(TransferFormat.mark);
                String regex = "\\d+\\.\\d+";
                Pattern pattern = Pattern.compile(regex);
                BNanoBaseComponent targetParentComponent = null;
                BWidget navParent = this.getOwner();
                if (navParent instanceof BNavTree) {
                    if (((BNavTree)navParent).getSelectedObject() instanceof BNanoBaseComponent) {
                        targetParentComponent = (BNanoBaseComponent)((BNavTree)navParent).getSelectedObject();
                    }
                } else if (navParent instanceof BWsCanvas) {
                    BWsCanvas wsCanvas = (BWsCanvas)navParent;
                    BWireSheet ws = this.getWireSheet(wsCanvas);
                    targetParentComponent = null != ws ? (BNanoBaseComponent)ws.getCurrentValue() : null;
                }
                Matcher matcher = pattern.matcher(targetParentComponent.getAssemblyInfo());
                Version pasteToVersion = null;
                if (matcher.find()) {
                    pasteToVersion = new Version(matcher.group(0));
                }
                boolean isAny = false;
                if (null != targetParentComponent) {
                    targetParentComponent.loadSlots();
                    BNanoComponentsMoveArg componentsMoveArg = new BNanoComponentsMoveArg(targetParentComponent.getGlobalIndex());
                    for (BObject value : mark.getValues()) {
                        if (value.equals((Object)targetParentComponent)) {
                            throw new LocalizableException(lex.get("Exception.MoveUnderSelf"), "Cannot move under self");
                        }
                        if (!(value.getType().getInstance() instanceof BNanoBaseComponent) || ((BNanoBaseComponent)value).getParent().equals((Object)targetParentComponent)) continue;
                        BNanoBaseComponent sourceComponent = (BNanoBaseComponent)value;
                        if (!isAny) {
                            matcher = pattern.matcher(sourceComponent.getAssemblyInfo());
                            Version pasteFromVersion = null;
                            if (matcher.find()) {
                                pasteFromVersion = new Version(matcher.group(0));
                            }
                            switch (pasteFromVersion.compareTo(pasteToVersion)) {
                                case 1: {
                                    throw new RuntimeException(LEX.getText("PasteError.Version", new Object[]{pasteFromVersion.toString(), pasteToVersion.toString()}));
                                }
                                case -1: {
                                    int res = BDialog.open((BWidget)navParent, (String)LEX.getText("PasteInfo.Header"), (Object)LEX.getText("PasteInfo.Text"), (int)3, (BImage)BDialog.INFO_ICON);
                                    if (res == 1) break;
                                    return null;
                                }
                            }
                        }
                        componentsMoveArg.addComponent(sourceComponent.getSlotPathOrd());
                        isAny = true;
                    }
                    if (mark.isPendingMove()) {
                        if (isAny) {
                            BNe2DeviceExt ne2DeviceExt = targetParentComponent.getNe2DeviceExt();
                            BNanoConfig config = ne2DeviceExt.getConfig();
                            if (!config.isSubscribed()) {
                                config.lease(2);
                            }
                            if (ne2DeviceExt.getConfig().getCommunicationSettings().getStatus().getOrdinal() == 0) {
                                BResponseResults result = ne2DeviceExt.syncNanoComponentsMoveRequest(componentsMoveArg);
                                if (result.getResponseCode().equals((Object)BResponseCode.ok)) {
                                    Clipboard.getDefault().setContents(null);
                                }
                            } else {
                                BDialog.error((BWidget)this.getOwner(), (Object)lex.get("deviceStatus.warning.notconnected"));
                            }
                        }
                        mark.setPendingMove(false);
                        return null;
                    }
                }
            }
        }
        catch (UnsupportedFormatException ex) {
            BDialog.error((BWidget)((BWbShell)this.getShell()), (Object)UiLexicon.bajaui().getText("command.paste.unsupportedFormat"));
            ((BWbShell)this.getShell()).getRefreshCommand().invoke();
            return null;
        }
        return super.doInvoke();
    }

    private BWireSheet getWireSheet(BWsCanvas wsCanvas) {
        BComplex parent;
        for (parent = wsCanvas.getParent(); null != parent && !(parent instanceof BWireSheet); parent = parent.getParent()) {
        }
        return null != parent ? (BWireSheet)parent : null;
    }
}

