/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.nE2Link.ui.commands;

import com.ismacontrolli.nE2Link.BNanoBaseComponent;
import com.tridium.util.ObjectUtil;
import com.tridium.wiresheet.BWsCanvas;
import com.tridium.wiresheet.Glyph;
import com.tridium.wiresheet.StdComponentGlyph;
import com.tridium.workbench.propsheet.BComplexEntry;
import com.tridium.workbench.shell.WbMain;
import javax.baja.naming.BOrd;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.util.UiLexicon;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.mgr.BMgrTable;
import javax.baja.workbench.nav.tree.BNavTree;

public class NanoHelpGuideOnTargetCommand
extends Command {
    private static final BModule LEXICON_MODULE = UiLexicon.bajaui().module;
    private static final String LEXICON_KEY_BASE = "commands.help.guideOnTarget";

    public NanoHelpGuideOnTargetCommand(BWidget owner) {
        super(owner, LEXICON_MODULE, LEXICON_KEY_BASE);
    }

    public CommandArtifact doInvoke() {
        BWbShell shell = (BWbShell)this.getShell();
        BObject target = null;
        if (this.getOwner() instanceof BNavTree) {
            target = ((BNavTree)this.getOwner()).getSelectedObject();
        } else if (this.getOwner() instanceof BWsCanvas) {
            Glyph[] glyphs = ((BWsCanvas)this.getOwner()).getRootGlyph().componentLayer.getChildGlyphs();
            for (int i = 0; i < glyphs.length; ++i) {
                if (!glyphs[i].isSelected()) continue;
                target = ((StdComponentGlyph)glyphs[i]).component;
            }
        } else if (this.getOwner() instanceof BComplexEntry) {
            target = ((BComplexEntry)this.getOwner()).getTarget();
        } else if (this.getOwner() instanceof BMgrTable) {
            target = ((BMgrTable)this.getOwner()).getSelectedComponent();
        }
        if (target != null) {
            BOrd ord = ObjectUtil.getGuideHelpOrd((BObject)target);
            if (target instanceof BNanoBaseComponent) {
                BNanoBaseComponent nanoBaseComponent = (BNanoBaseComponent)target;
                BString nanoHelpUrl = (BString)nanoBaseComponent.getComponentFacets().get("nano_attr_help", (BObject)BString.DEFAULT);
                if (!nanoHelpUrl.getString().isEmpty()) {
                    ord = BOrd.make((String)nanoHelpUrl.toString());
                }
                System.out.println("Workbench: invoking custom help/guide on target menu");
            }
            WbMain.openHelp((BWbShell)shell, (BOrd)ord);
        }
        return null;
    }
}

