/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.nE2Link.ui.agents;

import com.ismacontrolli.nE2Link.BNanoApplication;
import com.ismacontrolli.nE2Link.BNanoApplicationContainer;
import com.ismacontrolli.nE2Link.BNanoBaseComponent;
import com.ismacontrolli.nE2Link.BNanoContainer;
import com.ismacontrolli.nE2Link.BNanoExtension;
import com.ismacontrolli.nE2Link.BNe2DeviceExt;
import com.ismacontrolli.nE2Link.ui.commands.AddNanoComponentCommand;
import com.ismacontrolli.nE2Link.ui.commands.NanoHelpGuideOnTargetCommand;
import com.ismacontrolli.nE2Link.ui.commands.NanoPasteCommand;
import com.ismacontrolli.nE2Link.ui.commands.NanoReorderCommand;
import com.ismacontrolli.nE2Link.ui.viewManagers.BTrendsManager;
import com.ismacontrolli.nE2Link.utils.BSoftwareManager;
import com.tridium.workbench.nav.BComponentMenuAgent;
import com.tridium.workbench.nav.BFileMenuAgent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BMenu;
import javax.baja.ui.BMenuItem;
import javax.baja.ui.BSubMenuItem;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.menu.BIMenu;
import javax.baja.ui.menu.BIMenuItem;
import javax.baja.ui.transfer.BTransferWidget;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.BWsAnnotation;
import javax.baja.util.Lexicon;
import javax.baja.workbench.mgr.BMgrTable;

@NiagaraType(agent={@AgentOn(types={"nE2Link:Ne2DeviceExt", "nE2Link:AsyncConfig", "nE2Link:NanoProgramConfig", "nE2Link:NanoPollScheduler", "nE2Link:SoftwareManager", "nE2Link:NanoBase"}, defaultAgent=AgentOn.Preference.PREFERRED)})
@NiagaraSingleton
public class BContextMenuAgent
extends BComponentMenuAgent {
    public static final BContextMenuAgent INSTANCE = new BContextMenuAgent();
    public static final Type TYPE = Sys.loadType(BContextMenuAgent.class);
    protected static String[] ALLOW_RENAME_OF_PROTECTED_COMPONENTS = new String[]{"Library.BACnet.LocalDevice", "Library.Modbus.LocalDevice"};
    protected static final Logger logger = Logger.getLogger(TYPE.getTypeSpec().getModuleName());
    protected static final Lexicon lex = Lexicon.make(BContextMenuAgent.class);
    protected static final String[] TYPE_NAMES_FOR_ADD_1_4 = new String[]{"Library.Core.AnalogDataPoint", "Library.Core.BinaryDataPoint", "Library.Core.MultistateDataPoint", "Library.Schedules.AnalogSchedule", "Library.Schedules.BinarySchedule", "Library.Schedules.Calendar", "Library.Core.Equipment", "Library.Core.Folder"};
    protected static final String[] TYPE_NAMES_FOR_ADD_1_5 = new String[]{"Library.Core.AnalogDataPoint", "Library.Core.BinaryDataPoint", "Library.Core.MultistateDataPoint", "Library.Schedules.AnalogSchedule", "Library.Schedules.BinarySchedule", "Library.Schedules.MultistateSchedule", "Library.Schedules.Calendar", "Library.Core.Equipment", "Library.Core.Folder"};
    protected static final String[] ACTIONS_TO_HIDE = new String[]{"Set UTC Time", "Discover", "CancelDiscover"};
    static boolean disable = BFileMenuAgent.disable;
    protected static final Set<String> hideCut = new HashSet<String>(Arrays.asList("Bacnet Point Manager", "Local Io Manager", "Device Manager"));
    protected static final Set<String> hidePaste = new HashSet<String>(Arrays.asList("Data Point Manager", "Modbus Point Manager", "Bacnet Point Manager", "Device Discover Manager"));

    public Type getType() {
        return TYPE;
    }

    protected BMenu doMakeMenu(BWidget owner, BObject target, Context cx) {
        if (owner instanceof BMgrTable && ((BMgrTable)owner).getManager().getType().equals(BTrendsManager.TYPE)) {
            return null;
        }
        BMenu menu = super.doMakeMenu(owner, target, cx);
        BContextMenuAgent.removeMenuItem(menu, target, cx, "new");
        UiLexicon bajaUILex = UiLexicon.bajaui();
        BContextMenuAgent.removeMenuItem(menu, target, cx, "ActionMenuItem", bajaUILex.get("commands.editTags.label"));
        BContextMenuAgent.removeMenuItem(menu, target, cx, "ActionMenuItem1", bajaUILex.get("commands.makeTemplate.label"));
        BContextMenuAgent.removeMenuItem(menu, target, cx, "relationMark");
        BContextMenuAgent.removeMenuItem(menu, target, cx, "relateFrom");
        BContextMenuAgent.removeMenuItem(menu, target, cx, "relateTo");
        BContextMenuAgent.removeMenuItem(menu, target, cx, "setDisplayName");
        BContextMenuAgent.removeMenuItem(menu, target, cx, "composite");
        BContextMenuAgent.removeMenuItem(menu, target, cx, "pasteSpecial");
        if (!(owner instanceof BMgrTable) || !((BMgrTable)owner).getManager().toString().equals("Configuration Data Service Manager")) {
            BContextMenuAgent.handleAddMenu(menu, owner, target, null);
        }
        if (target instanceof BNanoContainer && ((BNanoContainer)target).getNanoName().equals("Root")) {
            BContextMenuAgent.removeMenuItem(menu, target, cx, "delete");
        }
        if (target instanceof BNanoExtension) {
            BContextMenuAgent.removeMenuItem(menu, target, cx, "delete");
            BContextMenuAgent.removeMenuItem(menu, target, cx, "duplicate");
            BContextMenuAgent.removeMenuItem(menu, target, cx, "rename");
            BContextMenuAgent.removeMenuItem(menu, target, cx, "cut");
        }
        if (target instanceof BNanoBaseComponent) {
            BIMenuItem helpGuideMenuItem;
            BIMenuItem viewMenuItem;
            if (((BNanoBaseComponent)target).getNe2DeviceExt() != null) {
                ((BNanoBaseComponent)target).getNe2DeviceExt().startAutoDisconnect();
            }
            block0: for (BMenuItem item : ((BSubMenuItem)menu.getItem("actions")).getMenu().getMenuItems()) {
                for (int i = 0; i < ACTIONS_TO_HIDE.length; ++i) {
                    if (!item.getCommand().getLabel().contains(ACTIONS_TO_HIDE[i])) continue;
                    ((BSubMenuItem)menu.getItem("actions")).getMenu().removeItem(item.getName());
                    continue block0;
                }
            }
            if (((BSubMenuItem)menu.getItem("actions")).getMenu().getMenuItems().length == 0) {
                menu.removeItem("actions");
            }
            if (Arrays.stream(ALLOW_RENAME_OF_PROTECTED_COMPONENTS).anyMatch(((BNanoBaseComponent)target).getOriginNameFromLibrary()::equals)) {
                menu.getItem("rename").getCommand().setEnabled(true);
            }
            if ((viewMenuItem = menu.getItem("views")) instanceof BSubMenuItem && (helpGuideMenuItem = ((BSubMenuItem)viewMenuItem).getMenu().getItem("helpGuide")) instanceof BMenuItem) {
                ((BMenuItem)helpGuideMenuItem).setCommand((Command)new NanoHelpGuideOnTargetCommand(owner));
            }
        }
        if (owner instanceof BMgrTable) {
            String name = ((BMgrTable)owner).getManager().toString();
            if (name.equals("Configuration Data Service Manager")) {
                BSubMenuItem action = (BSubMenuItem)menu.getItem("actions");
                if (action != null) {
                    for (BMenuItem item : action.getMenu().getMenuItems()) {
                        if (item.getCommand().getLabel().contains("Extension")) continue;
                        action.getMenu().removeItem(item.getName());
                    }
                }
                BContextMenuAgent.removeMenuItem(menu, target, cx, "cut");
                BContextMenuAgent.removeMenuItem(menu, target, cx, "copy");
                BContextMenuAgent.removeMenuItem(menu, target, cx, "paste");
                BContextMenuAgent.removeMenuItem(menu, target, cx, "pasteSpecial");
                BContextMenuAgent.removeMenuItem(menu, target, cx, "duplicate");
                BContextMenuAgent.removeMenuItem(menu, target, cx, "delete");
                BContextMenuAgent.removeMenuItem(menu, target, cx, "linkMark");
                BContextMenuAgent.removeMenuItem(menu, target, cx, "linkFrom");
                BContextMenuAgent.removeMenuItem(menu, target, cx, "linkTo");
                BContextMenuAgent.removeMenuItem(menu, target, cx, "rename");
                BContextMenuAgent.removeMenuItem(menu, target, cx, "reorder");
                return menu;
            }
            if (hideCut.contains(name)) {
                BContextMenuAgent.removeMenuItem(menu, target, cx, "cut");
            } else if (hidePaste.contains(name)) {
                BContextMenuAgent.removeMenuItem(menu, target, cx, "paste");
            }
        }
        if (!(target instanceof BNanoBaseComponent) || !((BNanoBaseComponent)target).isReorderSupported() || ((BNanoBaseComponent[])((BNanoBaseComponent)target).getChildren(BNanoBaseComponent.class)).length < 2) {
            BContextMenuAgent.removeMenuItem(menu, target, cx, "reorder");
        } else {
            ((BMenuItem)menu.getItem("reorder")).setCommand((Command)new NanoReorderCommand(owner, (BComponent)target));
        }
        if (!(target instanceof BNanoBaseComponent) || !((BNanoBaseComponent)target).isMoveSupported()) {
            BContextMenuAgent.removeMenuItem(menu, target, cx, "cut");
        }
        if ((BMenuItem)menu.getItem("paste") != null) {
            ((BMenuItem)menu.getItem("paste")).setCommand((Command)new NanoPasteCommand((BTransferWidget)owner));
        }
        menu.removeConsecutiveSeparators();
        return menu;
    }

    public static void handleAddMenu(BMenu menu, BWidget owner, BObject target, BWsAnnotation wsAnnotation) {
        if (target instanceof BNanoBaseComponent) {
            BNanoBaseComponent nano = (BNanoBaseComponent)target;
            BNanoApplication nanoApplication = BContextMenuAgent.getParentNanoApplication((BComponent)nano);
            if (null == nanoApplication) {
                return;
            }
            BNe2DeviceExt controller = nano.getNe2DeviceExt();
            if (controller == null) {
                return;
            }
            ArrayList<BNanoBaseComponent> componentsForAdd = new ArrayList<BNanoBaseComponent>();
            BSoftwareManager softwareManager = controller.getSoftwareManager();
            String[] typeNamesForAdd = softwareManager.versionSmallerThan("1.5.0.0") ? TYPE_NAMES_FOR_ADD_1_4 : TYPE_NAMES_FOR_ADD_1_5;
            for (int i = 0; i < typeNamesForAdd.length; ++i) {
                BNanoBaseComponent child = controller.getLibraries().getComponentByTypeName(BString.make((String)typeNamesForAdd[i]));
                if (null == child) continue;
                componentsForAdd.add(child);
            }
            BContextMenuAgent.addAddMenu(menu, owner, (BComponent)nano, componentsForAdd, wsAnnotation);
        }
    }

    private static void addAddMenu(BMenu menu, BWidget owner, BComponent comp, List<BNanoBaseComponent> componentsForAdd, BWsAnnotation wsAnnotation) {
        if (componentsForAdd.isEmpty()) {
            return;
        }
        BMenu newMenu = BContextMenuAgent.makeAddMenu(owner, comp, wsAnnotation, componentsForAdd);
        if (newMenu == null) {
            return;
        }
        Property p = menu.add("new", (BValue)new BSubMenuItem((BIMenu)newMenu));
        menu.reorderToTop(p);
    }

    private static BMenu makeAddMenu(BWidget owner, BComponent parent, BWsAnnotation anno, List<BNanoBaseComponent> componentsForAdd) {
        try {
            if (parent.getType().getTypeSpec().toString().equals("nsedona:SedonaComponent")) {
                return null;
            }
            BMenu menu = new BMenu(lex.get("ContextMenu.Add", "Add"));
            for (int i = 0; i < componentsForAdd.size(); ++i) {
                BContextMenuAgent.attachAddCommandToAddMenu(owner, menu, parent, componentsForAdd.get(i), anno);
            }
            return menu;
        }
        catch (UnresolvedException e) {
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static void attachAddCommandToAddMenu(BWidget owner, BMenu menu, BComponent parent, BNanoBaseComponent child, BWsAnnotation anno) {
        String[] splitted = child.getNanoName().split("[.]");
        String name = splitted[splitted.length - 1];
        menu.add(name, (Command)new AddNanoComponentCommand(owner, parent, child, anno, name));
    }

    public static void removeMenuItem(BMenu menu, BObject target, Context cx, String menuItem) {
        BIMenuItem removedItem;
        if (null != menu.getItem(menuItem) && null == (removedItem = menu.removeItem(menuItem))) {
            String targetTypeString = null != target ? target.getTypeDisplayName(cx) : "unknown";
            logger.warning(() -> MessageFormat.format("could not remove menu item from {0} menuItem: {1}", targetTypeString, menuItem));
        }
    }

    public static void removeMenuItem(BMenu menu, BObject target, Context cx, String menuItem, String menuItemText) {
        BIMenuItem item;
        BValue itemtoRemove = menu.get(menuItem);
        if (itemtoRemove instanceof BIMenuItem && !menuItemText.equals((item = (BIMenuItem)itemtoRemove).getText())) {
            logger.warning(() -> MessageFormat.format(" cannot remove menu item {0} because expected itemText {1} but got {2}", menuItem, menuItemText, item.getText()));
            return;
        }
        BContextMenuAgent.removeMenuItem(menu, target, cx, menuItem);
    }

    public static BNanoApplication getParentNanoApplication(BComponent component) {
        if (null == component || component instanceof BNanoApplicationContainer) {
            return null;
        }
        if (component instanceof BNanoApplication) {
            return (BNanoApplication)component;
        }
        return BContextMenuAgent.getParentNanoApplication((BComponent)component.getParent());
    }
}

