/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.nE2Link.ui;

import com.ismacontrolli.nE2Link.BNe2DeviceExt;
import java.util.List;
import javax.baja.gx.BImage;
import javax.baja.nre.util.SortUtil;
import javax.baja.ui.table.TableModel;

public abstract class NanoTableModel
extends TableModel {
    protected int count;
    protected BNe2DeviceExt ne2DeviceExt = null;
    protected Row[] rows;
    protected String[] columnNames;

    public abstract Row[] makeRows();

    public void updateTable() {
        this.rows = this.makeRows();
        this.updateTable(true);
    }

    public int getRowCount() {
        return this.count;
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public String getColumnName(int index) {
        return this.columnNames[index];
    }

    public Object getValueAt(int row, int col) {
        return this.rows[row].columns[col];
    }

    public synchronized BImage getRowIcon(int row) {
        return this.rows[row].icon;
    }

    public synchronized Object getSubject(int row) {
        return this.getRowValues(row);
    }

    public boolean isColumnSortable(int col) {
        return true;
    }

    public synchronized void sortByColumn(int col, boolean ascending) {
        Object[] keys = this.getColumnValues(col);
        Object[] temp = new Row[keys.length];
        System.arraycopy(this.rows, 0, temp, 0, keys.length);
        SortUtil.sort((Object[])keys, (Object[])temp, (boolean)ascending);
        this.rows = temp;
    }

    public synchronized void set(int row, int col, Object value) {
        this.rows[row].columns[col] = value;
        this.updateTable(true);
    }

    public void addRow(Object[] rowValues) {
        this.addRow(new Row(null, rowValues));
    }

    public void addRow(BImage icon, Object[] rowValues) {
        this.addRow(new Row(icon, rowValues));
    }

    public void addRow(List<Object> rowData) {
        this.addRow(new Row(null, rowData.toArray()));
    }

    public void addRow(BImage icon, List<Object> rowData) {
        this.addRow(new Row(icon, rowData.toArray()));
    }

    private synchronized void addRow(Row row) {
        if (row.columns.length != this.columnNames.length) {
            throw new IllegalArgumentException("invalid number of columns");
        }
        if (this.count >= this.rows.length) {
            Row[] temp = new Row[this.count * 2 + 1];
            System.arraycopy(this.rows, 0, temp, 0, this.count);
            this.rows = temp;
        }
        this.rows[this.count++] = row;
        this.updateTable(true);
    }

    public Row getRow(int index) {
        return this.rows[index];
    }

    public synchronized void removeAllRows() {
        this.count = 0;
        this.updateTable(true);
    }

    public synchronized void removeRow(int row) {
        System.arraycopy(this.rows, row + 1, this.rows, row, this.count - row - 1);
        this.rows[this.count - 1] = null;
        --this.count;
        this.updateTable(true);
    }

    protected static class Row {
        BImage icon;
        Object[] columns;

        Row(BImage i, Object[] c) {
            this.icon = i;
            this.columns = c;
        }
    }
}

