/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.nE2Link.ui;

import com.ismacontrolli.nE2Link.BNanoConfig;
import com.ismacontrolli.nE2Link.BNanoConfigComms;
import com.ismacontrolli.nE2Link.BNe2DeviceExt;
import com.ismacontrolli.nE2Link.services.BNe2LinkService;
import com.ismacontrolli.nE2Link.services.BNe2UsbDevice;
import com.ismacontrolli.nE2Link.ui.BInfo;
import com.ismacontrolli.nE2Link.utils.BSoftwareManager;
import com.tridium.modbusTcp.BModbusTcpDevice;
import java.util.Arrays;
import java.util.Objects;
import javax.baja.bacnet.BBacnetDevice;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.naming.BatchResolve;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BNumber;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BLabel;
import javax.baja.ui.BMenu;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.commands.InvokeActionCommand;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.util.BFormat;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.component.table.BComponentTable;
import javax.baja.workbench.component.table.ComponentTableController;
import javax.baja.workbench.component.table.ComponentTableModel;
import javax.baja.workbench.component.table.ComponentTableSubject;
import javax.baja.workbench.nav.menu.NavMenuUtil;
import javax.baja.workbench.view.BWbComponentView;

@NiagaraType(agent={@AgentOn(types={"nE2Link:Ne2LinkService"}, defaultAgent=AgentOn.Preference.PREFERRED)})
public class BNe2LinkServiceView
extends BWbComponentView {
    public static final Type TYPE = Sys.loadType(BNe2LinkServiceView.class);
    static double PADDING_PX = 8.0;
    static double MARGIN_PX = 8.0;
    static Lexicon LEX = Lexicon.make(BNe2LinkServiceView.class);
    Ne2LinkServiceTableModel model;
    BComponentTable table;
    BButton refreshButton;
    BButton disconnectSelectedButton;
    BButton disconnectAllButton;
    BButton disconnectSettingsButton;

    public Type getType() {
        return TYPE;
    }

    protected void doLoadValue(BObject value, Context context) throws Exception {
        super.doLoadValue(value, context);
        BNe2LinkService ne2LinkService = (BNe2LinkService)value;
        ne2LinkService.lease(1);
        ComponentTableModel.Column[] cols = new ComponentTableModel.Column[]{new Ne2LinkServiceTableModel.DisplayNameCol(LEX.get("Ne2LinkServiceView.DisplayNameCol.defaultName", "Name")), new Ne2LinkServiceTableModel.CommSettingsStatusIconCol(LEX.get("Ne2LinkServiceView.CommSettingsStatusIconCol.defaultName", "Icon")), new Ne2LinkServiceTableModel.CommSettingsStatusTextCol(LEX.get("Ne2LinkServiceView.CommSettingsStatusTextCol.defaultName", "Communication Status")), new Ne2LinkServiceTableModel.CommSettingsAddressCol(LEX.get("Ne2LinkServiceView.CommSettingsAddressCol.defaultName", "Address")), new Ne2LinkServiceTableModel.SoftwareManagerPropCol(LEX.get("Ne2LinkServiceView.DeviceNameCol.defaultName", "nE2 Device Name"), BSoftwareManager.deviceName, context), new Ne2LinkServiceTableModel.SoftwareManagerPropCol(LEX.get("Ne2LinkServiceView.DeviceModelCol.defaultName", "nE2 Device Model"), BSoftwareManager.model, context), new Ne2LinkServiceTableModel.SoftwareManagerPropCol(LEX.get("Ne2LinkServiceView.OSVersionCol.defaultName", "OS Version"), BSoftwareManager.oSVersion, context), new Ne2LinkServiceTableModel.SoftwareManagerPropCol(LEX.get("Ne2LinkServiceView.SerialNumberCol.defaultName", "Serial Number"), BSoftwareManager.serialNumber, context), new Ne2LinkServiceTableModel.FormatCol(LEX.get("Ne2LinkServiceView.NavOrdCol.defaultName", "Slot Path"), BFormat.make((String)"%navOrd%"))};
        this.model = new Ne2LinkServiceTableModel(cols);
        this.attach(this.model);
        this.table = new BComponentTable((ComponentTableModel)this.model);
        this.table.setController((TableController)new Ne2LinkServiceTableController());
        this.table.setCellRenderer((TableCellRenderer)new Ne2LinkTableCellRenderer());
        this.model.initRows(ne2LinkService);
        BBorderPane borderPane = new BBorderPane((BWidget)this.table, BInsets.make((double)PADDING_PX, (double)PADDING_PX, (double)PADDING_PX, (double)PADDING_PX));
        borderPane.setMargin(BInsets.make((double)MARGIN_PX, (double)MARGIN_PX, (double)MARGIN_PX, (double)MARGIN_PX));
        this.refreshButton = new BButton((Command)new RefreshCommand(this), true, false);
        this.disconnectSelectedButton = new BButton((Command)new DisconnectSelectedCommand(this), true, false);
        this.disconnectAllButton = new BButton((Command)new DisconnectAllCommand(this), true, false);
        this.disconnectSettingsButton = new BButton((Command)new InvokeActionCommand((BWidget)this, (BComponent)ne2LinkService, BNe2LinkService.applyAutoDisconnectSettings), false, false);
        this.disconnectSettingsButton.setText(LEX.getText("Ne2LinkServiceView.disconnectSettingsButton.label"));
        BGridPane buttonGrid = new BGridPane(4);
        buttonGrid.setValign(BValign.center);
        buttonGrid.add((String)null, (BValue)this.disconnectSelectedButton);
        buttonGrid.add((String)null, (BValue)this.disconnectAllButton);
        buttonGrid.add((String)null, (BValue)this.refreshButton);
        buttonGrid.add((String)null, (BValue)this.disconnectSettingsButton);
        BEdgePane edgePane = new BEdgePane(null, (BWidget)buttonGrid, null, null, (BWidget)borderPane);
        BNe2DeviceExt usbExt = ne2LinkService.getUsbDevice().getUsbDeviceExt();
        if (!usbExt.getHostModel().equals("Workstation")) {
            Object[] objectArray = new Object[1];
            usbExt.getClass();
            objectArray[0] = 2;
            BLabel infoLabel = new BLabel(LEX.getText("Ne2LinkServiceView.InfoLabel", objectArray));
            edgePane.setTop((BWidget)infoLabel);
        }
        this.setContent((BWidget)edgePane);
        this.enableButtons();
    }

    public void enableButtons() {
        BComponent[] selectedComponents = this.getTable().getSelectedComponents();
        BComponent[] allComponents = this.getModel().getRows();
        boolean anySelectedConnected = Arrays.stream(selectedComponents).anyMatch(component -> Objects.requireNonNull(Ne2LinkServiceTableModel.getCommunicationSettings(component)).getStatus().getOrdinal() == 0);
        boolean anyConnected = Arrays.stream(allComponents).anyMatch(component -> Objects.requireNonNull(Ne2LinkServiceTableModel.getCommunicationSettings(component)).getStatus().getOrdinal() == 0);
        if (anyConnected) {
            ((BNe2LinkServiceView)this.getModel().view).disconnectAllButton.setEnabled(true);
        } else {
            ((BNe2LinkServiceView)this.getModel().view).disconnectAllButton.setEnabled(false);
        }
        if (anySelectedConnected) {
            ((BNe2LinkServiceView)this.getModel().view).disconnectSelectedButton.setEnabled(true);
        } else {
            ((BNe2LinkServiceView)this.getModel().view).disconnectSelectedButton.setEnabled(false);
        }
    }

    public Ne2LinkServiceTableModel getModel() {
        return this.model;
    }

    BComponentTable getTable() {
        return this.table;
    }

    public static interface AlignableCol {
        public BHalign getAlignment();
    }

    public static class Ne2LinkTableCellRenderer
    extends TableCellRenderer {
        Ne2LinkTableCellRenderer() {
        }

        public void paintCell(Graphics g, TableCellRenderer.Cell cell) {
            Object cellValue = cell.value;
            if (cellValue instanceof BIcon || cellValue instanceof BImage) {
                TableModel model = this.getTable().getModel();
                BImage image = cellValue instanceof BIcon ? BImage.make((BIcon)((BIcon)cellValue)) : (BImage)cellValue;
                double x = 2.0;
                double y = (cell.height - image.getHeight()) / 2.0;
                switch (model.getColumnAlignment(cell.column).getOrdinal()) {
                    case 1: {
                        x = (cell.width - image.getWidth()) / 2.0;
                        break;
                    }
                    case 2: {
                        x = cell.width - 2.0 - image.getWidth();
                    }
                }
                this.paintCellBackground(g, cell);
                g.drawImage(image, x, y);
            } else {
                super.paintCell(g, cell);
            }
        }

        public double getPreferredCellWidth(TableCellRenderer.Cell cell) {
            Object cellValue = cell.value;
            if (cellValue instanceof BIcon || cellValue instanceof BImage) {
                BImage image = cellValue instanceof BIcon ? BImage.make((BIcon)((BIcon)cellValue)) : (BImage)cellValue;
                return image.getWidth() + 4.0;
            }
            return super.getPreferredCellWidth(cell);
        }
    }

    static class Ne2LinkServiceTableController
    extends ComponentTableController {
        Ne2LinkServiceTableController() {
        }

        public Ne2LinkServiceTableModel getModel() {
            return (Ne2LinkServiceTableModel)super.getModel();
        }

        protected void cellDoubleClicked(BMouseEvent event, int rowIndex, int colIndex) {
            if (this.isHyperlinkOnDoubleClick()) {
                BComponent component = this.getModel().getComponentAt(rowIndex);
                BNe2DeviceExt ne2DeviceExt = Ne2LinkServiceTableModel.getNe2DeviceExt(component);
                BWidgetShell shell = this.getTable().getShell();
                BOrd targetOrd = BOrd.make((BOrd)ne2DeviceExt.getNavOrd(), (String)("view:" + BInfo.TYPE.getTypeSpec().toString()));
                if (shell instanceof BWbShell) {
                    ((BWbShell)shell).hyperlink(targetOrd);
                }
            }
        }

        protected void cellPressed(BMouseEvent event, int row, int column) {
            super.cellPressed(event, row, column);
            ((BNe2LinkServiceView)this.getModel().view).enableButtons();
        }

        public BMenu makePopup(ComponentTableSubject subject) {
            BTable table = this.getTable();
            if (subject.size() > 1) {
                boolean anyConnected = Arrays.stream(subject.getComponents()).anyMatch(component -> Objects.requireNonNull(Ne2LinkServiceTableModel.getCommunicationSettings(component)).getStatus().getOrdinal() == 0);
                if (anyConnected) {
                    BMenu menu = new BMenu();
                    menu.add("disconnectSelected", ((BNe2LinkServiceView)this.getModel().view).disconnectSelectedButton.getCommand());
                    return menu;
                }
                return null;
            }
            int rowIndex = subject.getActiveRow();
            BComponent activeComponent = this.getModel().getComponentAt(rowIndex);
            BNe2DeviceExt activeNe2DeviceExt = Ne2LinkServiceTableModel.getNe2DeviceExt(activeComponent);
            if (activeNe2DeviceExt != null) {
                BMenu menu = NavMenuUtil.makeMenu((BWidget)table, (BObject)activeNe2DeviceExt);
                menu.removeItem("cut");
                menu.removeItem("copy");
                menu.removeItem("paste");
                menu.removeItem("duplicate");
                menu.removeItem("rename");
                menu.removeItem("delete");
                return menu;
            }
            return null;
        }
    }

    public static class Ne2LinkServiceTableModel
    extends ComponentTableModel
    implements BWbComponentView.Attachable {
        BWbComponentView view;
        static String INVALID_COL_VALUE = "--";
        ComponentTableModel.Column[] columns = new ComponentTableModel.Column[0];

        Ne2LinkServiceTableModel(ComponentTableModel.Column[] columns) {
            super(columns);
            this.columns = columns;
        }

        public void attached(BWbComponentView view) {
            this.view = view;
        }

        public void detached(BWbComponentView view) {
            this.view = null;
        }

        public void handleComponentEvent(BComponentEvent componentEvent) {
            if (componentEvent.getId() == 0 && (componentEvent.getSourceComponent().getType().is(BNanoConfigComms.TYPE) || componentEvent.getSourceComponent().getType().is(BNe2DeviceExt.TYPE) && componentEvent.getSlot().equals((Object)BNe2DeviceExt.applicationIsLoading))) {
                this.updateTable();
                ((BNe2LinkServiceView)this.view).enableButtons();
            }
        }

        public void initRows(BNe2LinkService ne2LinkService) {
            BOrdList nanoDeviceOrds = ne2LinkService.getNe2DeviceExtParents();
            BatchResolve br = new BatchResolve(nanoDeviceOrds.toArray());
            BComponent[] nE2DeviceExtOwners = br.resolve((BObject)ne2LinkService).getTargetComponents();
            this.setRows(nE2DeviceExtOwners);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setRows(BComponent[] components) {
            Ne2LinkServiceTableModel ne2LinkServiceTableModel = this;
            synchronized (ne2LinkServiceTableModel) {
                this.removeAllRows();
                for (BComponent component : components) {
                    this.addRow(component);
                }
            }
            this.updateTable(true);
        }

        public void addRow(BComponent component) {
            this.registerForComponentEvent(component);
            super.addRow(component);
        }

        public void removeAllRows() {
            for (int rowIndex = 0; rowIndex < this.getRowCount(); ++rowIndex) {
                BComponent component = this.getComponentAt(rowIndex);
                this.unregisterForComponentEvents(component);
            }
            super.removeAllRows();
        }

        public boolean removeRow(BComponent component) {
            this.unregisterForComponentEvents(component);
            return super.removeRow(component);
        }

        public void setColumns(ComponentTableModel.Column[] columns) {
            this.columns = columns;
            super.setColumns(columns);
        }

        public ComponentTableModel.Column getColumn(int col) {
            return this.columns[col];
        }

        protected void registerForComponentEvent(BComponent component) {
            BNe2DeviceExt nE2DeviceExt;
            if (this.view == null) {
                throw new IllegalStateException("Call initRows() before calling registerForComponentEvents");
            }
            component.loadSlots();
            if (!this.view.isRegisteredForComponentEvents(component)) {
                this.view.registerForComponentEvents(component);
            }
            if ((nE2DeviceExt = Ne2LinkServiceTableModel.getNe2DeviceExt(component)) != null) {
                nE2DeviceExt.loadSlots();
                if (!this.view.isRegisteredForComponentEvents((BComponent)nE2DeviceExt)) {
                    this.view.registerForComponentEvents((BComponent)nE2DeviceExt);
                }
                nE2DeviceExt.getConfig().loadSlots();
                BNanoConfigComms communicationSettings = Ne2LinkServiceTableModel.getCommunicationSettings(component);
                communicationSettings.loadSlots();
                BSoftwareManager softwareManager = Ne2LinkServiceTableModel.getSoftwareManager(component);
                softwareManager.loadSlots();
                if (!this.view.isRegisteredForComponentEvents((BComponent)communicationSettings)) {
                    this.view.registerForComponentEvents((BComponent)communicationSettings);
                }
                if (!this.view.isRegisteredForComponentEvents((BComponent)softwareManager)) {
                    this.view.registerForComponentEvents((BComponent)softwareManager);
                }
            }
        }

        protected void unregisterForComponentEvents(BComponent component) {
            if (this.view == null) {
                throw new IllegalStateException("Call initRows() before calling unregisterForComponentEvents");
            }
            this.view.unregisterForComponentEvents(component);
            BNe2DeviceExt deviceExt = Ne2LinkServiceTableModel.getNe2DeviceExt(component);
            if (deviceExt != null) {
                this.view.unregisterForComponentEvents((BComponent)deviceExt);
                this.view.unregisterForComponentEvents((BComponent)Ne2LinkServiceTableModel.getCommunicationSettings(component));
                this.view.unregisterForComponentEvents((BComponent)Ne2LinkServiceTableModel.getSoftwareManager(component));
            }
        }

        public BHalign getColumnAlignment(int col) {
            ComponentTableModel.Column column = this.getColumn(col);
            if (column instanceof AlignableCol) {
                return ((AlignableCol)column).getAlignment();
            }
            return super.getColumnAlignment(col);
        }

        static BNe2DeviceExt getNe2DeviceExt(BComponent component) {
            BNe2DeviceExt[] nE2DeviceExts = (BNe2DeviceExt[])component.getChildren(BNe2DeviceExt.class);
            if (nE2DeviceExts.length > 0) {
                return nE2DeviceExts[0];
            }
            return null;
        }

        private static BNanoConfigComms getCommunicationSettings(BComponent component) {
            BNe2DeviceExt ne2DeviceExt = Ne2LinkServiceTableModel.getNe2DeviceExt(component);
            if (ne2DeviceExt != null) {
                BNanoConfig config = ne2DeviceExt.getConfig();
                BNanoConfigComms configComms = config.getCommunicationSettings();
                return configComms;
            }
            return null;
        }

        private static BSoftwareManager getSoftwareManager(BComponent component) {
            BNe2DeviceExt ne2DeviceExt = Ne2LinkServiceTableModel.getNe2DeviceExt(component);
            if (ne2DeviceExt != null) {
                BSoftwareManager softwareManager = ne2DeviceExt.getSoftwareManager();
                return softwareManager;
            }
            return null;
        }

        public static class CommSettingsStatusIconCol
        implements ComponentTableModel.Column,
        AlignableCol {
            String name;
            BHalign alignment;

            public CommSettingsStatusIconCol(String displayName) {
                this(displayName, BHalign.center);
            }

            public CommSettingsStatusIconCol(String displayName, BHalign alignment) {
                this.name = displayName;
                this.alignment = alignment;
            }

            public String getName() {
                return this.name;
            }

            @Override
            public BHalign getAlignment() {
                return this.alignment;
            }

            public Object getValue(BComponent c) {
                BNanoConfigComms communicationSettings = Ne2LinkServiceTableModel.getCommunicationSettings(c);
                return communicationSettings != null ? communicationSettings.getStatus().getConnectionIcon(Objects.requireNonNull(Ne2LinkServiceTableModel.getNe2DeviceExt(c)).getApplicationIsLoading()) : INVALID_COL_VALUE;
            }
        }

        public static class CommSettingsStatusTextCol
        implements ComponentTableModel.Column,
        AlignableCol {
            String name;
            BHalign alignment;

            public CommSettingsStatusTextCol(String displayName) {
                this(displayName, BHalign.left);
            }

            public CommSettingsStatusTextCol(String displayName, BHalign alignment) {
                this.name = displayName;
                this.alignment = alignment;
            }

            public String getName() {
                return this.name;
            }

            @Override
            public BHalign getAlignment() {
                return this.alignment;
            }

            public Object getValue(BComponent c) {
                BNanoConfigComms communicationSettings = Ne2LinkServiceTableModel.getCommunicationSettings(c);
                return communicationSettings != null ? communicationSettings.getStatus().getDisplayText(Objects.requireNonNull(Ne2LinkServiceTableModel.getNe2DeviceExt(c)).getApplicationIsLoading()) : INVALID_COL_VALUE;
            }
        }

        public static class CommSettingsAddressCol
        implements ComponentTableModel.Column,
        AlignableCol {
            String name;
            BHalign alignment;

            public CommSettingsAddressCol(String displayName) {
                this(displayName, BHalign.left);
            }

            public CommSettingsAddressCol(String displayName, BHalign alignment) {
                this.name = displayName;
                this.alignment = alignment;
            }

            public String getName() {
                return this.name;
            }

            public Object getValue(BComponent c) {
                BNanoConfigComms communicationSettings = Ne2LinkServiceTableModel.getCommunicationSettings(c);
                return communicationSettings != null ? communicationSettings.getAddress() : INVALID_COL_VALUE;
            }

            @Override
            public BHalign getAlignment() {
                return this.alignment;
            }
        }

        public static class SoftwareManagerPropCol
        extends ComponentTableModel.PropertyColumn
        implements AlignableCol {
            BHalign alignment;
            Context context;

            public SoftwareManagerPropCol(String displayName, Property prop, Context context) {
                this(displayName, prop, BHalign.left, context);
            }

            public SoftwareManagerPropCol(String displayName, Property prop, BHalign alignment, Context context) {
                super(displayName, prop);
                this.alignment = alignment;
                this.context = context;
            }

            @Override
            public BHalign getAlignment() {
                return this.alignment;
            }

            public Object getValue(BComponent c) {
                BasicContext formatContext;
                BSoftwareManager swm = Ne2LinkServiceTableModel.getSoftwareManager(c);
                BasicContext basicContext = formatContext = this.context != null ? new BasicContext(this.context, this.prop.getFacets()) : null;
                return swm != null ? (this.prop.getType().is(BNumber.TYPE) && formatContext != null ? swm.get(this.prop).toString((Context)formatContext) : swm.get(this.prop)) : INVALID_COL_VALUE;
            }
        }

        public static class CommSettingsPropCol
        extends ComponentTableModel.PropertyColumn
        implements AlignableCol {
            BHalign alignment;

            public CommSettingsPropCol(String displayName, Property prop) {
                this(displayName, prop, BHalign.left);
            }

            public CommSettingsPropCol(String displayName, Property prop, BHalign alignment) {
                super(displayName, prop);
                this.alignment = alignment;
            }

            public Object getValue(BComponent c) {
                BNanoConfigComms communicationSettings = Ne2LinkServiceTableModel.getCommunicationSettings(c);
                return communicationSettings != null ? communicationSettings.get(this.prop) : INVALID_COL_VALUE;
            }

            @Override
            public BHalign getAlignment() {
                return this.alignment;
            }
        }

        public static class FormatCol
        implements ComponentTableModel.Column,
        AlignableCol {
            String name;
            BFormat format;
            BHalign alignment;

            public FormatCol(String displayName, BFormat format) {
                this(displayName, format, BHalign.left);
            }

            public FormatCol(String displayName, BFormat format, BHalign alignment) {
                this.name = displayName;
                this.format = format;
                this.alignment = alignment;
            }

            public String getName() {
                return this.name;
            }

            @Override
            public BHalign getAlignment() {
                return this.alignment;
            }

            public Object getValue(BComponent c) {
                return this.format.format((Object)c);
            }
        }

        public static class Ne2DeviceExtPropCol
        extends ComponentTableModel.PropertyColumn
        implements AlignableCol {
            BHalign alignment;

            public Ne2DeviceExtPropCol(String displayName, Property prop) {
                this(displayName, prop, BHalign.left);
            }

            public Ne2DeviceExtPropCol(String displayName, Property prop, BHalign alignment) {
                super(displayName, prop);
                this.alignment = alignment;
            }

            @Override
            public BHalign getAlignment() {
                return this.alignment;
            }

            public Object getValue(BComponent c) {
                BNe2DeviceExt ne2DeviceExt = Ne2LinkServiceTableModel.getNe2DeviceExt(c);
                return ne2DeviceExt != null ? ne2DeviceExt.get(this.prop) : INVALID_COL_VALUE;
            }
        }

        public static class DisplayNameCol
        implements ComponentTableModel.Column,
        AlignableCol {
            String name;
            BHalign alignment;

            public DisplayNameCol(String displayName) {
                this(displayName, BHalign.left);
            }

            public DisplayNameCol(String displayName, BHalign alignment) {
                this.alignment = alignment;
                this.name = displayName;
            }

            @Override
            public BHalign getAlignment() {
                return this.alignment;
            }

            public String getName() {
                return this.name;
            }

            public Object getValue(BComponent c) {
                if (c.getType().is(BBacnetDevice.TYPE) || c.getType().is(BModbusTcpDevice.TYPE) || c.getType().is(BNe2UsbDevice.TYPE)) {
                    return c.getDisplayName(null);
                }
                return LEX.get("Ne2LinkService.usbDevice.displayName", "") + " @ " + c.getDisplayName(null);
            }
        }
    }

    static class RefreshCommand
    extends Command {
        public RefreshCommand(BNe2LinkServiceView view) {
            super((BWidget)view, LEX, "Ne2LinkServiceView.refreshCmd");
        }

        public BNe2LinkServiceView getView() {
            return (BNe2LinkServiceView)this.getOwner();
        }

        public CommandArtifact doInvoke() throws Exception {
            BWbShell shell = this.getView().getWbShell();
            if (shell != null) {
                shell.getRefreshCommand().invoke();
            }
            return null;
        }
    }

    static class DisconnectAllCommand
    extends Command {
        public DisconnectAllCommand(BNe2LinkServiceView view) {
            super((BWidget)view, LEX, "Ne2LinkServiceView.disconnectAllCmd");
        }

        public BNe2LinkServiceView getView() {
            return (BNe2LinkServiceView)this.getOwner();
        }

        public CommandArtifact doInvoke() throws Exception {
            BComponent[] components;
            for (BComponent component : components = this.getView().getTable().getComponentModel().getRows()) {
                BNe2DeviceExt deviceExt = Ne2LinkServiceTableModel.getNe2DeviceExt(component);
                if (!deviceExt.isConnected().getBoolean()) continue;
                deviceExt.disconnect();
            }
            return null;
        }
    }

    static class DisconnectSelectedCommand
    extends Command {
        public DisconnectSelectedCommand(BNe2LinkServiceView view) {
            super((BWidget)view, LEX, "Ne2LinkServiceView.disconnectSelectedCmd");
        }

        public BNe2LinkServiceView getView() {
            return (BNe2LinkServiceView)this.getOwner();
        }

        public CommandArtifact doInvoke() throws Exception {
            BComponent[] selectedComponents;
            for (BComponent selectedComponent : selectedComponents = this.getView().getTable().getSelectedComponents()) {
                BNe2DeviceExt deviceExt = Ne2LinkServiceTableModel.getNe2DeviceExt(selectedComponent);
                if (deviceExt == null) continue;
                deviceExt.disconnect();
            }
            return null;
        }
    }
}

