/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.nE2Link.ui;

import com.ismacontrolli.nE2Link.BNe2DeviceExt;
import com.ismacontrolli.nE2Link.actions.BInstallUninstallSoftwareManagerArgs;
import com.ismacontrolli.nE2Link.ui.BNanoSelectVersionDialog;
import com.ismacontrolli.nE2Link.ui.NanoSoftwareManagerTableModel;
import com.ismacontrolli.nE2Link.utils.BSoftwareManager;
import com.ismacontrolli.nE2Link.utils.BUpgradingStatus;
import com.ismacontrolli.nE2Link.utils.OsUpdateHelper;
import com.ismacontrolli.nE2Link.utils.javabeans.LibraryComp;
import com.tridium.ui.theme.Theme;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.style.IStylable;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableHeaderRenderer;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.TableSelection;
import javax.baja.util.Lexicon;
import javax.baja.workbench.view.BWbComponentView;

@NiagaraType(agent={@AgentOn(types={"nE2Link:SoftwareManager"}, defaultAgent=AgentOn.Preference.PREFERRED)})
public class BNanoSoftwareManager
extends BWbComponentView {
    public static final Type TYPE = Sys.loadType(BNanoSoftwareManager.class);
    BSoftwareManager softwareManager = null;
    BNe2DeviceExt ne2DeviceExt = null;
    NanoSoftwareManagerTableModel softwareManagerModel = null;
    BTable softwareManagerTable = null;
    UpgradeAllCmd upgradeAllCmd = null;
    UpdateDeviceCmd updateDeviceCmd = null;
    protected static final Lexicon lex = Lexicon.make(BNanoSoftwareManager.class);
    BDialog upgradeAllInProgressDlg = null;
    BDialog updateDeviceInProgressDlg = null;
    boolean upgradeIsHappening = false;
    final int onDeviceColumn = 0;
    final int nameColumn = 1;
    final int latestLocalColumn = 2;
    final int installedColumn = 3;
    final int selectedColumn = 4;
    final int statusColumn = 5;
    BDialog InProgressDlg = null;
    private final String install = lex.get("NanoSoftwareManager.install", "Install");
    private final String uninstall = lex.get("NanoSoftwareManager.uninstall", "Uninstall");
    private final String latest = lex.get("NanoSoftwareManager.latest", "Latest");
    private final String outOfDate = lex.get("NanoSoftwareManager.outOfDate", "Out Of Date");
    private final String upgrade = lex.get("NanoSoftwareManager.upgrade", "Upgrade");
    private final String downgrade = lex.get("NanoSoftwareManager.downgrade", "Downgrade");
    private final String notLoaded = lex.get("NanoSoftwareManager.notLoaded", "Not Loaded");
    private final String partOfOs = lex.get("NanoSoftwareManager.partOfOS", "part of OS");

    public Type getType() {
        return TYPE;
    }

    public void doLoadValue(BObject value, Context context) throws Exception {
        super.doLoadValue(value, context);
        this.softwareManager = (BSoftwareManager)value;
        this.ne2DeviceExt = (BNe2DeviceExt)this.softwareManager.getParent();
        boolean emergency = this.ne2DeviceExt.isDeviceInEmergencyMode();
        this.upgradeAllCmd = new UpgradeAllCmd((BWidget)this, true);
        this.updateDeviceCmd = new UpdateDeviceCmd((BWidget)this, false);
        BGridPane commandsPane = new BGridPane(2, new BWidget[]{new BButton((Command)this.upgradeAllCmd, true, true), new BButton((Command)this.updateDeviceCmd, true, true)});
        commandsPane.setHalign(BHalign.right);
        this.softwareManagerModel = new NanoSoftwareManagerTableModel(this.ne2DeviceExt, new String[]{"On Device", "Name", "Latest Local", "Installed", "Selected", "Status"});
        this.softwareManagerTable = new BTable((TableModel)this.softwareManagerModel, (TableController)new NanoSoftwareManagerTableController(this.softwareManager, this.softwareManagerModel), new TableSelection(), new TableHeaderRenderer(), (TableCellRenderer)new NanoTableCellRenderer());
        BEdgePane softwareManagerPane = new BEdgePane();
        softwareManagerPane.setTop((BWidget)new BBorderPane((BWidget)commandsPane, BBorder.inset, BInsets.make((double)10.0, (double)0.0, (double)0.0, (double)10.0)));
        softwareManagerPane.setCenter((BWidget)new BBorderPane((BWidget)this.softwareManagerTable, BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0)));
        this.setContent((BWidget)softwareManagerPane);
        this.registerForComponentEvents((BComponent)this.softwareManager);
        BUpgradingStatus upgradeProp = (BUpgradingStatus)this.softwareManager.get("upgradeProp");
        if (upgradeProp != null && upgradeProp == BUpgradingStatus.inProgress) {
            this.showPopUp();
        }
        if (emergency) {
            this.updateDeviceCmd.setEnabled(false);
            this.upgradeAllCmd.setEnabled(false);
            this.softwareManagerTable.setEnabled(false);
        } else {
            this.updateDeviceCmd.setEnabled(true);
            this.upgradeAllCmd.setEnabled(true);
            this.softwareManagerTable.setEnabled(true);
        }
    }

    public void handleComponentEvent(BComponentEvent event) {
        BUpgradingStatus value;
        int eventId = event.getId();
        if (eventId == 0) {
            if (event.getSlotName().equals("upgradeProp")) {
                BUpgradingStatus value2 = (BUpgradingStatus)event.getValue();
                switch (value2.getOrdinal()) {
                    case 2: 
                    case 3: {
                        this.upgradeIsHappening = false;
                        this.closePopUp();
                        break;
                    }
                    case 1: {
                        this.showPopUp();
                        break;
                    }
                    case 0: {
                        this.closePopUp();
                    }
                }
            }
        } else if (eventId == 1 && event.getSlotName().equals("upgradeProp") && (value = (BUpgradingStatus)event.getValue()) == BUpgradingStatus.inProgress) {
            this.showPopUp();
        }
        super.handleComponentEvent(event);
    }

    private void showPopUp() {
        Thread t = new Thread(() -> {
            if (this.InProgressDlg == null) {
                this.InProgressDlg = new BDialog((BWidget)this, lex.get("SoftwareManager.Header.inProgress"), true, (BWidget)new BLabel(lex.get("SoftwareManager.Text.inProgress")));
                this.InProgressDlg.setBoundsCenteredOnOwner();
                this.InProgressDlg.open(this.InProgressDlg.getScreenBounds().x(), this.InProgressDlg.getScreenBounds().y(), 250.0, 100.0);
            }
        });
        t.start();
    }

    private void closePopUp() {
        if (this.InProgressDlg != null && this.InProgressDlg.isRunning()) {
            this.InProgressDlg.close();
            this.InProgressDlg = null;
        }
    }

    private String getLowestVersion(String version) {
        if (OsUpdateHelper.compareVersions((String)version, (String)"1.8.0.0") >= 0) {
            return "1.8.0.0";
        }
        return "1.7.0.0";
    }

    class UpdateDeviceCmd
    extends Command {
        private BNanoSoftwareManager manager;

        UpdateDeviceCmd(BWidget manager, boolean enabled) {
            super(manager, "Update Device");
            this.manager = (BNanoSoftwareManager)manager;
            this.setEnabled(enabled);
        }

        public CommandArtifact doInvoke() throws Exception {
            BNanoSoftwareManager.this.softwareManager.loadSlots();
            StringBuilder sb = new StringBuilder(BNanoSoftwareManager.this.softwareManager.getIpAddress()).append(":").append(BNanoSoftwareManager.this.softwareManager.getIFnetPort());
            int confirm = BDialog.confirm((BWidget)this.manager, (String)sb.toString(), (Object)lex.get("NanoSoftwareManager.messageConfirmUpdate"));
            if (confirm != 4) {
                return null;
            }
            String filesToInstall = "";
            String filesToUninstall = "";
            for (int i = 0; i < this.manager.softwareManagerModel.getRowCount(); ++i) {
                String installedVersion = this.manager.softwareManagerModel.getValueAt(i, 3).toString();
                String selectedVersion = this.manager.softwareManagerModel.getValueAt(i, 4).toString();
                String statusValue = this.manager.softwareManagerModel.getValueAt(i, 5).toString();
                String libName = this.manager.softwareManagerModel.getValueAt(i, 1).toString();
                if (statusValue.equals(BNanoSoftwareManager.this.install) || statusValue.equals(BNanoSoftwareManager.this.upgrade) || statusValue.equals(BNanoSoftwareManager.this.downgrade) || statusValue.equals(BNanoSoftwareManager.this.outOfDate)) {
                    if (selectedVersion.equals("")) continue;
                    boolean isOs = libName.equals("OS");
                    if (isOs && BNanoSoftwareManager.this.softwareManager.shouldBlockVersionChange(installedVersion, selectedVersion)) {
                        BDialog.error((BWidget)this.manager, (String)lex.get("SOFTWARE_MANAGER_TITLE", "Software Manager"), (Object)lex.getText("NanoSoftwareManager.messageDowngradeNotPossible", new Object[]{BNanoSoftwareManager.this.getLowestVersion(installedVersion)}));
                        return null;
                    }
                    String folderName = isOs ? "" : libName + "/";
                    String fileName = isOs ? "os" : libName;
                    String extension = isOs ? ".bin" : ".pe";
                    sb = new StringBuilder(folderName).append(fileName).append("-").append(selectedVersion).append(extension);
                    filesToInstall = filesToInstall + sb + ";";
                }
                if (!statusValue.equals(BNanoSoftwareManager.this.uninstall)) continue;
                sb = new StringBuilder(libName).append(".pe");
                filesToUninstall = filesToUninstall + sb + ";";
            }
            BNanoSoftwareManager.this.softwareManager.installAndUninstallFiles(new BInstallUninstallSoftwareManagerArgs(filesToInstall, filesToUninstall));
            return null;
        }
    }

    class UpgradeAllCmd
    extends Command {
        private BNanoSoftwareManager manager;

        UpgradeAllCmd(BWidget manager, boolean enabled) {
            super(manager, "Upgrade All");
            this.manager = (BNanoSoftwareManager)manager;
            this.setEnabled(enabled);
        }

        public CommandArtifact doInvoke() {
            BNanoSoftwareManager.this.softwareManager.loadSlots();
            boolean upgradeAll = false;
            NanoSoftwareManagerTableModel softwareManagerModel = this.manager.softwareManagerModel;
            for (int i = 0; i < softwareManagerModel.getRowCount(); ++i) {
                String selectedVersion = softwareManagerModel.getValueAt(i, 4).toString();
                String statusValue = softwareManagerModel.getValueAt(i, 5).toString();
                String libName = softwareManagerModel.getValueAt(i, 1).toString();
                String onDevice = softwareManagerModel.getValueAt(i, 0).toString();
                if (!onDevice.equals("true:readonly") && !onDevice.equals("true")) continue;
                Optional<LibraryComp> optional = softwareManagerModel.getLocalLibraries().stream().filter(f -> f.getNanoName().equals(libName)).findFirst();
                if (!optional.isPresent()) {
                    optional = softwareManagerModel.getOsLibraries().stream().filter(f -> f.getNanoName().equals(libName)).findFirst();
                }
                if (!optional.isPresent()) {
                    optional = softwareManagerModel.getOnDeviceLibraries().stream().filter(f -> f.getNanoName().equals(libName)).findFirst();
                }
                if (!optional.isPresent() || !statusValue.contains(BNanoSoftwareManager.this.outOfDate)) continue;
                LibraryComp libComp = optional.get();
                String latestLocal = libComp.getLatestLocal();
                softwareManagerModel.set(i, 4, latestLocal);
                softwareManagerModel.set(i, 5, BNanoSoftwareManager.this.upgrade);
                upgradeAll = true;
            }
            if (upgradeAll) {
                BNanoSoftwareManager.this.updateDeviceCmd.setEnabled(true);
            }
            return null;
        }
    }

    public class BLabelButton
    extends BButton {
        public BLabelButton(String text) {
            super(text);
            this.setForeground(BBrush.make((String)String.valueOf(BColor.blue)));
            this.setHalign(BHalign.left);
        }

        public void keyPressed(BKeyEvent event) {
        }

        public boolean isMouseOver() {
            return false;
        }

        public boolean isPressed() {
            return false;
        }
    }

    class NanoTableCellRenderer
    extends TableCellRenderer {
        NanoTableCellRenderer() {
        }

        public BBrush getForeground(TableCellRenderer.Cell cell) {
            TableModel model = this.getTable().getModel();
            if (model.equals((Object)BNanoSoftwareManager.this.softwareManagerModel)) {
                Object obj = model.getValueAt(cell.row, 5);
                if (obj.toString().contains(BNanoSoftwareManager.this.latest)) {
                    return BBrush.make((String)String.valueOf(BColor.green));
                }
                if (obj.toString().contains(BNanoSoftwareManager.this.install) || obj.toString().contains(BNanoSoftwareManager.this.downgrade) || obj.toString().contains(BNanoSoftwareManager.this.upgrade)) {
                    return BBrush.make((String)String.valueOf(BColor.blue));
                }
                if (obj.toString().contains(BNanoSoftwareManager.this.outOfDate)) {
                    return BBrush.make((String)String.valueOf(BColor.darkGoldenrod));
                }
                if (obj.toString().contains(BNanoSoftwareManager.this.notLoaded)) {
                    return BBrush.make((String)String.valueOf(BColor.lightCoral));
                }
            }
            return Theme.table().getTextBrush((IStylable)this.getTable());
        }

        public double getPreferredCellWidth(TableCellRenderer.Cell cell) {
            TableModel model = this.getTable().getModel();
            return this.getTable().getWidth() / (double)model.getColumnCount();
        }

        public void paintCell(Graphics g, TableCellRenderer.Cell cell) {
            TableModel model = this.getTable().getModel();
            if (model.equals((Object)BNanoSoftwareManager.this.softwareManagerModel)) {
                if (cell.column > 0) {
                    super.paintCell(g, cell);
                } else {
                    this.paintCellBackground(g, cell);
                    double x = 2.0;
                    double y = (cell.height - 16.0) / 2.0;
                    BImage icon = model.getRowIcon(cell.row);
                    if (icon != null) {
                        g.drawImage(icon, x, y);
                        x += 20.0;
                    } else {
                        x += 20.0;
                    }
                    String s = this.getCellText(cell);
                    BFont font = this.getFont(cell);
                    switch (model.getColumnAlignment(cell.column).getOrdinal()) {
                        case 1: {
                            x = (cell.width - font.width(s)) / 2.0;
                            break;
                        }
                        case 2: {
                            x = cell.width - 2.0 - font.width(s);
                        }
                    }
                    g.setFont(font);
                    if (cell.selected) {
                        g.setBrush(this.getSelectionForeground(cell));
                    } else {
                        g.setBrush(this.getForeground(cell));
                    }
                    BImage cb = s.equals("true:readonly") ? BImage.make((BIcon)BIcon.std((String)"widgets/checkBox.png")) : BImage.make((BIcon)(s.equals("true") ? BIcon.std((String)"widgets/checkBox.png") : BIcon.std((String)"widgets/insetPane.png")));
                    g.drawImage(cb, x, y);
                }
            } else {
                super.paintCell(g, cell);
            }
        }
    }

    public class NanoSoftwareManagerTableController
    extends TableController {
        private BSoftwareManager softwareManager;
        private NanoSoftwareManagerTableModel tableModel;

        NanoSoftwareManagerTableController() {
        }

        NanoSoftwareManagerTableController(BSoftwareManager softwareManager, NanoSoftwareManagerTableModel softwareManagerModel) {
            this.softwareManager = softwareManager;
            this.tableModel = softwareManagerModel;
        }

        protected void cellPressed(BMouseEvent event, int row, int col) {
            Object obj = this.tableModel.getValueAt(row, col);
            switch (col) {
                case 0: {
                    this.librarySelectionChanged(row, obj);
                    break;
                }
                case 4: {
                    this.selectedVersionChanged(row);
                    break;
                }
            }
            super.cellPressed(event, row, col);
            boolean enabled = false;
            for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
                obj = this.tableModel.getValueAt(i, 4);
                if (!obj.toString().equals("")) {
                    enabled = true;
                    break;
                }
                obj = this.tableModel.getValueAt(i, 5);
                if (!obj.toString().equals(BNanoSoftwareManager.this.uninstall)) continue;
                enabled = true;
                break;
            }
            BNanoSoftwareManager.this.updateDeviceCmd.setEnabled(enabled);
        }

        private void librarySelectionChanged(int row, Object obj) {
            String selected;
            String onDevice;
            if (obj.toString().contains("readonly")) {
                return;
            }
            String status = "";
            String latestLocal = this.tableModel.getValueAt(row, 2).toString();
            String installedVersion = this.tableModel.getValueAt(row, 3).toString();
            String libName = this.tableModel.getValueAt(row, 1).toString();
            if (obj.toString().equals("true")) {
                onDevice = "false";
                selected = "";
                if (this.isLibOnDevice(libName) || this.isLibNotLoaded(libName)) {
                    status = BNanoSoftwareManager.this.uninstall;
                }
            } else {
                onDevice = "true";
                selected = latestLocal.equals(installedVersion) ? "" : latestLocal;
                status = this.getStatus(libName, selected, installedVersion, row);
            }
            this.tableModel.set(row, 0, onDevice);
            this.tableModel.set(row, 4, selected);
            this.tableModel.set(row, 5, status);
        }

        private void selectedVersionChanged(int row) {
            List<String> libVersions;
            Object obj = this.tableModel.getValueAt(row, 0);
            String libName = this.tableModel.getValueAt(row, 1).toString();
            if (!obj.toString().contains("true") || obj.toString().equals("true:readonly") && !libName.equals("OS") || (libVersions = this.getVersions(libName)) == null) {
                return;
            }
            BNanoSelectVersionDialog selectVersionDialog = new BNanoSelectVersionDialog();
            String selectedVersion = selectVersionDialog.prompt((BWidget)BNanoSoftwareManager.this, lex.get("NanoSoftwareManager.messageSelectVersion"), libVersions);
            String installedVersion = this.tableModel.getValueAt(row, 3).toString();
            if (OsUpdateHelper.compareVersions((String)installedVersion, (String)selectedVersion) == 0) {
                selectedVersion = "";
            }
            this.tableModel.set(row, 4, selectedVersion);
            String status = this.getStatus(libName, selectedVersion, installedVersion, row);
            this.tableModel.set(row, 5, status);
            if (!libName.equals("OS")) {
                return;
            }
            for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
                if (!this.tableModel.getValueAt(i, 5).toString().contains(BNanoSoftwareManager.this.partOfOs)) continue;
                this.tableModel.set(i, 5, status + ", " + BNanoSoftwareManager.this.partOfOs);
            }
        }

        private String getStatus(String libName, String selectedVersion, String installedVersion, int row) {
            if (installedVersion.equals("")) {
                if (selectedVersion.equals("")) {
                    return this.isLibNotLoaded(libName) ? BNanoSoftwareManager.this.notLoaded : "";
                }
                return BNanoSoftwareManager.this.install;
            }
            if (!selectedVersion.equals("")) {
                if (OsUpdateHelper.compareVersions((String)installedVersion, (String)selectedVersion) > 0) {
                    return BNanoSoftwareManager.this.downgrade;
                }
                if (OsUpdateHelper.compareVersions((String)installedVersion, (String)selectedVersion) < 0) {
                    return BNanoSoftwareManager.this.upgrade;
                }
                return "";
            }
            String latestLocal = this.tableModel.getValueAt(row, 2).toString();
            if (OsUpdateHelper.compareVersions((String)latestLocal, (String)installedVersion) > 0) {
                return BNanoSoftwareManager.this.outOfDate;
            }
            return BNanoSoftwareManager.this.latest;
        }

        private boolean isLibOnDevice(String libName) {
            return this.tableModel.getOnDeviceLibraries().stream().anyMatch(f -> f.getNanoName().equals(libName));
        }

        private boolean isLibNotLoaded(String libName) {
            return this.softwareManager.getNotLoadedLibs().contains(libName);
        }

        private List<String> getVersions(String libName) {
            Optional<LibraryComp> optional = this.tableModel.getLocalLibraries().stream().filter(f -> f.getNanoName().equals(libName)).findFirst();
            if (!optional.isPresent()) {
                optional = this.tableModel.getOsLibraries().stream().filter(f -> f.getNanoName().equals(libName)).findFirst();
            }
            if (!optional.isPresent()) {
                optional = this.tableModel.getOnDeviceLibraries().stream().filter(f -> f.getNanoName().equals(libName)).findFirst();
            }
            if (!optional.isPresent()) {
                return null;
            }
            LibraryComp libComp = optional.get();
            List versions = libComp.getVersions();
            versions.sort(Collections.reverseOrder());
            return versions;
        }
    }
}

