/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.nE2Link.ui;

import com.ismacontrolli.nE2Link.BNanoBaseComponent;
import com.ismacontrolli.nE2Link.BNanoComponent;
import com.ismacontrolli.nE2Link.BNanoConfigComms;
import com.ismacontrolli.nE2Link.BNe2DeviceExt;
import com.ismacontrolli.nE2Link.actions.BNanoPermanentSubscriptionArg;
import com.ismacontrolli.nE2Link.actions.BNanoPermanentUnsubscriptionArg;
import com.ismacontrolli.nE2Link.ui.BSwitchableView;
import com.ismacontrolli.nE2Link.utils.BConnectionStatus;
import com.ismacontrolli.nE2Link.utils.BSoftwareManager;
import java.util.ArrayList;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.gx.BSize;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BLabel;
import javax.baja.ui.BPicture;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BScaleMode;
import javax.baja.ui.enums.BScrollBarPolicy;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BCanvasPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BScrollPane;

@NiagaraType(agent={@AgentOn(types={"nE2Link:Ne2DeviceExt"})})
public class BInfo
extends BSwitchableView {
    public static final Type TYPE = Sys.loadType(BInfo.class);
    BNe2DeviceExt ne2DeviceExt;
    BNanoComponent systemComp;
    BNanoComponent platformComp;
    BNanoComponent performanceComp;
    BNanoComponent timeComp;
    BNanoComponent licenseComp;
    BSoftwareManager softwareManager;
    BLabel lblCommunicationStatus;
    BLabel lblStatus;
    BLabel lblDeviceName;
    BLabel lblDeviceModel;
    BLabel lblSerialNumber;
    BLabel lblOsVersion;
    BLabel lblIOs;
    BLabel lblInterfaces;
    BLabel lblCurrentTime;
    BLabel lblUptime;
    BLabel lblCpuLoad;
    BLabel lblAvailableDatapoints;
    BEnumRange deviceStatusRange;
    Context context;
    ArrayList<BNanoBaseComponent> subscribed = new ArrayList();

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public void doLoadValue(BObject value, Context context) throws Exception {
        super.doLoadValue(value, context);
        this.ne2DeviceExt = (BNe2DeviceExt)value;
        BCanvasPane picPane = new BCanvasPane();
        picPane.setViewSize(BSize.make((double)1200.0, (double)600.0));
        picPane.setScale(BScaleMode.fitRatio);
        BPicture pic = new BPicture();
        pic.setImage(BImage.make((String)"module://nE2Link/rc/images/info_page.png"));
        picPane.add(null, (BValue)pic);
        BGridPane deviceInfoPane = new BGridPane(2);
        BScrollPane scrollPane = new BScrollPane((BWidget)deviceInfoPane);
        scrollPane.setBorderPolicy(BScrollBarPolicy.asNeeded);
        scrollPane.setHpolicy(BScrollBarPolicy.never);
        deviceInfoPane.setRowAlign(BValign.top);
        deviceInfoPane.setRowGap(3.0);
        deviceInfoPane.setColumnAlign(BHalign.left);
        deviceInfoPane.setColumnGap(10.0);
        deviceInfoPane.setUniformColumnWidth(true);
        this.lblCommunicationStatus = new BLabel("", BHalign.left);
        BConstrainedPane cpCommunicationStatus = new BConstrainedPane((BWidget)this.lblCommunicationStatus);
        cpCommunicationStatus.setFixedSize(250.0, 20.0);
        this.updateCommunicationStatus();
        deviceInfoPane.add(null, (BValue)new BBorderPane((BWidget)cpCommunicationStatus, BBorder.make((int)6), BInsets.make((double)5.0)));
        this.lblStatus = new BLabel("", BHalign.left);
        BConstrainedPane cpStatus = new BConstrainedPane((BWidget)this.lblStatus);
        cpStatus.setFixedSize(250.0, 20.0);
        this.updateStatus();
        deviceInfoPane.add(null, (BValue)new BBorderPane((BWidget)cpStatus, BBorder.make((int)6), BInsets.make((double)5.0)));
        this.lblDeviceName = new BLabel("", BHalign.left);
        BConstrainedPane cpDeviceName = new BConstrainedPane((BWidget)this.lblDeviceName);
        cpDeviceName.setFixedSize(250.0, 20.0);
        this.updateDeviceName();
        deviceInfoPane.add(null, (BValue)new BBorderPane((BWidget)cpDeviceName, BBorder.make((int)6), BInsets.make((double)5.0)));
        this.lblDeviceModel = new BLabel("", BHalign.left);
        BConstrainedPane cpDeviceModel = new BConstrainedPane((BWidget)this.lblDeviceModel);
        cpDeviceModel.setFixedSize(250.0, 20.0);
        this.updateDeviceModel();
        deviceInfoPane.add(null, (BValue)new BBorderPane((BWidget)cpDeviceModel, BBorder.make((int)6), BInsets.make((double)5.0)));
        this.lblSerialNumber = new BLabel("", BHalign.left);
        BConstrainedPane cpSerialNumber = new BConstrainedPane((BWidget)this.lblSerialNumber);
        cpSerialNumber.setFixedSize(250.0, 20.0);
        this.updateSerialNumber();
        deviceInfoPane.add(null, (BValue)new BBorderPane((BWidget)cpSerialNumber, BBorder.make((int)6), BInsets.make((double)5.0)));
        this.lblOsVersion = new BLabel("", BHalign.left);
        BConstrainedPane cpOsVersion = new BConstrainedPane((BWidget)this.lblOsVersion);
        cpOsVersion.setFixedSize(250.0, 20.0);
        this.updateOsVersion();
        deviceInfoPane.add(null, (BValue)new BBorderPane((BWidget)cpOsVersion, BBorder.make((int)6), BInsets.make((double)5.0)));
        this.lblIOs = new BLabel("", BHalign.left);
        BConstrainedPane cpIOs = new BConstrainedPane((BWidget)this.lblIOs);
        cpIOs.setFixedSize(250.0, 20.0);
        this.updateIOs();
        deviceInfoPane.add(null, (BValue)new BBorderPane((BWidget)cpIOs, BBorder.make((int)6), BInsets.make((double)5.0)));
        this.lblInterfaces = new BLabel("", BHalign.left);
        BConstrainedPane cpInterfaces = new BConstrainedPane((BWidget)this.lblInterfaces);
        cpInterfaces.setFixedSize(250.0, 20.0);
        this.updateInterfaces();
        deviceInfoPane.add(null, (BValue)new BBorderPane((BWidget)cpInterfaces, BBorder.make((int)6), BInsets.make((double)5.0)));
        this.lblCurrentTime = new BLabel("", BHalign.left);
        BConstrainedPane cpCurrentTime = new BConstrainedPane((BWidget)this.lblCurrentTime);
        cpCurrentTime.setFixedSize(250.0, 20.0);
        this.updateCurrentTime();
        deviceInfoPane.add(null, (BValue)new BBorderPane((BWidget)cpCurrentTime, BBorder.make((int)6), BInsets.make((double)5.0)));
        this.lblUptime = new BLabel("", BHalign.left);
        BConstrainedPane cpUptime = new BConstrainedPane((BWidget)this.lblUptime);
        cpUptime.setFixedSize(250.0, 20.0);
        this.updateUptime();
        deviceInfoPane.add(null, (BValue)new BBorderPane((BWidget)cpUptime, BBorder.make((int)6), BInsets.make((double)5.0)));
        this.lblCpuLoad = new BLabel("", BHalign.left);
        BConstrainedPane cpCpuLoad = new BConstrainedPane((BWidget)this.lblCpuLoad);
        cpCpuLoad.setFixedSize(250.0, 20.0);
        this.updateCpuLoad();
        deviceInfoPane.add(null, (BValue)new BBorderPane((BWidget)cpCpuLoad, BBorder.make((int)6), BInsets.make((double)5.0)));
        this.lblAvailableDatapoints = new BLabel("", BHalign.left);
        BConstrainedPane cpAvailableDatapoints = new BConstrainedPane((BWidget)this.lblAvailableDatapoints);
        cpAvailableDatapoints.setFixedSize(250.0, 20.0);
        this.updateAvailableDatapoints();
        deviceInfoPane.add(null, (BValue)new BBorderPane((BWidget)cpAvailableDatapoints, BBorder.make((int)6), BInsets.make((double)5.0)));
        BGridPane globalPane = new BGridPane(1);
        globalPane.setRowGap(30.0);
        globalPane.setValign(BValign.center);
        globalPane.setColumnAlign(BHalign.center);
        globalPane.add(null, (BValue)picPane);
        globalPane.add(null, (BValue)scrollPane);
        BScrollPane content = new BScrollPane((BWidget)globalPane);
        content.setBorderPolicy(BScrollBarPolicy.asNeeded);
        content.setHpolicy(BScrollBarPolicy.asNeeded);
        this.setContent((BWidget)content);
        this.registerForComponentEvents((BComponent)this.ne2DeviceExt);
        this.registerRequiredComponents();
        this.updateAllInfo();
    }

    private boolean isApplicationLoaded() {
        return this.ne2DeviceExt.getConfig().getCommunicationSettings().getStatus().equals((Object)BConnectionStatus.connected) && !this.ne2DeviceExt.getApplicationIsLoading();
    }

    protected void registerRequiredComponents() {
        BNanoBaseComponent root;
        this.registerForComponentEvents((BComponent)this.ne2DeviceExt);
        this.softwareManager = this.ne2DeviceExt.getSoftwareManager();
        this.softwareManager.loadSlots();
        BNanoBaseComponent bNanoBaseComponent = root = this.isApplicationLoaded() ? (BNanoBaseComponent)this.ne2DeviceExt.get("Root") : null;
        if (root != null) {
            root.lease();
            ArrayList<BNanoComponent> componentsToSubscribe = new ArrayList<BNanoComponent>();
            this.systemComp = (BNanoComponent)root.get("System");
            this.systemComp.lease();
            componentsToSubscribe.add(this.systemComp);
            Property deviceStatusProperty = this.systemComp.getProperty("deviceStatus");
            this.deviceStatusRange = (BEnumRange)deviceStatusProperty.getFacets().getFacet("range");
            this.platformComp = (BNanoComponent)this.systemComp.get("Platform");
            this.platformComp.lease();
            componentsToSubscribe.add(this.platformComp);
            this.performanceComp = (BNanoComponent)this.platformComp.get("Performance");
            if (this.performanceComp != null) {
                this.performanceComp.lease();
                componentsToSubscribe.add(this.performanceComp);
            }
            this.timeComp = (BNanoComponent)this.platformComp.get("Time");
            if (this.timeComp != null) {
                this.timeComp.lease();
                componentsToSubscribe.add(this.timeComp);
            }
            this.licenseComp = (BNanoComponent)this.systemComp.get("License");
            this.licenseComp.lease();
            componentsToSubscribe.add(this.licenseComp);
            BNanoBaseComponent[] componentsToSubscribeArray = componentsToSubscribe.toArray(new BNanoBaseComponent[0]);
            this.registerForComponentEvents((BComponent[])componentsToSubscribeArray, 0);
            if (this.ne2DeviceExt.getConfig().getCommunicationSettings().getStatus().equals((Object)BConnectionStatus.connected)) {
                this.subscribeToNanoDevice(componentsToSubscribeArray);
            }
        } else {
            this.systemComp = null;
            this.platformComp = null;
            this.timeComp = null;
            this.performanceComp = null;
            this.licenseComp = null;
        }
    }

    protected void subscribeToNanoDevice(BNanoBaseComponent ... componentsToSubscribe) {
        if (componentsToSubscribe == null) {
            return;
        }
        BNanoPermanentSubscriptionArg toSubscribe = new BNanoPermanentSubscriptionArg(this.getCurrentContext());
        for (BNanoBaseComponent componentToSubscribe : componentsToSubscribe) {
            toSubscribe.addComponent(componentToSubscribe);
            if (this.subscribed.contains(componentToSubscribe)) continue;
            this.subscribed.add(componentToSubscribe);
        }
        this.ne2DeviceExt.requestNanoPermanentSubscription(toSubscribe);
    }

    protected void unsubscribeAllFromNanoDevice() {
        this.unsubscribeFromNanoDevice(this.subscribed.toArray(new BNanoBaseComponent[0]));
    }

    protected void unsubscribeFromNanoDevice(BNanoBaseComponent ... componentsToUnsubscribe) {
        if (componentsToUnsubscribe == null) {
            return;
        }
        BNanoPermanentUnsubscriptionArg toUnsubscribe = new BNanoPermanentUnsubscriptionArg(this.getCurrentContext());
        for (BNanoBaseComponent componentToUnsubscribe : componentsToUnsubscribe) {
            toUnsubscribe.addComponent(componentToUnsubscribe);
            if (!this.subscribed.contains(componentToUnsubscribe)) continue;
            this.subscribed.remove(componentToUnsubscribe);
        }
        this.ne2DeviceExt.requestNanoPermanentUnsubscription(toUnsubscribe);
    }

    @Override
    public void deactivated() {
        super.deactivated();
        this.unsubscribeAllFromNanoDevice();
    }

    private void updateAllInfo() {
        this.updateCommunicationStatus();
        this.updateStatus();
        this.updateDeviceName();
        this.updateDeviceModel();
        this.updateSerialNumber();
        this.updateOsVersion();
        this.updateIOs();
        this.updateInterfaces();
        this.updateAvailableDatapoints();
    }

    private void updateCommunicationStatus() {
        String status = this.ne2DeviceExt.getConfig().getCommunicationSettings().getStatus().getDisplayText(this.ne2DeviceExt.getApplicationIsLoading());
        this.lblCommunicationStatus.setText(LEX.getText("Info.communicationStatus", new Object[]{status}));
    }

    private void updateDeviceName() {
        String deviceName = "--";
        try {
            if (this.platformComp != null) {
                deviceName = ((BStatusString)this.platformComp.get("deviceName")).getValue();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.lblDeviceName.setText(LEX.getText("Info.deviceName", new Object[]{deviceName}));
    }

    private void updateDeviceModel() {
        String deviceModel = "--";
        try {
            if (this.softwareManager != null) {
                deviceModel = this.softwareManager.getModel();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.lblDeviceModel.setText(LEX.getText("Info.deviceModel", new Object[]{deviceModel}));
    }

    private void updateSerialNumber() {
        String serialNo = "--";
        try {
            if (this.softwareManager != null) {
                serialNo = String.format("%.0f", this.softwareManager.getSerialNumber());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.lblSerialNumber.setText(LEX.getText("Info.serialNumber", new Object[]{serialNo}));
    }

    private void updateOsVersion() {
        String osVersion = "--";
        try {
            if (this.softwareManager != null) {
                osVersion = this.softwareManager.getOSVersion();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.lblOsVersion.setText(LEX.getText("Info.osVersion", new Object[]{osVersion}));
    }

    private String substringBefore(String in, char endCharacter) {
        if (in == null || in.isEmpty()) {
            return in;
        }
        int posEndChar = in.indexOf(endCharacter);
        return posEndChar == -1 ? in : in.substring(0, posEndChar);
    }

    private void updateIOs() {
        String strAO = "--";
        String strDO = "--";
        String strTO = "--";
        String strUI = "--";
        String strDI = "--";
        try {
            if (this.platformComp != null) {
                strAO = this.substringBefore(this.platformComp.get("analogOutputs").toString(), '(').trim();
                strDO = this.substringBefore(this.platformComp.get("digitalOutputs").toString(), '(').trim();
                strTO = this.substringBefore(this.platformComp.get("triacOutputs").toString(), '(').trim();
                strUI = this.substringBefore(this.platformComp.get("universalInputs").toString(), '(').trim();
                strDI = this.substringBefore(this.platformComp.get("digitalInputs").toString(), '(').trim();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.lblIOs.setText(LEX.getText("Info.IO", new Object[]{strAO, strDO, strTO, strUI, strDI}));
    }

    private void updateStatus() {
        String status = "--";
        try {
            if (this.systemComp != null) {
                status = this.deviceStatusRange.getDisplayTag(((BStatusEnum)this.systemComp.get("deviceStatus")).getValue().getOrdinal(), this.getCurrentContext());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.lblStatus.setText(LEX.getText("Info.deviceStatus", new Object[]{status}));
    }

    private void updateInterfaces() {
        String serialPorts = "--";
        String ethernet = "--";
        try {
            if (this.platformComp != null) {
                serialPorts = this.substringBefore(((BStatusString)this.platformComp.get("serialPorts")).getValue(), '(').trim();
            }
            ethernet = ((BStatusString)this.platformComp.get("ethernetInterfaces")).getValue().trim();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.lblInterfaces.setText(LEX.getText("Info.interfaces", new Object[]{serialPorts, ethernet}));
    }

    private void updateCurrentTime() {
        String currentTime = "--";
        try {
            if (this.timeComp != null) {
                currentTime = this.timeComp.get("currentTime").toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.lblCurrentTime.setText(LEX.getText("Info.currentTime", new Object[]{currentTime}));
    }

    private void updateUptime() {
        String strDays = "--";
        String strHours = "--";
        String strMinutes = "--";
        String strSeconds = "--";
        try {
            if (this.performanceComp != null) {
                int intUptime = (int)((BStatusNumeric)this.performanceComp.get("uptime")).getNumeric();
                int days = intUptime / 86400;
                strDays = String.valueOf(days);
                int hours = (intUptime %= 86400) / 3600;
                strHours = String.format("%02d", hours);
                int minutes = (intUptime %= 3600) / 60;
                strMinutes = String.format("%02d", minutes);
                int seconds = intUptime %= 60;
                strSeconds = String.format("%02d", seconds);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.lblUptime.setText(LEX.getText("Info.uptime", new Object[]{strDays, strHours, strMinutes, strSeconds}));
    }

    private void updateCpuLoad() {
        String cpuLoad = "--";
        try {
            if (this.performanceComp != null) {
                cpuLoad = String.valueOf((int)((BStatusNumeric)this.performanceComp.get("cpuUsage")).getValue());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.lblCpuLoad.setText(LEX.getText("Info.cpuLoad", new Object[]{cpuLoad}));
    }

    private void updateAvailableDatapoints() {
        String availableDatapoints = "--";
        try {
            if (this.licenseComp != null) {
                availableDatapoints = String.valueOf((int)((BStatusNumeric)this.licenseComp.get("availableDataPoints")).getValue());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.lblAvailableDatapoints.setText(LEX.getText("Info.availableDatapoints", new Object[]{availableDatapoints}));
    }

    @Override
    public void handleComponentEvent(BComponentEvent event) {
        super.handleComponentEvent(event);
        if (event.getId() != 0) {
            return;
        }
        BValue value = event.getValue();
        BComponent sourceComponent = event.getSourceComponent();
        Slot sourceSlot = event.getSlot();
        Type sourceComponentType = sourceComponent.getType();
        if (event.getSourceComponent().getType().is(BNanoConfigComms.TYPE)) {
            if (sourceSlot.equals((Object)BNanoConfigComms.status)) {
                this.updateCommunicationStatus();
                this.registerRequiredComponents();
            }
        } else if (event.getSourceComponent().getType().is(BNe2DeviceExt.TYPE)) {
            if (sourceSlot.equals((Object)BNe2DeviceExt.applicationIsLoading)) {
                if (!((BNe2DeviceExt)event.getSourceComponent()).getApplicationIsLoading()) {
                    this.registerRequiredComponents();
                }
                this.updateAllInfo();
            }
        } else if (event.getSourceComponent().getType().is(BNanoBaseComponent.TYPE)) {
            BNanoBaseComponent nanoBaseComponent = (BNanoBaseComponent)sourceComponent;
            switch (nanoBaseComponent.getOriginNameFromLibrary()) {
                case "Framework.Core.SystemServices.DeviceService": {
                    if (!sourceSlot.getName().equals("deviceStatus")) break;
                    this.updateStatus();
                    break;
                }
                case "Framework.Core.Schema.Platform": {
                    if (sourceSlot.getName().equals("deviceName")) {
                        this.updateDeviceName();
                        break;
                    }
                    if (sourceSlot.getName().endsWith("Inputs") || sourceSlot.getName().endsWith("Outputs")) {
                        this.updateIOs();
                        break;
                    }
                    if (!sourceSlot.getName().equals("serialPorts") && !sourceSlot.getName().equals("ethernetInterfaces")) break;
                    this.updateInterfaces();
                    break;
                }
                case "Framework.Core.Schema.PlatformTime": {
                    if (!sourceSlot.getName().equals("currentTime")) break;
                    this.updateCurrentTime();
                    break;
                }
                case "Framework.Core.Schema.PlatformPerformance": {
                    if (sourceSlot.getName().equals("uptime")) {
                        this.updateUptime();
                        break;
                    }
                    if (!sourceSlot.getName().equals("cpuUsage")) break;
                    this.updateCpuLoad();
                    break;
                }
                case "Framework.Core.SystemServices.LicenseService": {
                    if (!sourceSlot.getName().equals("availableDataPoints")) break;
                    this.updateAvailableDatapoints();
                }
            }
        }
    }
}

