/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.nE2Link.ui;

import com.ismacontrolli.nE2Link.BNe2DeviceExt;
import com.ismacontrolli.nE2Link.ui.commands.ContinueConnectionCommand;
import com.ismacontrolli.nE2Link.ui.commands.TerminateConnectionCommand;
import com.ismacontrolli.nE2Link.utils.BSoftwareManager;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BTextEditorPane;
import javax.baja.ui.text.BTextEditor;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraAction(name="requestClose", flags=20)
public class BDisconnectDialog
extends BDialog {
    public static final Action requestClose = BDisconnectDialog.newAction((int)20, null);
    public static final Type TYPE = Sys.loadType(BDisconnectDialog.class);
    private Context callContext;
    private BNe2DeviceExt ne2DeviceExt;
    BSoftwareManager softwareManager;
    private BAbsTime disconnectTime;
    private BTextEditor textEditor;
    BButton continueButton;
    BButton disconnectButton;
    Thread updateThread;
    int result;
    private static final Lexicon LEX = Lexicon.make(BDisconnectDialog.class);

    public void requestClose() {
        this.invoke(requestClose, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public static int open(BWidget owner, String title, BNe2DeviceExt ne2DeviceExt, BAbsTime disconnectTime, Context callContext) {
        BDisconnectDialog dlg = new BDisconnectDialog(owner, title, ne2DeviceExt, disconnectTime, callContext);
        dlg.setBoundsCenteredOnOwner();
        dlg.open();
        return dlg.result;
    }

    private BDisconnectDialog(BWidget owner, String title, BNe2DeviceExt ne2DeviceExt, BAbsTime disconnectTime, Context callContext) {
        super(owner, title, true);
        this.callContext = callContext;
        this.disconnectTime = disconnectTime;
        this.ne2DeviceExt = ne2DeviceExt;
        ne2DeviceExt.lease();
        this.softwareManager = ne2DeviceExt.getSoftwareManager();
        this.softwareManager.lease();
        this.textEditor = new BTextEditor();
        this.textEditor.setEditable(false);
        BTextEditorPane textPane = new BTextEditorPane(this.textEditor, 3, 90);
        this.continueButton = new BButton((Command)new ContinueConnectionCommand((BWidget)this, ne2DeviceExt), true, false);
        this.disconnectButton = new BButton((Command)new TerminateConnectionCommand((BWidget)this, ne2DeviceExt), true, false);
        BGridPane buttonGrid = new BGridPane(2);
        buttonGrid.setValign(BValign.center);
        buttonGrid.add("continue", (BValue)this.continueButton);
        buttonGrid.add("disconnect", (BValue)this.disconnectButton);
        BEdgePane edgePane = new BEdgePane();
        edgePane.setCenter((BWidget)textPane);
        edgePane.setBottom((BWidget)buttonGrid);
        this.setContent((BWidget)edgePane);
        this.linkTo("lnkContinue", (BComponent)this.continueButton, (Slot)BButton.actionPerformed, (Slot)requestClose);
        this.linkTo("lnkDisconnect", (BComponent)this.disconnectButton, (Slot)BButton.actionPerformed, (Slot)requestClose);
        this.updateThread = new Thread(() -> {
            BRelTime timeUntilDisconnect = BAbsTime.now().delta(disconnectTime);
            while (ne2DeviceExt.getIsAboutToDisconnect() && timeUntilDisconnect.getMillis() > 0L) {
                if (timeUntilDisconnect.getMillis() < 0L) {
                    timeUntilDisconnect = BRelTime.DEFAULT;
                }
                this.updateText(timeUntilDisconnect);
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                timeUntilDisconnect = BAbsTime.now().delta(disconnectTime);
            }
            this.requestClose();
        });
        this.updateThread.start();
    }

    private void updateText(BRelTime timeUntilDisconnect) {
        this.textEditor.setText(LEX.getText("DisconnectDialog.text", new Object[]{this.softwareManager.getDeviceName(), this.softwareManager.getIpAddress(), this.softwareManager.getIFnetPort(), timeUntilDisconnect.getSeconds()}));
    }

    public BButton getDefaultButton() {
        return this.continueButton;
    }

    public void doRequestClose() {
        this.disconnectButton.setEnabled(false);
        this.continueButton.setEnabled(false);
        this.updateThread.interrupt();
        this.result = 1;
        this.close();
    }
}

