/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.serialization.internal;

import com.ismacontrolli.serialization.SerializableCollection;
import com.ismacontrolli.serialization.SerializableForm;
import com.ismacontrolli.serialization.internal.ChunkedDataWriter;
import com.ismacontrolli.serialization.internal.DataType;
import com.ismacontrolli.serialization.internal.Serializer;
import java.io.IOException;
import javax.baja.nre.util.ByteBuffer;

public class iSMASerializer {
    private static ByteBuffer buffer = new ByteBuffer(new byte[4096]);
    private static Object bufferLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] Process(SerializableCollection collection) throws Exception {
        Object object = bufferLock;
        synchronized (object) {
            try {
                Serializer serializer = iSMASerializer.Open();
                serializer.Write(collection);
                return iSMASerializer.Close(serializer);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] Process(SerializableForm form) throws Exception {
        Object object = bufferLock;
        synchronized (object) {
            Serializer serializer = iSMASerializer.Open();
            serializer.WriteArrayHeader(1, DataType.Type.Form);
            serializer.Write(form);
            return iSMASerializer.Close(serializer);
        }
    }

    public static void ProcessStream(SerializableForm form, ByteBuffer stream) throws Exception {
        ChunkedDataWriter writer = new ChunkedDataWriter(stream);
        Serializer serializer = new Serializer(writer);
        serializer.WriteArrayHeader(1, DataType.Type.Form);
        serializer.Write(form);
        serializer.Close();
    }

    private static Serializer Open() {
        buffer.reset();
        Serializer serializer = new Serializer(buffer);
        serializer.BeginSerialize();
        return serializer;
    }

    private static byte[] Close(Serializer serializer) throws IOException {
        serializer.EndSerialize();
        byte[] result = serializer.Serialize();
        serializer.Close();
        return result;
    }
}

