/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.serialization.internal;

import com.ismacontrolli.nE2Link.datatypes.BInt64;
import com.ismacontrolli.nE2Link.datatypes.BUInt64;
import com.ismacontrolli.serialization.DataMarker;
import com.ismacontrolli.serialization.SerializableCollection;
import com.ismacontrolli.serialization.SerializableForm;
import com.ismacontrolli.serialization.internal.DataType;
import com.ismacontrolli.serialization.internal.EndOfStreamException;
import com.ismacontrolli.serialization.internal.InvalidCastException;
import java.io.DataInput;
import java.io.IOException;
import java.nio.ByteOrder;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Collections;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.ByteBuffer;

public class Deserializer {
    private final ByteBuffer stream;
    public static final long NET_TICKS_PER_MILLISECOND = 10000L;
    public static final long NET_TO_UNIX_EPOCH_OFFSET_TICKS = 621355968000000000L;
    public static final long NET_TO_UNIX_EPOCH_OFFSET_MILLIS = 62135596800000L;

    public Deserializer(byte[] bytes) {
        this.stream = new ByteBuffer(bytes);
        this.stream.setBigEndian(false);
    }

    public final Object Deserialize() throws EndOfStreamException, InvalidCastException, IOException {
        byte nextByte;
        DataType.Type lastHeader = DataType.Type.Undefined;
        DataType.Type header = DataType.Type.Undefined;
        do {
            if ((nextByte = this.stream.readByte()) != -1) continue;
            throw new EndOfStreamException();
        } while ((header = DataType.Type.forValue(nextByte)) == DataType.Type.Undefined);
        switch (header) {
            case Null: {
                return null;
            }
            case Boolean: {
                return this.ReadBoolean();
            }
            case Double: {
                return this.ReadDouble();
            }
            case Marker: {
                return this.ReadMarker();
            }
            case Collection: {
                return this.ReadCollection();
            }
            case Form: {
                return this.ReadForm();
            }
            case String: {
                return this.ReadString();
            }
            case Time: {
                return this.ReadTime();
            }
            case Type: {
                return this.ReadType();
            }
            case Byte: {
                return this.ReadByte();
            }
            case UInt16: {
                return this.ReadUInt16();
            }
            case Int16: {
                return this.ReadInt16();
            }
            case UInt32: {
                return this.ReadUInt32();
            }
            case Int32: {
                return this.ReadInt32();
            }
            case Int64: {
                return this.ReadInt64();
            }
            case UInt64: {
                return this.ReadUInt64();
            }
            case Float: {
                return Float.valueOf(this.ReadFloat());
            }
            case ShortObject: {
                return this.ReadObject(true);
            }
            case Object: {
                return this.ReadObject();
            }
            case End: {
                return DataType.Type.End;
            }
            case Array: {
                return this.ReadArray();
            }
        }
        throw new UnsupportedOperationException(String.format("Not implemented DataType %1$s %2$s", new Object[]{"header", header}));
    }

    public final SerializableCollection ReadCollection() throws InvalidCastException, EndOfStreamException, IOException {
        Object[] a;
        SerializableCollection collection = new SerializableCollection();
        for (Object form : a = ((Array)this.Deserialize()).array()) {
            collection.Add((SerializableForm)form);
        }
        return collection;
    }

    public final SerializableForm ReadForm() throws EndOfStreamException, InvalidCastException, IOException {
        SerializableForm result = new SerializableForm();
        Object[] a = ((Array)this.Deserialize()).array();
        result.marker = (DataMarker)((Object)a[0]);
        result.data = ((Array)a[1]).array();
        result.elements = (SerializableCollection)a[2];
        return result;
    }

    private DataMarker ReadMarker() throws IOException {
        return DataMarker.forValue(this.stream.readByte());
    }

    private byte ReadByte() throws IOException {
        return this.stream.readByte();
    }

    public static long bytesToLong(byte[] bytes) {
        java.nio.ByteBuffer buffer = java.nio.ByteBuffer.allocate(8);
        buffer.put(bytes);
        buffer.flip();
        return buffer.getLong();
    }

    private LocalDateTime ReadTime() throws IOException {
        long timeStamp = this.stream.readLong();
        LocalDateTime localDateTime = Deserializer.unixTimeFromNetTicks(timeStamp, ZoneId.of("UTC"));
        return localDateTime;
    }

    public static LocalDateTime unixTimeFromNetTicks(long netTicks, ZoneId zone) {
        long unixMillis = (netTicks - 621355968000000000L) / 10000L;
        LocalDateTime localDateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(unixMillis), zone);
        return localDateTime;
    }

    public static long netTicksFromUnixTime(LocalDateTime localDateTime, ZoneId zone) {
        ZonedDateTime zdt = localDateTime.atZone(zone);
        long unixMillis = zdt.toInstant().toEpochMilli();
        long netTicks = unixMillis * 10000L + 621355968000000000L;
        return netTicks;
    }

    private LocalDate readExternalLocalDate(DataInput in) throws IOException {
        int year = in.readInt();
        byte month = in.readByte();
        byte dayOfMonth = in.readByte();
        return LocalDate.of(year, month, (int)dayOfMonth);
    }

    private LocalTime readExternalLocalTime(DataInput in) throws IOException {
        int hour = in.readByte();
        int minute = 0;
        int second = 0;
        int nano = 0;
        if (hour < 0) {
            hour ^= 0xFFFFFFFF;
        } else {
            minute = in.readByte();
            if (minute < 0) {
                minute ^= 0xFFFFFFFF;
            } else {
                second = in.readByte();
                if (second < 0) {
                    second ^= 0xFFFFFFFF;
                } else {
                    nano = in.readInt();
                }
            }
        }
        return LocalTime.of(hour, minute, second, nano);
    }

    private boolean ReadBoolean() throws IOException {
        return this.stream.readBoolean();
    }

    private short ReadUInt16() throws IOException {
        return (short)this.stream.readUnsignedShort();
    }

    private long ReadUInt32() throws IOException {
        return (long)this.stream.readInt() & 0xFFFFFFFFL;
    }

    private short ReadInt16() throws InvalidCastException, IOException {
        return this.stream.readShort();
    }

    private int ReadInt32() throws InvalidCastException, IOException {
        return this.stream.readInt();
    }

    private BInt64 ReadInt64() throws InvalidCastException, IOException {
        byte[] bytes = new byte[8];
        for (int i = 0; i < bytes.length; ++i) {
            if (this.stream.isBigEndian()) {
                bytes[i] = this.stream.readByte();
                continue;
            }
            bytes[bytes.length - 1 - i] = this.stream.readByte();
        }
        return BInt64.make(bytes);
    }

    private BUInt64 ReadUInt64() throws InvalidCastException, IOException {
        byte[] bytes = new byte[8];
        for (int i = 0; i < bytes.length; ++i) {
            if (this.stream.isBigEndian()) {
                bytes[i] = this.stream.readByte();
                continue;
            }
            bytes[bytes.length - 1 - i] = this.stream.readByte();
        }
        return BUInt64.make(bytes);
    }

    private String ReadString() throws InvalidCastException, IOException {
        short count = this.ReadUInt16();
        if (count == 0) {
            return "";
        }
        byte[] data = new byte[count];
        if (this.stream.read(data, 0, (int)count) != 0) {
            return new String(data);
        }
        throw new InvalidCastException("Failed to read String");
    }

    private float ReadFloat() throws InvalidCastException, IOException {
        return this.stream.readFloat();
    }

    private long ToUInt64(byte[] bytes, int offset) {
        long result = 0L;
        for (int i = 0; i <= 56; i += 8) {
            result |= (long)((bytes[offset++] & 0xFF) << i);
        }
        return result;
    }

    private double ReadDouble() throws IOException {
        byte[] data = new byte[8];
        this.stream.read(data, 0, data.length);
        return java.nio.ByteBuffer.wrap(data).order(ByteOrder.LITTLE_ENDIAN).getDouble();
    }

    private Object[][] ReadObject() throws InvalidCastException, EndOfStreamException, IOException {
        return this.ReadObject(false);
    }

    private boolean DeserializeNextObject(Object[][] typeMarkedObjects, int iNextObject) throws InvalidCastException, EndOfStreamException, IOException {
        Object typeMarker = this.Deserialize();
        if (typeMarker.getClass().equals(((Object)((Object)DataType.Type.End)).getClass())) {
            return false;
        }
        Object objectValue = this.Deserialize();
        typeMarkedObjects[iNextObject] = new Object[]{typeMarker, objectValue};
        ++iNextObject;
        return true;
    }

    private Object[][] ReadObject(boolean shorted) throws InvalidCastException, EndOfStreamException, IOException {
        int count = shorted ? (int)this.stream.readByte() : this.ReadInt32();
        Object[][] typeMarkedObjects = new Object[count][];
        int iNextObject = 0;
        if (!shorted || count != -1) {
            for (int i = 0; i < count; ++i) {
                this.DeserializeNextObject(typeMarkedObjects, iNextObject);
            }
        } else {
            while (this.DeserializeNextObject(typeMarkedObjects, iNextObject)) {
                if (count != iNextObject) continue;
                this.ExpandObjectArray(typeMarkedObjects, 10);
            }
            Object[][] tempArray = new Object[iNextObject][];
            System.arraycopy(typeMarkedObjects, 0, tempArray, 0, iNextObject);
            return tempArray;
        }
        return typeMarkedObjects;
    }

    private Array ReadArray() throws InvalidCastException, EndOfStreamException, IOException {
        byte type = this.ReadByte();
        int count = this.ReadInt32();
        if (type == DataType.Type.Byte.getValue()) {
            return this.ReadBytesTable(count);
        }
        if (type == DataType.Type.String.getValue()) {
            return this.ReadStringsTable(count);
        }
        return this.ReadObjectsTable(count);
    }

    Array ReadBytesTable(int count) throws IOException {
        byte[] data = new byte[count];
        this.stream.read(data, 0, data.length);
        return new Array(Collections.singleton(data));
    }

    Array ReadStringsTable(int count) throws InvalidCastException, EndOfStreamException, IOException {
        Object[] data = new String[count];
        for (int i = 0; i < count; ++i) {
            data[i] = (String)this.Deserialize();
        }
        return new Array(data, data.length);
    }

    Array ReadObjectsTable(int count) throws InvalidCastException, EndOfStreamException, IOException {
        Object[] data = new Object[count];
        for (int i = 0; i < count; ++i) {
            data[i] = this.Deserialize();
        }
        return new Array(data, data.length);
    }

    private DataType.Type ReadType() throws IOException {
        byte typeCode = this.stream.readByte();
        DataType.Type type = DataType.Type.forValue(typeCode);
        return type;
    }

    private void ExpandObjectArray(Object[][] data, int length) {
        Object[][] temp = data;
        data = new Object[temp.length + length][];
        System.arraycopy(temp, 0, data, 0, temp.length);
    }
}

