/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.serialization.internal;

import com.ismacontrolli.serialization.internal.SeekOrigin;
import java.io.IOException;
import javax.baja.nre.util.ByteBuffer;

public class ChunkedDataWriter
extends ByteBuffer {
    private final int BUFFER_LENGTH = 1024;
    private ByteBuffer stream;
    private byte[] buffer = new byte[1024];
    private int writtenBytes = 0;
    public boolean CanRead = false;
    public boolean CanSeek = false;
    public boolean CanWrite = true;
    public long Length = this.stream.getLength() + this.writtenBytes;

    public int getPosition() {
        return (int)this.Length;
    }

    public void setPosition() {
        throw new UnsupportedOperationException();
    }

    public ChunkedDataWriter(ByteBuffer stream) {
        this.stream = stream;
    }

    public void WriteByte(byte _byte) throws IOException {
        if (this.writtenBytes == 1024) {
            this.Flush();
        }
        this.buffer[this.writtenBytes] = _byte;
        ++this.writtenBytes;
    }

    public void Flush() throws IOException {
        if (this.writtenBytes > 0) {
            this.stream.write(this.buffer, 0, this.writtenBytes);
            this.writtenBytes = 0;
        }
    }

    public long Seek(long offset, SeekOrigin origin) {
        throw new UnsupportedOperationException();
    }

    public void SetLength(long value) {
        throw new UnsupportedOperationException();
    }

    public int Read(byte[] buffer, int offset, int count) {
        throw new UnsupportedOperationException();
    }

    public void Write(byte[] bytes, int offset, int count) throws IOException {
        if (count == 0) {
            return;
        }
        if (offset < 0) {
            throw new IOException("Invalid offset value.");
        }
        if (count < 0) {
            throw new IOException("Invalid write length.");
        }
        if (offset + count > 1024) {
            this.Flush();
            this.stream.write(bytes, offset, count);
            return;
        }
        if (offset + count > 1024 - this.writtenBytes) {
            this.Flush();
        }
        System.arraycopy(bytes, 0, this.buffer, this.writtenBytes + offset, count);
        this.writtenBytes += count;
    }

    public void Close() throws IOException {
        this.Flush();
    }
}

