/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.serialization;

import java.util.HashMap;

public enum DataMarker {
    Response(1),
    ConnectRequest(2),
    AuthorizationRequest(3),
    DeviceSchemaRequest(4),
    TreeRequest(5),
    SubscribeRequest(7),
    UnsubscribeRequest(8),
    PollRequest(9),
    RenameRequest(10),
    DeleteRequest(11),
    AddRequest(12),
    WriteRequest(13),
    ReorderRequest(14),
    LinkRequest(15),
    AddExtensionRequest(16),
    DeleteExtensionRequest(17),
    ReorderExtensionRequest(18),
    LogRequest(19),
    PutFileRequest(20),
    GetFileRequest(21),
    DeleteFileRequest(22),
    GetFolderRequest(23),
    DeviceLibrariesRequest(24),
    DeleteFolderRequest(25),
    UpdateAttributesRequest(26),
    MoveRequest(27),
    ServiceSchema(44),
    SlotSchema(45),
    ComponentSchema(46),
    ExtensionSchema(47),
    ErrorData(65),
    TreeData(66),
    ObjectIdsData(67),
    ExisitingLinkData(68),
    ExtinctLinkData(69),
    PollData(70),
    SlotsValuesData(71),
    AuthorizationData(72),
    GuidData(73),
    ObjectData(74),
    RenameData(75),
    ReorderData(76),
    WriteData(77),
    AddData(78),
    ExtensionData(79),
    AddExtensionData(80),
    DeleteExtensionData(81),
    ReorderExtensionData(82),
    LogData(83),
    FolderData(84),
    FileData(85),
    LibraryData(86),
    FolderItem(87),
    UserIdData(88),
    AuthenticationData(89),
    IFNetInfoData(90),
    AssemblyInfoData(91),
    SlotsMetaData(92),
    UpdateAttributesData(93),
    PersistentObject(-59),
    PersistentLink(-58),
    PersistentExtension(-57),
    Tag(-55),
    TagValue(-54),
    SetOfTags(-53),
    DynamicChoice(-52),
    ScheduleMarker(-51),
    TrendData(-49),
    TrendSamples(-48),
    TrendRemoving(-47),
    CustomUserData(-2),
    DefaultValue(-1);

    public static final int SIZE = 8;
    private byte byteValue;
    private static HashMap<Byte, DataMarker> mappings;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static HashMap<Byte, DataMarker> getMappings() {
        if (mappings != null) return mappings;
        Class<DataMarker> clazz = DataMarker.class;
        synchronized (DataMarker.class) {
            if (mappings != null) return mappings;
            mappings = new HashMap();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mappings;
        }
    }

    private DataMarker(byte value) {
        this.byteValue = value;
        DataMarker.getMappings().put(value, this);
    }

    public byte getValue() {
        return this.byteValue;
    }

    public static DataMarker forValue(byte value) {
        return DataMarker.getMappings().get(value);
    }

    public static boolean IsMarkingRequest(DataMarker self) {
        return self.getValue() > 1 && self.getValue() < 44;
    }
}

