/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.nE2Link.utils.yamlbeans.emitter;

import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;

class EmitterWriter {
    private static final Map<Integer, String> ESCAPE_REPLACEMENTS = new HashMap<Integer, String>();
    private final Writer writer;
    private boolean whitespace = true;
    int column = 0;
    boolean indentation = true;

    public EmitterWriter(Writer stream) {
        this.writer = stream;
    }

    public void writeStreamStart() {
    }

    public void writeStreamEnd() throws IOException {
        this.flushStream();
    }

    public void writeIndicator(String indicator, boolean needWhitespace, boolean whitespace, boolean indentation) throws IOException {
        String data = null;
        data = this.whitespace || !needWhitespace ? indicator : " " + indicator;
        this.whitespace = whitespace;
        this.indentation = this.indentation && indentation;
        this.column += data.length();
        this.writer.write(data);
    }

    public void writeIndent(int indent) throws IOException {
        if (indent == -1) {
            indent = 0;
        }
        if (!this.indentation || this.column > indent || this.column == indent && !this.whitespace) {
            this.writeLineBreak(null);
        }
        if (this.column < indent) {
            this.whitespace = true;
            StringBuffer data = new StringBuffer();
            int j = indent - this.column;
            for (int i = 0; i < j; ++i) {
                data.append(" ");
            }
            this.column = indent;
            this.writer.write(data.toString());
        }
    }

    public void writeVersionDirective(String version_text) throws IOException {
        this.writer.write("%YAML " + version_text);
        this.writeLineBreak(null);
    }

    public void writeTagDirective(String handle, String prefix) throws IOException {
        this.writer.write("%TAG " + handle + " " + prefix);
        this.writeLineBreak(null);
    }

    public void writeDoubleQuoted(String text, boolean split, int indent, int wrapColumn, boolean escapeUnicode) throws IOException {
        this.writeIndicator("\"", true, false, false);
        int start = 0;
        String data = null;
        for (int ending = 0; ending <= text.length(); ++ending) {
            int ch = 0;
            if (ending < text.length()) {
                ch = text.codePointAt(ending);
            }
            if (ch == 0 || "\"\\\u0085".indexOf(ch) != -1 || 32 > ch || ch > 126) {
                if (start < ending) {
                    data = text.substring(start, ending);
                    this.column += data.length();
                    this.writer.write(data);
                    start = ending;
                }
                if (ch != 0) {
                    if (ESCAPE_REPLACEMENTS.containsKey(ch)) {
                        data = "\\" + ESCAPE_REPLACEMENTS.get(ch);
                    } else if (escapeUnicode) {
                        data = Integer.toString(ch, 16);
                        if (data.length() == 1) {
                            data = "000" + data;
                        } else if (data.length() == 2) {
                            data = "00" + data;
                        } else if (data.length() == 3) {
                            data = "0" + data;
                        }
                        data = "\\u" + data;
                    } else {
                        data = new String(Character.toChars(ch));
                    }
                    this.column += data.length();
                    this.writer.write(data);
                    start = ending + 1;
                }
            }
            if (0 >= ending || ending >= text.length() - 1 || ch != 32 && start > ending || this.column + (ending - start) <= wrapColumn || !split) continue;
            data = start < ending ? text.substring(start, ending) + '\\' : "\\";
            if (start < ending) {
                start = ending;
            }
            this.column += data.length();
            this.writer.write(data);
            this.writeIndent(indent);
            this.whitespace = false;
            this.indentation = false;
            if (text.charAt(start) != ' ') continue;
            data = "\\";
            this.column += data.length();
            this.writer.write(data);
        }
        this.writeIndicator("\"", false, false, false);
    }

    public void writeSingleQuoted(String text, boolean split, int indent, int wrapColumn) throws IOException {
        this.writeIndicator("'", true, false, false);
        boolean spaces = false;
        boolean breaks = false;
        int start = 0;
        char ceh = '\u0000';
        String data = null;
        for (int ending = 0; ending <= text.length(); ++ending) {
            ceh = '\u0000';
            if (ending < text.length()) {
                ceh = text.charAt(ending);
            }
            if (spaces) {
                if (ceh == '\u0000' || ceh != ' ') {
                    if (start + 1 == ending && this.column > wrapColumn && split && start != 0 && ending != text.length()) {
                        this.writeIndent(indent);
                    } else {
                        data = text.substring(start, ending);
                        this.column += data.length();
                        this.writer.write(data);
                    }
                    start = ending;
                }
            } else if (breaks) {
                if (ceh == '\u0000' || '\n' != ceh && '\u0085' != ceh) {
                    data = text.substring(start, ending);
                    int j = data.length();
                    for (int i = 0; i < j; ++i) {
                        char cha = data.charAt(i);
                        if ('\n' == cha) {
                            this.writeLineBreak(null);
                            continue;
                        }
                        this.writeLineBreak("" + cha);
                    }
                    this.writeIndent(indent);
                    start = ending;
                }
            } else if ((ceh == '\u0000' || '\n' != ceh && '\u0085' != ceh) && start < ending) {
                data = text.substring(start, ending);
                this.column += data.length();
                this.writer.write(data);
                start = ending;
            }
            if (ceh == '\'') {
                data = "''";
                this.column += 2;
                this.writer.write(data);
                start = ending + 1;
            }
            if (ceh == '\u0000') continue;
            spaces = ceh == ' ';
            breaks = ceh == '\n' || ceh == '\u0085';
        }
        this.writeIndicator("'", false, false, false);
    }

    public void writeFolded(String text, int indent, int wrapColumn) throws IOException {
        String chomp = this.determineChomp(text);
        this.writeIndicator(">" + chomp, true, false, false);
        this.writeIndent(indent);
        boolean leadingSpace = false;
        boolean spaces = false;
        boolean breaks = false;
        int start = 0;
        String data = null;
        for (int ending = 0; ending <= text.length(); ++ending) {
            char ceh = '\u0000';
            if (ending < text.length()) {
                ceh = text.charAt(ending);
            }
            if (breaks) {
                if (ceh == '\u0000' || '\n' != ceh && '\u0085' != ceh) {
                    if (!leadingSpace && ceh != '\u0000' && ceh != ' ' && text.charAt(start) == '\n') {
                        this.writeLineBreak(null);
                    }
                    leadingSpace = ceh == ' ';
                    data = text.substring(start, ending);
                    int j = data.length();
                    for (int i = 0; i < j; ++i) {
                        char cha = data.charAt(i);
                        if ('\n' == cha) {
                            this.writeLineBreak(null);
                            continue;
                        }
                        this.writeLineBreak("" + cha);
                    }
                    if (ceh != '\u0000') {
                        this.writeIndent(indent);
                    }
                    start = ending;
                }
            } else if (spaces) {
                if (ceh != ' ') {
                    if (start + 1 == ending && this.column > wrapColumn) {
                        this.writeIndent(indent);
                    } else {
                        data = text.substring(start, ending);
                        this.column += data.length();
                        this.writer.write(data);
                    }
                    start = ending;
                }
            } else if (ceh == '\u0000' || ' ' == ceh || '\n' == ceh || '\u0085' == ceh) {
                data = text.substring(start, ending);
                this.writer.write(data);
                if (ceh == '\u0000') {
                    this.writeLineBreak(null);
                }
                start = ending;
            }
            if (ceh == '\u0000') continue;
            breaks = '\n' == ceh || '\u0085' == ceh;
            spaces = ceh == ' ';
        }
    }

    public void writeLiteral(String text, int indent) throws IOException {
        String chomp = this.determineChomp(text);
        this.writeIndicator("|" + chomp, true, false, false);
        this.writeIndent(indent);
        boolean breaks = false;
        int start = 0;
        String data = null;
        for (int ending = 0; ending <= text.length(); ++ending) {
            char ceh = '\u0000';
            if (ending < text.length()) {
                ceh = text.charAt(ending);
            }
            if (breaks) {
                if (ceh == '\u0000' || '\n' != ceh && '\u0085' != ceh) {
                    data = text.substring(start, ending);
                    int j = data.length();
                    for (int i = 0; i < j; ++i) {
                        char cha = data.charAt(i);
                        if ('\n' == cha) {
                            this.writeLineBreak(null);
                            continue;
                        }
                        this.writeLineBreak("" + cha);
                    }
                    if (ceh != '\u0000') {
                        this.writeIndent(indent);
                    }
                    start = ending;
                }
            } else if (ceh == '\u0000' || '\n' == ceh || '\u0085' == ceh) {
                data = text.substring(start, ending);
                this.writer.write(data);
                if (ceh == '\u0000') {
                    this.writeLineBreak(null);
                }
                start = ending;
            }
            if (ceh == '\u0000') continue;
            breaks = '\n' == ceh || '\u0085' == ceh;
        }
    }

    public void writePlain(String text, boolean split, int indent, int wrapColumn) throws IOException {
        if (text == null || "".equals(text)) {
            return;
        }
        String data = null;
        if (!this.whitespace) {
            data = " ";
            this.column += data.length();
            this.writer.write(data);
        }
        this.whitespace = false;
        this.indentation = false;
        boolean spaces = false;
        boolean breaks = false;
        int start = 0;
        for (int ending = 0; ending <= text.length(); ++ending) {
            char ceh = '\u0000';
            if (ending < text.length()) {
                ceh = text.charAt(ending);
            }
            if (spaces) {
                if (ceh != ' ') {
                    if (start + 1 == ending && this.column > wrapColumn && split) {
                        this.writeIndent(indent);
                        this.whitespace = false;
                        this.indentation = false;
                    } else {
                        data = text.substring(start, ending);
                        this.column += data.length();
                        this.writer.write(data);
                    }
                    start = ending;
                }
            } else if (breaks) {
                if (ceh != '\n' && ceh != '\u0085') {
                    if (text.charAt(start) == '\n') {
                        this.writeLineBreak(null);
                    }
                    data = text.substring(start, ending);
                    int j = data.length();
                    for (int i = 0; i < j; ++i) {
                        char cha = data.charAt(i);
                        if ('\n' == cha) {
                            this.writeLineBreak(null);
                            continue;
                        }
                        this.writeLineBreak("" + cha);
                    }
                    this.writeIndent(indent);
                    this.whitespace = false;
                    this.indentation = false;
                    start = ending;
                }
            } else if (ceh == '\u0000' || ' ' == ceh || '\n' == ceh || '\u0085' == ceh) {
                data = text.substring(start, ending);
                this.column += data.length();
                this.writer.write(data);
                start = ending;
            }
            if (ceh == '\u0000') continue;
            spaces = ceh == ' ';
            breaks = ceh == '\n' || ceh == '\u0085';
        }
    }

    public void writeLineBreak(String data) throws IOException {
        if (data == null) {
            data = System.getProperty("line.separator");
        }
        this.whitespace = true;
        this.indentation = true;
        this.column = 0;
        this.writer.write(data);
    }

    public void flushStream() throws IOException {
        this.writer.flush();
    }

    private String determineChomp(String text) {
        String tail = text.substring(text.length() - 2, text.length() - 1);
        while (tail.length() < 2) {
            tail = " " + tail;
        }
        char ceh = tail.charAt(tail.length() - 1);
        char ceh2 = tail.charAt(tail.length() - 2);
        return ceh == '\n' || ceh == '\u0085' ? (ceh2 == '\n' || ceh2 == '\u0085' ? "+" : "") : "-";
    }

    public void close() throws IOException {
        this.writer.close();
    }

    static {
        ESCAPE_REPLACEMENTS.put(0, "0");
        ESCAPE_REPLACEMENTS.put(7, "a");
        ESCAPE_REPLACEMENTS.put(8, "b");
        ESCAPE_REPLACEMENTS.put(9, "t");
        ESCAPE_REPLACEMENTS.put(10, "n");
        ESCAPE_REPLACEMENTS.put(11, "v");
        ESCAPE_REPLACEMENTS.put(12, "f");
        ESCAPE_REPLACEMENTS.put(13, "r");
        ESCAPE_REPLACEMENTS.put(27, "e");
        ESCAPE_REPLACEMENTS.put(34, "\"");
        ESCAPE_REPLACEMENTS.put(92, "\\");
        ESCAPE_REPLACEMENTS.put(133, "N");
        ESCAPE_REPLACEMENTS.put(160, "_");
    }
}

