/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.nE2Link.utils.rpc.serialization;

import com.ismacontrolli.nE2Link.utils.rpc.serialization.SerializationHelper;
import com.ismacontrolli.nE2Link.utils.rpc.serialization.SerializerException;
import com.ismacontrolli.nE2Link.utils.rpc.serialization.SerializerInit;
import com.tridium.box.json.BsonDecoderPlugin;
import com.tridium.box.json.BsonEncoderPlugin;
import com.tridium.json.JSONArray;
import com.tridium.json.JSONObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.baja.sys.BValue;

public class Serializer {
    public static Object toJson(Object objectToSerialize) throws SerializerException {
        return Serializer.toJson(objectToSerialize, true);
    }

    public static Object toJson(Object objectToSerialize, boolean forceListToJSONArray) throws SerializerException {
        if (objectToSerialize == null) {
            return null;
        }
        Class<?> clazz = objectToSerialize.getClass();
        try {
            if (SerializationHelper.isNativeType(clazz)) {
                return objectToSerialize;
            }
            if (objectToSerialize instanceof JSONObject) {
                return objectToSerialize;
            }
            if (objectToSerialize instanceof Collection) {
                Collection c = (Collection)objectToSerialize;
                if (forceListToJSONArray) {
                    JSONArray serialized = new JSONArray();
                    for (Object value : (Collection)objectToSerialize) {
                        Object serializedValue = Serializer.toJson(value, forceListToJSONArray);
                        serialized.put(serializedValue);
                    }
                    return serialized;
                }
                ArrayList<JSONObject> serialized = new ArrayList<JSONObject>(c.size());
                for (Object value : (Collection)objectToSerialize) {
                    Object serializedValue = Serializer.toJson(value, forceListToJSONArray);
                    serialized.add((JSONObject)serializedValue);
                }
                return serialized;
            }
            if (objectToSerialize instanceof JSONArray) {
                JSONArray serializedArr = new JSONArray();
                JSONArray inputArray = (JSONArray)objectToSerialize;
                for (int i = 0; i < inputArray.length(); ++i) {
                    Object value = serializedArr.get(i);
                    Object serializedValue = Serializer.toJson(value, forceListToJSONArray);
                    serializedArr.put(serializedValue);
                }
                return serializedArr;
            }
            if (objectToSerialize instanceof BValue) {
                String jsonString = BsonEncoderPlugin.marshal((BValue)((BValue)objectToSerialize));
                return new JSONObject(jsonString);
            }
            if (objectToSerialize instanceof HashMap) {
                return new JSONObject((Map)((HashMap)objectToSerialize));
            }
            boolean includeSuperclass = SerializationHelper.shouldIncludeSuperclass(clazz);
            Serializer.initSerialization(objectToSerialize, includeSuperclass);
            Field[] serializableFields = SerializationHelper.getSerializableFields(clazz, includeSuperclass);
            JSONObject serializedObject = new JSONObject();
            serializedObject.put("class", (Object)clazz.getName());
            for (Field field : serializableFields) {
                Object propertyValue = SerializationHelper.getFieldValue(objectToSerialize, field);
                String propertyName = SerializationHelper.getSerializedPropertyName(field);
                Object serializedValue = Serializer.toJson(propertyValue, forceListToJSONArray);
                serializedObject.put(propertyName, serializedValue);
            }
            return serializedObject;
        }
        catch (Exception e) {
            throw new SerializerException(String.format("Serializer serialization failure for %s[%s]", objectToSerialize, clazz), e);
        }
    }

    public static Object fromJson(Object source) throws SerializerException {
        try {
            JSONObject o = new JSONObject();
            if (source.getClass().isPrimitive() || source instanceof String) {
                return source;
            }
            if (source instanceof Collection) {
                ArrayList<Object> list = new ArrayList<Object>(((Collection)source).size());
                for (Object entry : (Collection)source) {
                    list.add(Serializer.fromJson(entry));
                }
                return list;
            }
            if (source instanceof JSONArray) {
                JSONArray jsonArray = (JSONArray)source;
                ArrayList<Object> list = new ArrayList<Object>(jsonArray.length());
                for (int i = 0; i < jsonArray.length(); ++i) {
                    Object value = jsonArray.get(i);
                    list.add(Serializer.fromJson(value));
                }
                return list;
            }
            if (source instanceof HashMap) {
                return Serializer.fromJson(new JSONObject((Map)source));
            }
            if (source instanceof JSONObject) {
                Field[] fieldsToDeserialize;
                JSONObject jsonObj = (JSONObject)source;
                if (Serializer.isNiagaraType(jsonObj)) {
                    BValue value = BsonDecoderPlugin.unmarshal((JSONObject)jsonObj);
                    return value;
                }
                String typeName = jsonObj.optString("class", null);
                if (typeName == null) {
                    throw new SerializerException(String.format("Unable to deserialize type because class name is missing in \n{0}", jsonObj));
                }
                Class<?> clazz = null;
                Object deserializedObject = null;
                try {
                    clazz = Class.forName(typeName);
                    Constructor<?> ctor = clazz.getConstructor(new Class[0]);
                    deserializedObject = ctor.newInstance(new Object[0]);
                }
                catch (ClassNotFoundException e) {
                    throw new SerializerException(String.format("Class '%s' not found in module", typeName), e);
                }
                catch (NoSuchMethodException | SecurityException e) {
                    throw new SerializerException(String.format("No accessible default constructor found for class '%s'", typeName), e);
                }
                catch (Exception e) {
                    throw new SerializerException(String.format("Unable to create instance of class '%s'", typeName), e);
                }
                for (Field field : fieldsToDeserialize = SerializationHelper.getSerializableFields(clazz)) {
                    Object value;
                    String jsonPropertyName = SerializationHelper.getSerializedPropertyName(field);
                    Class<String> propertyType = field.getType();
                    Object jsonPropertyValue = jsonObj.opt(jsonPropertyName);
                    if (jsonPropertyValue == null) continue;
                    if (propertyType.isPrimitive() || propertyType.isAssignableFrom(String.class)) {
                        SerializationHelper.setFieldValue(deserializedObject, field, jsonPropertyValue);
                        continue;
                    }
                    if (BValue.class.isAssignableFrom(propertyType)) {
                        value = BsonDecoderPlugin.unmarshal((String)jsonPropertyValue.toString());
                        SerializationHelper.setFieldValue(deserializedObject, field, value);
                        continue;
                    }
                    if (jsonPropertyValue instanceof JSONObject) {
                        value = Serializer.fromJson(jsonPropertyValue);
                        field.set(deserializedObject, value);
                        continue;
                    }
                    throw new SerializerException(String.format("Unknown type for deserialization of property %s", field.getName()));
                }
                return deserializedObject;
            }
            throw new SerializerException(String.format("Unknown type for deserialization", new Object[0]));
        }
        catch (Exception e) {
            throw new SerializerException(String.format("JSON serialization failure for %s", source.toString()), e);
        }
    }

    private static boolean isNiagaraType(JSONObject serializedObject) {
        return serializedObject.opt("t") != null && serializedObject.opt("nm") != null;
    }

    private static void initSerialization(Object objectToSerialize, boolean includeSuperclass) throws SerializerException {
        Method[] methods;
        Class<?> clazz = objectToSerialize.getClass();
        for (Method method : methods = includeSuperclass ? clazz.getMethods() : clazz.getDeclaredMethods()) {
            if (!method.isAnnotationPresent(SerializerInit.class)) continue;
            if (method.getParameterCount() > 0) {
                throw new SerializerException(String.format("[%s.%s]: Only methods with no call parameters can be annotated with SerializerInit", clazz.getSimpleName(), method.getName()));
            }
            if (method.isAccessible()) {
                try {
                    method.invoke(objectToSerialize, new Object[0]);
                    continue;
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new SerializerException("Failed to invoke method", e);
                }
            }
            throw new SerializerException(String.format("[%s.%s]: Only public methods can be annotated with SerializerInit", clazz.getSimpleName(), method.getName()));
        }
    }
}

