/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.nE2Link.utils.rpc.serialization;

import com.ismacontrolli.nE2Link.utils.rpc.serialization.SerializableClass;
import com.ismacontrolli.nE2Link.utils.rpc.serialization.SerializableProperty;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;

public class SerializationHelper {
    public static String getSerializedPropertyName(Field field) {
        return field.isAnnotationPresent(SerializableProperty.class) && !field.getDeclaredAnnotation(SerializableProperty.class).serializedName().isEmpty() ? field.getDeclaredAnnotation(SerializableProperty.class).serializedName() : field.getName();
    }

    public static String getGetterName(Field field) {
        return field.isAnnotationPresent(SerializableProperty.class) && !field.getDeclaredAnnotation(SerializableProperty.class).getterName().isEmpty() ? field.getDeclaredAnnotation(SerializableProperty.class).getterName() : "get" + field.getName().substring(0, 1).toUpperCase() + field.getName().substring(1);
    }

    public static String getSetterName(Field field) {
        String setterName = field.isAnnotationPresent(SerializableProperty.class) && !field.getDeclaredAnnotation(SerializableProperty.class).setterName().isEmpty() ? field.getDeclaredAnnotation(SerializableProperty.class).setterName() : "set" + field.getName().substring(0, 1).toUpperCase() + field.getName().substring(1);
        return setterName;
    }

    public static boolean shouldIncludeSuperclass(Class<?> clazz) {
        SerializableClass[] serializables = (SerializableClass[])clazz.getDeclaredAnnotationsByType(SerializableClass.class);
        return serializables.length > 0 && serializables[0].includeSuperclass();
    }

    public static Field[] getSerializableFields(Class<?> clazz) {
        boolean includeSuperclass = SerializationHelper.shouldIncludeSuperclass(clazz);
        return SerializationHelper.getSerializableFields(clazz, includeSuperclass);
    }

    public static Field[] getSerializableFields(Class<?> clazz, boolean includeSuperclass) {
        Field[] serializableFields;
        boolean hasPropertyAnnotations = SerializationHelper.hasSerializablePropertyAnnotations(clazz, includeSuperclass);
        Field[] fieldArray = serializableFields = includeSuperclass ? clazz.getFields() : clazz.getDeclaredFields();
        if (hasPropertyAnnotations) {
            serializableFields = (Field[])Arrays.stream(serializableFields).filter(field -> field.isAnnotationPresent(SerializableProperty.class)).toArray(Field[]::new);
        }
        return serializableFields;
    }

    private static boolean hasSerializablePropertyAnnotations(Class<?> clazz, boolean checkSupertypes) {
        Field[] serializableFields = checkSupertypes ? clazz.getFields() : clazz.getDeclaredFields();
        return Arrays.stream(serializableFields).anyMatch(field -> field.isAnnotationPresent(SerializableProperty.class));
    }

    public static Object getFieldValue(Object objectToSerialize, final Field field) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        Object propertyValue = null;
        if (Modifier.isPublic(field.getModifiers())) {
            propertyValue = field.get(objectToSerialize);
        } else {
            try {
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        field.setAccessible(true);
                        return null;
                    }
                });
                propertyValue = field.get(objectToSerialize);
            }
            catch (SecurityException e) {
                String getterName = SerializationHelper.getGetterName(field);
                Method getter = objectToSerialize.getClass().getMethod(getterName, new Class[0]);
                propertyValue = getter.invoke(objectToSerialize, new Object[0]);
            }
        }
        return propertyValue;
    }

    public static void setFieldValue(Object objectToDeserialize, final Field field, Object value) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        if (Modifier.isPublic(field.getModifiers())) {
            field.set(objectToDeserialize, value);
        } else {
            try {
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        field.setAccessible(true);
                        return null;
                    }
                });
                field.set(objectToDeserialize, value);
            }
            catch (SecurityException e) {
                String setterName = SerializationHelper.getSetterName(field);
                Method setter = objectToDeserialize.getClass().getMethod(setterName, value.getClass());
                setter.invoke(objectToDeserialize, value);
            }
        }
    }

    public static boolean isNativeType(Class clazz) {
        return clazz.isAssignableFrom(String.class) || clazz.isPrimitive() || clazz.isAssignableFrom(Integer.class) || clazz.isAssignableFrom(Double.class) || clazz.isAssignableFrom(Long.class) || clazz.isAssignableFrom(Boolean.class);
    }
}

