/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.nE2Link.utils;

import com.ismacontrolli.nE2Link.BNe2DeviceExt;
import com.ismacontrolli.nE2Link.utils.BFileTransfer;
import com.ismacontrolli.nE2Link.utils.javabeans.FlatManifest;
import com.ismacontrolli.nE2Link.utils.javabeans.HierarchicalManifest;
import com.ismacontrolli.nE2Link.utils.javabeans.HierarchicalSubManifests;
import com.ismacontrolli.nE2Link.utils.javabeans.PreserveManifest;
import com.ismacontrolli.nE2Link.utils.javabeans.PreservedFile;
import com.ismacontrolli.nE2Link.utils.yamlbeans.YamlException;
import com.ismacontrolli.nE2Link.utils.yamlbeans.YamlReader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedActionException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.nre.util.TextUtil;

public class ManifestHelper {
    BNe2DeviceExt ne2DeviceExt;
    boolean withIpSettings;
    boolean takeFromDevice;
    BDirectory tempBackupsFolder = null;

    public ManifestHelper(BNe2DeviceExt ne2DeviceExt, boolean withIpSettings, boolean takeFromDevice) {
        this.ne2DeviceExt = ne2DeviceExt;
        this.withIpSettings = withIpSettings;
        this.takeFromDevice = takeFromDevice;
    }

    static void copyFilesRecursively(BDirectory source, BDirectory target) throws IOException {
        for (BIFile file : source.listFiles()) {
            OrdQuery[] queries = BOrd.make((String)(target.getFilePath().toString() + "/" + file.getFileName())).parse();
            FilePath filePath = (FilePath)queries[queries.length - 1];
            if (file.isDirectory()) {
                BDirectory targetSubDir = BFileSystem.INSTANCE.makeDir(filePath);
                ManifestHelper.copyFilesRecursively((BDirectory)file, targetSubDir);
                continue;
            }
            BIFile targetFile = BFileSystem.INSTANCE.makeFile(filePath);
            InputStream is = file.getInputStream();
            byte[] fileContent = new byte[is.available()];
            is.read(fileContent);
            is.close();
            OutputStream out = targetFile.getOutputStream();
            out.write(fileContent);
            out.flush();
            out.close();
        }
    }

    public static HierarchicalManifest getHierarchicalManifest(BDirectory tempDirectory) {
        HierarchicalManifest hierarchicalManifest = null;
        String mainManifestPath = tempDirectory.getFilePath().toString() + "/" + "manifest.yml";
        OrdQuery[] queries = BOrd.make((String)mainManifestPath).parse();
        FilePath filePath = (FilePath)queries[queries.length - 1];
        try {
            BIFile file = BFileSystem.INSTANCE.makeFile(filePath);
            InputStream is = file.getInputStream();
            byte[] fileContent = new byte[is.available()];
            is.read(fileContent);
            is.close();
            YamlReader yaml = new YamlReader(new String(fileContent));
            hierarchicalManifest = yaml.read(HierarchicalManifest.class);
        }
        catch (YamlException ye) {
            ye.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return hierarchicalManifest;
    }

    static FlatManifest getFilesManifestFile(BDirectory tempDirectory) {
        FlatManifest flatManifest = null;
        String flatManifestPath = tempDirectory.getFilePath().toString() + "/" + "files.yml";
        OrdQuery[] queries = BOrd.make((String)flatManifestPath).parse();
        FilePath filePath = (FilePath)queries[queries.length - 1];
        try {
            BIFile file = BFileSystem.INSTANCE.makeFile(filePath);
            InputStream is = file.getInputStream();
            byte[] fileContent = new byte[is.available()];
            is.read(fileContent);
            is.close();
            YamlReader yaml = new YamlReader(new String(fileContent));
            flatManifest = yaml.read(FlatManifest.class);
        }
        catch (YamlException ye) {
            ye.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return flatManifest;
    }

    BDirectory getTempDirectory() throws IOException {
        if (this.tempBackupsFolder == null) {
            BOrd localBackupsOrd = BOrd.make((BOrd)BNe2DeviceExt.BACKUPS_FILE_ORD, (String)"file:temp");
            OrdQuery[] queries = localBackupsOrd.normalize().parse();
            FilePath filePath = (FilePath)queries[queries.length - 1];
            this.tempBackupsFolder = BFileSystem.INSTANCE.makeDir(filePath);
        }
        return this.tempBackupsFolder;
    }

    boolean takeManifestFromDevice(String folderPath, String fileName) throws IOException {
        boolean ok = false;
        BFileTransfer fileTransfer = new BFileTransfer(this.ne2DeviceExt);
        Map<String, LocalDateTime> backupFiles = fileTransfer.folderGet("/system/backup");
        if (backupFiles.keySet().contains(fileName)) {
            byte[] fileContent = fileTransfer.getFileContent(folderPath, fileName);
            if (fileContent != null && fileContent.length > 0) {
                BFileSystem fileSystem = BFileSystem.INSTANCE;
                OrdQuery[] queries = BOrd.make((BOrd)BNe2DeviceExt.BACKUPS_FILE_ORD, (String)("file:temp/" + fileName)).normalize().parse();
                FilePath filePath = (FilePath)queries[queries.length - 1];
                if (fileSystem.findFile(filePath) != null) {
                    fileSystem.delete(filePath);
                }
                BIFile file = fileSystem.makeFile(filePath);
                OutputStream out = file.getOutputStream();
                out.write(fileContent);
                out.flush();
                out.close();
            }
            ok = true;
        }
        return ok;
    }

    public boolean prepareNewVersionOfManifest() throws Exception {
        AtomicBoolean ok = new AtomicBoolean(false);
        OrdQuery[] queries = BOrd.make((BOrd)BNe2DeviceExt.BACKUPS_FILE_ORD, (String)"file:temp/manifest.yml").normalize().parse();
        FilePath filePath = (FilePath)queries[queries.length - 1];
        BIFile manifestFile = BFileSystem.INSTANCE.findFile(filePath);
        if (manifestFile != null) {
            AccessController.doPrivileged(() -> {
                InputStream is = manifestFile.getInputStream();
                YamlReader yaml = new YamlReader(new BufferedReader(new InputStreamReader(is)));
                HierarchicalManifest hierarchicalManifest = yaml.read(HierarchicalManifest.class);
                is.close();
                String preserveYaml = this.preparePreserveManifest(hierarchicalManifest);
                String updatedMainManifestYaml = this.updateMainManifest(hierarchicalManifest, preserveYaml);
                this.updateMainSignature(updatedMainManifestYaml);
                ok.set(true);
                return null;
            });
        }
        return ok.get();
    }

    private String preparePreserveManifest(HierarchicalManifest hierarchicalManifest) throws Exception {
        PreserveManifest preserveManifest = new PreserveManifest();
        preserveManifest.setCoreVersion(hierarchicalManifest.getCoreVersion());
        preserveManifest.setDate(hierarchicalManifest.getDate());
        PreservedFile preservedFile = new PreservedFile();
        preservedFile.setLocation("''");
        preservedFile.setFileName("/system/backup");
        preserveManifest.setPreserve(new ArrayList<PreservedFile>(Arrays.asList(preservedFile)));
        if (!this.withIpSettings) {
            List elementsToPreserve = hierarchicalManifest.getSubManifests().stream().filter(m -> !m.getLocation().equals("files")).collect(Collectors.toList());
            if (this.takeFromDevice) {
                BFileTransfer fileTransfer = new BFileTransfer(this.ne2DeviceExt);
                Map<String, LocalDateTime> systemFiles = fileTransfer.folderGet("/system/backup");
                systemFiles.keySet().forEach(f -> {
                    if (f.endsWith(".yml") && !f.contains("manifest") && !f.contains("files")) {
                        System.out.println("[doRestoreOnDeviceBackup] systemFiles file: " + f);
                        byte[] fileContent = fileTransfer.getFileContent("/system/backup", (String)f);
                        if (fileContent != null && fileContent.length > 0) {
                            try {
                                OrdQuery[] queries = BOrd.make((BOrd)BNe2DeviceExt.BACKUPS_FILE_ORD, (String)("file:temp/" + f)).normalize().parse();
                                FilePath filePath = (FilePath)queries[queries.length - 1];
                                BFileSystem fileSystem = BFileSystem.INSTANCE;
                                if (fileSystem.findFile(filePath) != null) {
                                    fileSystem.delete(filePath);
                                }
                                BIFile file = fileSystem.makeFile(filePath);
                                OutputStream out = file.getOutputStream();
                                out.write(fileContent);
                                out.flush();
                                out.close();
                            }
                            catch (Exception e) {
                                System.out.println("[doRestoreOnDeviceBackup] failed to save systemFile: " + f);
                            }
                        }
                    }
                });
            }
            BIFile[] files = this.getTempDirectory().listFiles();
            for (HierarchicalSubManifests elem : elementsToPreserve) {
                String name = elem.getFileName().substring(elem.getFileName().lastIndexOf("/") + 1);
                Optional<BIFile> file = Arrays.asList(files).stream().filter(x -> x.getFileName().substring(x.getFileName().lastIndexOf("/") + 1).equals(name)).findFirst();
                if (!file.isPresent()) continue;
                AccessController.doPrivileged(() -> {
                    InputStream is = ((BIFile)file.get()).getInputStream();
                    YamlReader yaml = new YamlReader(new BufferedReader(new InputStreamReader(is)));
                    FlatManifest flatManifest = yaml.read(FlatManifest.class);
                    is.close();
                    flatManifest.getArchive().forEach(a -> a.getFiles().forEach(f -> {
                        PreservedFile tempFile = new PreservedFile();
                        tempFile.setLocation("''");
                        tempFile.setFileName(f.getFileName());
                        preserveManifest.getPreserve().add(tempFile);
                    }));
                    return null;
                });
            }
        }
        String preserveManifestPath = "temp/preserve.yml";
        BFileSystem fileSystem = BFileSystem.INSTANCE;
        OrdQuery[] queries = BOrd.make((BOrd)BNe2DeviceExt.BACKUPS_FILE_ORD, (String)("file:" + preserveManifestPath)).normalize().parse();
        FilePath filePath = (FilePath)queries[queries.length - 1];
        if (fileSystem.findFile(filePath) != null) {
            fileSystem.delete(filePath);
        }
        BIFile preserveYamlFile = fileSystem.makeFile(filePath);
        OutputStream os = preserveYamlFile.getOutputStream();
        StringBuilder sb = new StringBuilder("").append("coreVersion: " + preserveManifest.getCoreVersion()).append("\ndate: " + this.getUTCTimeTick()).append("\npreserve:");
        for (PreservedFile tempPreservedFile : preserveManifest.getPreserve()) {
            sb.append("\n- location: " + tempPreservedFile.getLocation()).append("\n  fileName: " + tempPreservedFile.getFileName());
        }
        sb.append("\n");
        os.write(sb.toString().getBytes());
        os.flush();
        os.close();
        InputStream is = preserveYamlFile.getInputStream();
        byte[] preserveYaml = new byte[is.available()];
        is.read(preserveYaml);
        is.close();
        return new String(preserveYaml);
    }

    private String updateMainManifest(HierarchicalManifest hierarchicalManifest, String preserveYaml) throws NoSuchAlgorithmException, IOException, PrivilegedActionException {
        Sha256 sha256 = new Sha256();
        String preserveSignature = sha256.encrypt(preserveYaml);
        hierarchicalManifest.setRestoreFromDevice(this.takeFromDevice);
        if (!this.withIpSettings) {
            List elementsToPreserve = hierarchicalManifest.getSubManifests().stream().filter(m -> !m.getLocation().equals("files")).collect(Collectors.toList());
            List<BIFile> files = Arrays.asList(this.getTempDirectory().listFiles());
            for (HierarchicalSubManifests elem : elementsToPreserve) {
                String name = elem.getFileName().substring(elem.getFileName().lastIndexOf("/") + 1, elem.getFileName().indexOf(46));
                List filesToDelete = files.stream().filter(x -> x.getFileName().contains(name)).map(f -> f.getFileName()).collect(Collectors.toList());
                files.stream().forEach(f -> {
                    String fileName = f.getFileName().substring(f.getFileName().lastIndexOf("/") + 1, f.getFileName().indexOf(46));
                    filesToDelete.forEach(fileToDelete -> {
                        if (fileToDelete.contains(fileName)) {
                            try {
                                f.delete();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    });
                });
                hierarchicalManifest.getSubManifests().remove(elem);
            }
        }
        HierarchicalSubManifests tempVar = new HierarchicalSubManifests();
        tempVar.setFileName("/system/backup/preserve.yml");
        tempVar.setLocation("''");
        tempVar.setSignature(preserveSignature);
        hierarchicalManifest.getSubManifests().add(tempVar);
        String updatedMainManifestPath = "temp/manifest.yml";
        OrdQuery[] queries = BOrd.make((BOrd)BNe2DeviceExt.BACKUPS_FILE_ORD, (String)("file:" + updatedMainManifestPath)).normalize().parse();
        FilePath filePath = (FilePath)queries[queries.length - 1];
        BFileSystem fileSystem = BFileSystem.INSTANCE;
        if (fileSystem.findFile(filePath) != null) {
            fileSystem.delete(filePath);
        }
        BIFile manifestYamlFile = fileSystem.makeFile(filePath);
        OutputStream os = manifestYamlFile.getOutputStream();
        StringBuilder sb = new StringBuilder("").append("coreVersion: " + hierarchicalManifest.getCoreVersion()).append("\ndate: " + hierarchicalManifest.getDate()).append("\nrestoreFromDevice: " + hierarchicalManifest.getRestoreFromDevice()).append("\nsubManifests:");
        for (HierarchicalSubManifests subManifest : hierarchicalManifest.getSubManifests()) {
            sb.append("\n- location: " + subManifest.getLocation()).append("\n  fileName: " + subManifest.getFileName()).append("\n  signature: " + subManifest.getSignature());
        }
        sb.append("\n");
        os.write(sb.toString().getBytes());
        os.flush();
        os.close();
        InputStream is = manifestYamlFile.getInputStream();
        byte[] updatedMainManifestYaml = new byte[is.available()];
        is.read(updatedMainManifestYaml);
        is.close();
        return new String(updatedMainManifestYaml);
    }

    void updateMainSignature(String updatedMainManifestYaml) throws NoSuchAlgorithmException, IOException {
        Sha256 sha256 = new Sha256();
        String updatedMainManifestSignature = sha256.encrypt(updatedMainManifestYaml);
        if (updatedMainManifestSignature != null && !updatedMainManifestSignature.isEmpty()) {
            BFileSystem fileSystem = BFileSystem.INSTANCE;
            OrdQuery[] queries = BOrd.make((BOrd)BNe2DeviceExt.BACKUPS_FILE_ORD, (String)"file:temp/manifest.sig").normalize().parse();
            FilePath filePath = (FilePath)queries[queries.length - 1];
            BIFile file = fileSystem.findFile(filePath) != null ? fileSystem.findFile(filePath) : fileSystem.makeFile(filePath);
            OutputStream out = file.getOutputStream();
            out.write(updatedMainManifestSignature.getBytes());
            out.flush();
            out.close();
        }
    }

    boolean generateRestoreIndicator() {
        boolean ok = false;
        String restoreIndicatorContent = "restore";
        String restoreIndicatorName = "restore_indicator";
        BFileTransfer fileTransfer = new BFileTransfer(this.ne2DeviceExt);
        if (fileTransfer.filePut("/system", "restore_indicator", "restore".getBytes())) {
            Map<String, LocalDateTime> systemFiles = fileTransfer.folderGet("/system");
            boolean[] exists = new boolean[1];
            systemFiles.keySet().forEach(f -> {
                System.out.println("[doRestoreOnDeviceBackup] system file: " + f);
                if (f.equals("restore_indicator")) {
                    exists[0] = true;
                }
            });
            ok = exists[0];
        }
        return ok;
    }

    private long getUTCTimeTick() {
        LocalDateTime localDateTime = LocalDateTime.now();
        long timerTicks = localDateTime.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
        return timerTicks * 10000L + 621355968000000000L;
    }

    public static LocalDateTime fromUTCTimeTick(long timerTicks) {
        long unixEpochTicks = timerTicks - 621355968000000000L;
        long millis = unixEpochTicks / 10000L;
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(millis), ZoneOffset.UTC);
    }

    public class Sha256 {
        public String encrypt(String text) throws NoSuchAlgorithmException {
            String hashedValue = "";
            if (!text.isEmpty()) {
                MessageDigest sha256 = MessageDigest.getInstance("Sha-256");
                byte[] hash = sha256.digest(text.getBytes(StandardCharsets.UTF_8));
                hashedValue = TextUtil.bytesToHexString((byte[])hash);
            }
            return hashedValue;
        }
    }
}

