/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.nE2Link.utils;

import com.ismacontrolli.nE2Link.BNe2DeviceExt;
import com.ismacontrolli.nE2Link.parser.binary.FileData;
import com.ismacontrolli.nE2Link.parser.binary.GetFileRequest;
import com.ismacontrolli.nE2Link.parser.binary.GetFileResponse;
import com.ismacontrolli.nE2Link.parser.binary.ResponseCode;
import com.ismacontrolli.nE2Link.utils.BFileDataArgs;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.logging.Logger;
import javax.baja.file.BDirectory;
import javax.baja.file.BIFile;
import javax.baja.naming.BOrd;
import javax.baja.sys.BObject;
import javax.baja.sys.Sys;
import javax.baja.util.Lexicon;

public class FileUtil {
    public static final Logger LOGGER = Logger.getLogger(Sys.getModuleForClass(FileUtil.class).getModuleName());
    public static final Lexicon LEX = Lexicon.make(FileUtil.class);
    public static final Character WINDOWS_SEPARATOR = Character.valueOf('\\');
    public static final Character UNIX_SEPARATOR = Character.valueOf('/');
    public static final int MAX_PARTIAL_FILE_CONTENT = 65536;

    public static void copyOrdTargetToFile(BOrd sourceOrd, File targetDir, boolean copyChildren, boolean replaceExisting) {
        BIFile sourceFile;
        BObject source = sourceOrd.get((BObject)Sys.getStation());
        if (!(source instanceof BIFile)) {
            return;
        }
        if (targetDir.exists() && !targetDir.isDirectory()) {
            targetDir.delete();
        }
        if (!targetDir.exists()) {
            targetDir.mkdirs();
        }
        if ((sourceFile = (BIFile)source).isDirectory()) {
            File newTargetDir = new File(targetDir, sourceFile.getFileName());
            if (!newTargetDir.exists()) {
                newTargetDir.mkdir();
            }
            if (copyChildren) {
                BIFile[] sourceFiles;
                for (BIFile fileToCopy : sourceFiles = ((BDirectory)sourceFile).listFiles()) {
                    FileUtil.copyOrdTargetToFile(fileToCopy.getOrdInSpace(), newTargetDir, copyChildren, replaceExisting);
                }
            }
        } else {
            File newTargetFile = new File(targetDir, sourceFile.getFileName());
            if (newTargetFile.exists() && replaceExisting) {
                newTargetFile.delete();
            }
            if (!newTargetFile.exists()) {
                try (FileOutputStream targetFileStream = new FileOutputStream(newTargetFile);){
                    targetFileStream.write(sourceFile.read());
                }
                catch (IOException e) {
                    LOGGER.severe("Failed to create file '" + newTargetFile.getPath() + "'\n" + e.getMessage());
                }
            }
        }
    }

    public static byte[] readNanoFile(BNe2DeviceExt controller, String filePath) throws Exception {
        return FileUtil.readNanoFile(controller, new File(filePath));
    }

    public static byte[] readNanoFile(BNe2DeviceExt controller, File file) throws Exception {
        return FileUtil.readNanoFile(controller, file.getParent(), file.getName());
    }

    public static byte[] readNanoFile(BNe2DeviceExt controller, String folderPath, String fileName) throws Exception {
        folderPath = FileUtil.toUnixPath(folderPath);
        int offset = 0;
        int chunkSize = 65536;
        int receivedDataSize = 65536;
        byte[] content = new byte[]{};
        while (receivedDataSize >= chunkSize) {
            byte[] receivedData = FileUtil.readPartialNanoFile(controller, folderPath, fileName, offset, chunkSize);
            receivedDataSize = receivedData.length;
            content = Arrays.copyOf(content, content.length + receivedDataSize);
            System.arraycopy(receivedData, 0, content, offset, receivedDataSize);
            offset += receivedDataSize;
        }
        return content;
    }

    public static byte[] readPartialNanoFile(BNe2DeviceExt controller, String folderPath, String fileName, int offset, int chunkSize) throws Exception {
        boolean error;
        BFileDataArgs fileDataArgs = new BFileDataArgs(folderPath, fileName, offset, chunkSize);
        GetFileRequest fileRequest = GetFileRequest.make(controller, fileDataArgs);
        GetFileResponse response = fileRequest.postRequest(controller.getRemoteDevice());
        boolean bl = error = response.getResponseCode() != ResponseCode.OK;
        if (!error) {
            FileData fileData = response.getResponseData();
            byte[] receivedData = fileData.getFileContent();
            return receivedData;
        }
        throw new RuntimeException(response.getLocalizedMessage());
    }

    public static String toUnixPath(String path) {
        return path != null ? path.replace(WINDOWS_SEPARATOR.charValue(), UNIX_SEPARATOR.charValue()) : null;
    }

    public static String toWindowsPath(String path) {
        return path != null ? path.replace(UNIX_SEPARATOR.charValue(), WINDOWS_SEPARATOR.charValue()) : null;
    }
}

