/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.nE2Link.utils;

import com.ismacontrolli.nE2Link.utils.ManifestHelper;
import com.ismacontrolli.nE2Link.utils.javabeans.HierarchicalManifest;
import com.ismacontrolli.nE2Link.utils.yamlbeans.YamlReader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Optional;
import javax.baja.file.BDirectory;
import javax.baja.file.BIFile;

public class BackupHelper {
    public static String getTimestampFromBackupManifest(BIFile backupDirectory) {
        HierarchicalManifest manifest;
        if (backupDirectory.getType() != BDirectory.TYPE) {
            return "";
        }
        Optional<BIFile> manifestFile = Arrays.stream(((BDirectory)backupDirectory).listFiles()).filter(file -> file.getFileName().equals("manifest.yml")).findFirst();
        if (!manifestFile.isPresent()) {
            return "";
        }
        try (InputStream is = manifestFile.get().getInputStream();
             YamlReader yaml = new YamlReader(new BufferedReader(new InputStreamReader(is)));){
            manifest = yaml.read(HierarchicalManifest.class);
        }
        catch (IOException exception) {
            System.out.println("[BackupHelper.getTimestampFromBackupManifest] Failed to read manifest file.\nException: " + exception.getMessage());
            return "";
        }
        LocalDateTime dateTime = ManifestHelper.fromUTCTimeTick(manifest.getDate());
        return dateTime.format(DateTimeFormatter.ofPattern("dd/MM/yyyy HH:mm"));
    }
}

