/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.nE2Link.utils;

import com.ismacontrolli.ifnetclient.model.RemoteDevice;
import com.ismacontrolli.nE2Link.BNanoComponent;
import com.ismacontrolli.nE2Link.BNe2DeviceExt;
import com.ismacontrolli.nE2Link.actions.BInstallUninstallSoftwareManagerArgs;
import com.ismacontrolli.nE2Link.actions.BSoftwareManagerArgs;
import com.ismacontrolli.nE2Link.notifications.BMessageNotification;
import com.ismacontrolli.nE2Link.notifications.BMessageTypeEnum;
import com.ismacontrolli.nE2Link.utils.BFileTransfer;
import com.ismacontrolli.nE2Link.utils.BUpgradingStatus;
import com.ismacontrolli.nE2Link.utils.OsUpdateHelper;
import com.ismacontrolli.serialization.DataMarker;
import com.ismacontrolli.serialization.SerializableForm;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="iFnetPort", type="int", defaultValue="80", flags=1), @NiagaraProperty(name="ipAddress", type="String", defaultValue="\"192.168.1.123\"", flags=1), @NiagaraProperty(name="lastConnected", type="String", defaultValue="", flags=1), @NiagaraProperty(name="macAddress", type="String", defaultValue="", flags=1), @NiagaraProperty(name="maximumDataPoints", type="int", defaultValue="150", flags=1), @NiagaraProperty(name="deviceName", type="String", defaultValue="", flags=1), @NiagaraProperty(name="model", type="String", defaultValue="", flags=1), @NiagaraProperty(name="oSVersion", type="String", defaultValue="", flags=1), @NiagaraProperty(name="minimumOsVersion", type="String", defaultValue="", flags=5), @NiagaraProperty(name="ping", type="String", defaultValue="", flags=1), @NiagaraProperty(name="serialNumber", type="double", defaultValue="0", facets={@Facet(name="BFacets.PRECISION", value="0")}, flags=1), @NiagaraProperty(name="notLoadedLibs", type="String", defaultValue="", flags=1)})
@NiagaraActions(value={@NiagaraAction(name="upgradeAll", flags=4), @NiagaraAction(name="installAndUninstallFiles", parameterType="BInstallUninstallSoftwareManagerArgs", defaultValue="new BInstallUninstallSoftwareManagerArgs()", flags=20), @NiagaraAction(name="restartDevice", flags=4)})
public class BSoftwareManager
extends BComponent {
    public static final Property iFnetPort = BSoftwareManager.newProperty((int)1, (int)80, null);
    public static final Property ipAddress = BSoftwareManager.newProperty((int)1, (String)"192.168.1.123", null);
    public static final Property lastConnected = BSoftwareManager.newProperty((int)1, (String)"", null);
    public static final Property macAddress = BSoftwareManager.newProperty((int)1, (String)"", null);
    public static final Property maximumDataPoints = BSoftwareManager.newProperty((int)1, (int)150, null);
    public static final Property deviceName = BSoftwareManager.newProperty((int)1, (String)"", null);
    public static final Property model = BSoftwareManager.newProperty((int)1, (String)"", null);
    public static final Property oSVersion = BSoftwareManager.newProperty((int)1, (String)"", null);
    public static final Property minimumOsVersion = BSoftwareManager.newProperty((int)5, (String)"", null);
    public static final Property ping = BSoftwareManager.newProperty((int)1, (String)"", null);
    public static final Property serialNumber = BSoftwareManager.newProperty((int)1, (int)0, (BFacets)BFacets.make((String)"precision", (int)0));
    public static final Property notLoadedLibs = BSoftwareManager.newProperty((int)1, (String)"", null);
    public static final Action upgradeAll = BSoftwareManager.newAction((int)4, null);
    public static final Action installAndUninstallFiles = BSoftwareManager.newAction((int)20, (BValue)new BInstallUninstallSoftwareManagerArgs(), null);
    public static final Action restartDevice = BSoftwareManager.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType(BSoftwareManager.class);
    protected static final Lexicon LEX = Lexicon.make(BSoftwareManager.class);
    private static final BIcon icon = BIcon.make((String)"module://nE2Link/rc/icons/x16/softwareManager.svg");
    protected static Logger LOGGER = Logger.getLogger(TYPE.getTypeSpec().getModuleName());
    public static final String UPGRADE_PROGRESS_PROP_NAME = "upgradeProp";
    private static final String systemLibraries = "/system/libraries";

    public int getIFnetPort() {
        return this.getInt(iFnetPort);
    }

    public void setIFnetPort(int v) {
        this.setInt(iFnetPort, v, null);
    }

    public String getIpAddress() {
        return this.getString(ipAddress);
    }

    public void setIpAddress(String v) {
        this.setString(ipAddress, v, null);
    }

    public String getLastConnected() {
        return this.getString(lastConnected);
    }

    public void setLastConnected(String v) {
        this.setString(lastConnected, v, null);
    }

    public String getMacAddress() {
        return this.getString(macAddress);
    }

    public void setMacAddress(String v) {
        this.setString(macAddress, v, null);
    }

    public int getMaximumDataPoints() {
        return this.getInt(maximumDataPoints);
    }

    public void setMaximumDataPoints(int v) {
        this.setInt(maximumDataPoints, v, null);
    }

    public String getDeviceName() {
        return this.getString(deviceName);
    }

    public void setDeviceName(String v) {
        this.setString(deviceName, v, null);
    }

    public String getModel() {
        return this.getString(model);
    }

    public void setModel(String v) {
        this.setString(model, v, null);
    }

    public String getOSVersion() {
        return this.getString(oSVersion);
    }

    public void setOSVersion(String v) {
        this.setString(oSVersion, v, null);
    }

    public String getMinimumOsVersion() {
        return this.getString(minimumOsVersion);
    }

    public void setMinimumOsVersion(String v) {
        this.setString(minimumOsVersion, v, null);
    }

    public String getPing() {
        return this.getString(ping);
    }

    public void setPing(String v) {
        this.setString(ping, v, null);
    }

    public double getSerialNumber() {
        return this.getDouble(serialNumber);
    }

    public void setSerialNumber(double v) {
        this.setDouble(serialNumber, v, null);
    }

    public String getNotLoadedLibs() {
        return this.getString(notLoadedLibs);
    }

    public void setNotLoadedLibs(String v) {
        this.setString(notLoadedLibs, v, null);
    }

    public void upgradeAll() {
        this.invoke(upgradeAll, null, null);
    }

    public void installAndUninstallFiles(BInstallUninstallSoftwareManagerArgs parameter) {
        this.invoke(installAndUninstallFiles, (BValue)parameter, null);
    }

    public void restartDevice() {
        this.invoke(restartDevice, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public String getDisplayName(Slot slot, Context cx) {
        if (slot.equals((Object)iFnetPort)) {
            return LEX.get("SoftwareManager.iFnetPort", "IFnet Port");
        }
        if (slot.equals((Object)oSVersion)) {
            return LEX.get("SoftwareManager.oSVersion", "OS Version");
        }
        return super.getDisplayName(slot, cx);
    }

    public void doUpgradeAll() {
    }

    public void doInstallAndUninstallFiles(BInstallUninstallSoftwareManagerArgs softwareManagerArgs) {
        Property upgradeProp = this.getProperty(UPGRADE_PROGRESS_PROP_NAME);
        try {
            int i;
            boolean flag = true;
            if (upgradeProp == null) {
                this.add(UPGRADE_PROGRESS_PROP_NAME, (BValue)BUpgradingStatus.inProgress, 5);
                upgradeProp = this.getProperty(UPGRADE_PROGRESS_PROP_NAME);
            } else {
                this.set(UPGRADE_PROGRESS_PROP_NAME, (BValue)BUpgradingStatus.inProgress);
            }
            String[] filesToInstall = softwareManagerArgs.getInstallFiles().split(";");
            String[] filesToUninstall = softwareManagerArgs.getUninstallFiles().split(";");
            if (filesToInstall.length != 1 || !filesToInstall[0].isEmpty()) {
                for (i = 0; i < filesToInstall.length; ++i) {
                    flag &= BSoftwareManager.install(new BSoftwareManagerArgs(filesToInstall[i]), (BNe2DeviceExt)this.getParent());
                }
            }
            if (filesToUninstall.length != 1 || !filesToUninstall[0].isEmpty()) {
                for (i = 0; i < filesToUninstall.length; ++i) {
                    flag &= BSoftwareManager.uninstall(new BSoftwareManagerArgs(filesToUninstall[i]), (BNe2DeviceExt)this.getParent());
                }
            }
            this.doRestartDevice(null);
            this.set(upgradeProp, (BValue)BUpgradingStatus.finished);
            if (!flag) {
                LOGGER.severe("Remote device is not connected! Please connect to device first before invoking this action!");
                BMessageNotification notification = BMessageNotification.make(BMessageTypeEnum.error, "Install File Error", "Remote device is not connected! Please connect to device first before invoking this action!");
                notification.raise((Context)softwareManagerArgs.getCallContext());
            }
        }
        catch (Exception exception) {
            LOGGER.severe("Remote device is not connected! Please connect to device first before invoking this action!");
            BMessageNotification notification = BMessageNotification.make(BMessageTypeEnum.error, "Install File Error", "Remote device is not connected! Please connect to device first before invoking this action!");
            notification.raise((Context)softwareManagerArgs.getCallContext());
            this.set(upgradeProp, (BValue)BUpgradingStatus.error);
        }
    }

    public static boolean install(BSoftwareManagerArgs softwareManagerArgs, BNe2DeviceExt ne2DeviceExt) throws IOException {
        RemoteDevice remoteDevice = ne2DeviceExt.getRemoteDevice();
        if (remoteDevice != null && remoteDevice.Remote.isConnected()) {
            BFileSystem fileSystem = BFileSystem.INSTANCE;
            boolean isOs = softwareManagerArgs.getLibraryName().contains("os-");
            BOrd originPath = isOs ? BNe2DeviceExt.OS_FILE_ORD.normalize() : BNe2DeviceExt.LIBRARIES_FILE_ORD.normalize();
            OrdQuery[] queries = BOrd.make((BOrd)originPath, (String)("file:" + softwareManagerArgs.getLibraryName())).normalize().parse();
            FilePath filePath = (FilePath)queries[queries.length - 1];
            BIFile file = fileSystem.findFile(filePath);
            if (file != null) {
                BFileTransfer fileTransfer = new BFileTransfer(ne2DeviceExt);
                String fileName = isOs ? "update.bin" : file.getFileName().split("-")[0] + ".pe";
                String systemUpdate = "/system/update";
                fileTransfer.filePut(isOs ? systemUpdate : systemLibraries, fileName, file.read());
            }
            return true;
        }
        return false;
    }

    public static boolean uninstall(BSoftwareManagerArgs softwareManagerArgs, BNe2DeviceExt ne2DeviceExt) {
        RemoteDevice remoteDevice = ne2DeviceExt.getRemoteDevice();
        if (remoteDevice != null && remoteDevice.Remote.isConnected()) {
            try {
                BFileTransfer fileTransfer = new BFileTransfer(ne2DeviceExt);
                fileTransfer.fileDelete(systemLibraries, softwareManagerArgs.getLibraryName());
                return true;
            }
            catch (Exception e) {
                LOGGER.severe("[uninstall] failed to uninstall library " + softwareManagerArgs.getLibraryName());
                return false;
            }
        }
        return false;
    }

    public void doRestartDevice(Context context) {
        BNe2DeviceExt ne2DeviceExt = (BNe2DeviceExt)this.getParent();
        RemoteDevice remoteDevice = ne2DeviceExt.getRemoteDevice();
        if (remoteDevice != null && remoteDevice.Remote.isConnected()) {
            BNanoComponent iFnetService = (BNanoComponent)ne2DeviceExt.doGetNanoComponentByName(BString.make((String)"iFnet"));
            Object[] writeData = new Object[]{(short)iFnetService.getGlobalIndex(), "RestartDevice", null};
            SerializableForm actionData = new SerializableForm(DataMarker.WriteData, writeData);
            ArrayList<SerializableForm> response = remoteDevice.Remote.Invoke(actionData);
            if (response != null) {
                for (SerializableForm responseElem : response) {
                    for (SerializableForm elem : responseElem.elements.toSerializableForms()) {
                        if (LOGGER.isLoggable(Level.INFO)) {
                            LOGGER.info(String.format("[doRestartDevice]: elem.marker: '%s'.\n", new Object[]{elem.marker}));
                        }
                        if (elem.marker != DataMarker.ErrorData) continue;
                        LOGGER.severe("restart device has failed.");
                    }
                }
            }
            ne2DeviceExt.disconnect();
        } else {
            LOGGER.severe("Remote device is not connected! Please connect to device first before invoking this action!");
            BMessageNotification notification = BMessageNotification.make(BMessageTypeEnum.deviceDisconnected);
            notification.raise((Context)context.getFacets());
        }
    }

    public boolean versionSmallerThan(String targetVersion) {
        String[] version1Parts = this.getOSVersion().split("\\.");
        String[] version2Parts = targetVersion.split("\\.");
        int length = Math.max(version1Parts.length, version2Parts.length);
        for (int i = 0; i < length; ++i) {
            int version2Part;
            int version1Part;
            int n = version1Parts[i].equals("") ? 0 : (version1Part = i < version1Parts.length ? Integer.parseInt(version1Parts[i]) : 0);
            int n2 = version2Parts[i].equals("") ? 0 : (version2Part = i < version2Parts.length ? Integer.parseInt(version2Parts[i]) : 0);
            if (version1Part >= version2Part) continue;
            return true;
        }
        return false;
    }

    public boolean versionGreaterThan(String targetVersion) {
        return !this.versionSmallerThan(targetVersion);
    }

    public boolean isChildLegal(BComponent child) {
        return false;
    }

    public boolean shouldBlockVersionChange(String installedVersion, String selectedVersion) {
        if (OsUpdateHelper.compareVersions(selectedVersion, this.getMinimumOsVersion()) < 0) {
            return true;
        }
        String minPossible = "";
        if (OsUpdateHelper.compareVersions(installedVersion, "1.8.0.0") >= 0) {
            minPossible = "1.8.0.0";
        } else if (OsUpdateHelper.compareVersions(installedVersion, "1.7.0.0") >= 0) {
            minPossible = "1.7.0.0";
        }
        return !minPossible.equals("") && OsUpdateHelper.compareVersions(selectedVersion, minPossible) < 0;
    }

    public BIcon getIcon() {
        return icon;
    }
}

