/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.nE2Link.utils;

import com.ismacontrolli.nE2Link.utils.BBackupFile;
import java.util.ArrayList;
import java.util.List;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BString;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BListOfBackupFiles
extends BComponent {
    public static final Type TYPE = Sys.loadType(BListOfBackupFiles.class);
    List<BBackupFile> backupFiles = new ArrayList<BBackupFile>();

    public Type getType() {
        return TYPE;
    }

    public void addBackupFile(BBackupFile backupFile) {
        this.backupFiles.add(backupFile);
    }

    public void removeBackupFile(BBackupFile backupFile) {
        this.backupFiles.remove((Object)backupFile);
    }

    public List<BBackupFile> getBackupFiles() {
        return this.backupFiles;
    }

    public BString encodeToString() {
        StringBuilder sb = new StringBuilder("");
        for (BBackupFile backupFile : this.getBackupFiles()) {
            sb.append(backupFile.getBackupName()).append(";" + backupFile.getTimestamp()).append(";" + backupFile.getDeviceModel());
            sb.append("\n");
        }
        return sb.length() > 0 ? BString.make((String)sb.substring(0, sb.length() - 1)) : BString.make((String)sb.toString());
    }

    public static List<BBackupFile> decodeFromString(BString s) {
        ArrayList<BBackupFile> backupFiles = new ArrayList<BBackupFile>();
        if (s.getString().length() > 0) {
            String[] backups;
            for (String backup : backups = s.getString().split("\n")) {
                String[] items = backup.split(";");
                if (items.length < 3) continue;
                backupFiles.add(new BBackupFile(items[0], items[1], items[2]));
            }
        }
        return backupFiles;
    }
}

