/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.nE2Link.utils;

import javax.baja.nre.annotations.NiagaraEnum;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.annotations.Range;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.BIcon;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraEnum(range={@Range(ordinal=0, value="connected"), @Range(ordinal=1, value="connecting"), @Range(ordinal=2, value="disconnected"), @Range(ordinal=3, value="disconnecting"), @Range(ordinal=4, value="permanentlyDisconnected")}, defaultValue="permanentlyDisconnected")
public final class BConnectionStatus
extends BFrozenEnum {
    public static final int CONNECTED = 0;
    public static final int CONNECTING = 1;
    public static final int DISCONNECTED = 2;
    public static final int DISCONNECTING = 3;
    public static final int PERMANENTLY_DISCONNECTED = 4;
    public static final BConnectionStatus connected = new BConnectionStatus(0);
    public static final BConnectionStatus connecting = new BConnectionStatus(1);
    public static final BConnectionStatus disconnected = new BConnectionStatus(2);
    public static final BConnectionStatus disconnecting = new BConnectionStatus(3);
    public static final BConnectionStatus permanentlyDisconnected;
    public static final BConnectionStatus DEFAULT;
    public static final Type TYPE;
    public static final String ICON_BASE_ORD = "module://nE2Link/rc/icons/connectionIcons/";
    public static final BIcon ICON_GREY;
    public static final BIcon ICON_ORANGE;
    public static final BIcon ICON_YELLOW;
    public static final BIcon ICON_GREEN;
    private static final Lexicon LEX;

    public static BConnectionStatus make(int ordinal) {
        return (BConnectionStatus)connected.getRange().get(ordinal, false);
    }

    public static BConnectionStatus make(String tag) {
        return (BConnectionStatus)connected.getRange().get(tag);
    }

    private BConnectionStatus(int ordinal) {
        super(ordinal);
    }

    public Type getType() {
        return TYPE;
    }

    public String getDisplayText(boolean isApplicationLoading) {
        String status = "--";
        switch (this.getOrdinal()) {
            case 2: 
            case 4: {
                status = LEX.get("ConnectionStatus.disconnected", "Disconnected");
                break;
            }
            case 1: {
                status = LEX.get("ConnectionStatus.connecting", "Connecting");
                break;
            }
            case 0: {
                status = isApplicationLoading ? LEX.get("ConnectionStatus.connected.loading", "Connected (Loading in Progress)") : LEX.get("ConnectionStatus.connected.ready", "Connected (Ready)");
                break;
            }
        }
        return status;
    }

    public BIcon getConnectionIcon(boolean isApplicationLoading) {
        switch (this.getOrdinal()) {
            case 2: 
            case 4: {
                return ICON_GREY;
            }
            case 1: {
                return ICON_ORANGE;
            }
            case 0: {
                if (isApplicationLoading) {
                    return ICON_YELLOW;
                }
                return ICON_GREEN;
            }
        }
        return super.getIcon();
    }

    static {
        DEFAULT = permanentlyDisconnected = new BConnectionStatus(4);
        TYPE = Sys.loadType(BConnectionStatus.class);
        ICON_GREY = BIcon.make((String)"module://nE2Link/rc/icons/connectionIcons/MISC_UI_LED_GREY.svg");
        ICON_ORANGE = BIcon.make((String)"module://nE2Link/rc/icons/connectionIcons/MISC_UI_LED_ORANGE.svg");
        ICON_YELLOW = BIcon.make((String)"module://nE2Link/rc/icons/connectionIcons/MISC_UI_LED_YELLOW.svg");
        ICON_GREEN = BIcon.make((String)"module://nE2Link/rc/icons/connectionIcons/MISC_UI_LED_GREEN.svg");
        LEX = Lexicon.make(BConnectionStatus.class);
    }
}

