/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.nE2Link.utils;

import com.ismacontrolli.nE2Link.BNe2DeviceExt;
import com.ismacontrolli.nE2Link.utils.BBackupFile;
import com.ismacontrolli.nE2Link.utils.BFileTransfer;
import com.ismacontrolli.nE2Link.utils.BListOfBackupFiles;
import com.ismacontrolli.nE2Link.utils.ManifestHelper;
import com.ismacontrolli.nE2Link.utils.OsUpdateHelper;
import com.ismacontrolli.nE2Link.utils.javabeans.HierarchicalManifest;
import com.ismacontrolli.nE2Link.utils.yamlbeans.YamlException;
import com.ismacontrolli.nE2Link.utils.yamlbeans.YamlReader;
import java.io.IOException;
import java.io.OutputStream;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import java.util.Optional;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BBackupRestoreManager
extends BComponent {
    public static final Type TYPE = Sys.loadType(BBackupRestoreManager.class);
    BNe2DeviceExt ne2DeviceExt;
    boolean takeFromDevice;
    String selectedBackupPath;
    BDirectory tempBackupsFolder = null;
    ManifestHelper manifestHelper;

    public Type getType() {
        return TYPE;
    }

    public BBackupRestoreManager(BNe2DeviceExt ne2DeviceExt) {
        this(ne2DeviceExt, "", false, false);
    }

    public BBackupRestoreManager(BNe2DeviceExt ne2DeviceExt, String selectedBackupPath, boolean withIpSettings, boolean takeFromDevice) {
        this.ne2DeviceExt = ne2DeviceExt;
        this.selectedBackupPath = selectedBackupPath;
        this.takeFromDevice = takeFromDevice;
        this.manifestHelper = new ManifestHelper(ne2DeviceExt, withIpSettings, takeFromDevice);
    }

    public void removeTemporaryCopy() throws IOException {
        this.manifestHelper.getTempDirectory().delete();
    }

    public BDirectory prepareTemporaryCopy() throws IOException {
        this.manifestHelper.getTempDirectory().delete();
        BDirectory tempDirectory = this.manifestHelper.getTempDirectory();
        if (!this.takeFromDevice) {
            BOrd localBackupOrd = BOrd.make((BOrd)BNe2DeviceExt.BACKUPS_FILE_ORD, (String)("file:" + this.selectedBackupPath));
            OrdQuery[] queries = localBackupOrd.normalize().parse();
            FilePath filePath = (FilePath)queries[queries.length - 1];
            BIFile sourceFile = BFileSystem.INSTANCE.findFile(filePath);
            BDirectory localBackupFolder = BFileSystem.INSTANCE.makeDir(filePath);
            ManifestHelper.copyFilesRecursively(localBackupFolder, tempDirectory);
        } else if (!this.manifestHelper.takeManifestFromDevice("/system/backup", "manifest.yml") || !this.manifestHelper.takeManifestFromDevice("/system/backup", "files.yml")) {
            throw new RuntimeException("Transferring manifest file of backup from device failed.");
        }
        return tempDirectory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean transferFilesIntoDevice() throws IOException {
        boolean ok = false;
        try {
            ok = this.manifestHelper.generateRestoreIndicator();
            if (ok) {
                if (this.isRestoreDirOnDevice()) {
                    this.cleanRemoteDirectory("/system/restore");
                }
                BIFile[] files = this.manifestHelper.getTempDirectory().listFiles();
                BFileTransfer fileTransfer = new BFileTransfer(this.ne2DeviceExt);
                for (BIFile file : files) {
                    fileTransfer.filePut("/system/restore", file.getFileName(), file.read());
                }
                Map<String, LocalDateTime> restoreFiles = fileTransfer.folderGet("/system/restore");
                int remoteFilesCount = restoreFiles.size();
                ok = remoteFilesCount == files.length;
            }
        }
        finally {
            this.manifestHelper.getTempDirectory().delete();
        }
        return ok;
    }

    public boolean shouldAllowRestore(boolean withIpSettings, String osVersionFromBackup, String installedOsVersion) {
        if (withIpSettings) {
            return true;
        }
        return OsUpdateHelper.compareVersions(installedOsVersion, "1.7.0.0") < 0 || OsUpdateHelper.compareVersions(osVersionFromBackup, "1.7.0.0") >= 0;
    }

    public boolean removeConfigurationFilesIfNeeded(String osVersionFromBackup) {
        boolean ok = true;
        try {
            BFileTransfer fileTransfer = new BFileTransfer(this.ne2DeviceExt);
            if (OsUpdateHelper.compareVersions(osVersionFromBackup, "1.7.0.0") < 0) {
                fileTransfer.fileDelete("/configs", "framework.core.dns.config.json");
                fileTransfer.fileDelete("/configs", "framework.core.ethernet.config.json");
                fileTransfer.fileDelete("/configs", "framework.core.ifnet.config.json");
            }
            if (OsUpdateHelper.compareVersions(osVersionFromBackup, "1.6.0.0") < 0) {
                fileTransfer.fileDelete("/configs", "framework.core.config.json");
                fileTransfer.fileDelete("/configs", "library.bacnet.config.json");
            }
        }
        catch (Exception e) {
            ok = false;
        }
        return ok;
    }

    private boolean isRestoreDirOnDevice() {
        BFileTransfer fileTransfer = new BFileTransfer(this.ne2DeviceExt);
        Map<String, LocalDateTime> folderInfo = fileTransfer.folderGet("/system");
        return folderInfo.keySet().contains("restore");
    }

    private boolean cleanRemoteDirectory(String directoryPath) {
        BFileTransfer fileTransfer = new BFileTransfer(this.ne2DeviceExt);
        Map<String, LocalDateTime> restoreFiles = fileTransfer.folderGet("/system/restore");
        restoreFiles.keySet().forEach(m -> fileTransfer.fileDelete("/system/restore", (String)m));
        restoreFiles = fileTransfer.folderGet("/system/restore");
        return restoreFiles.size() == 0;
    }

    public void prepareArchiveTempDir() {
    }

    public boolean downloadBackup(String backupFileName) throws Exception {
        boolean ok = true;
        OrdQuery[] backupQueries = BOrd.make((BOrd)BNe2DeviceExt.BACKUPS_FILE_ORD, (String)("file:" + backupFileName)).normalize().parse();
        FilePath backupFilePath = (FilePath)backupQueries[backupQueries.length - 1];
        if (BFileSystem.INSTANCE.findFile(backupFilePath) != null) {
            BFileSystem.INSTANCE.delete(backupFilePath);
        }
        BFileSystem.INSTANCE.makeDir(backupFilePath);
        BFileTransfer fileTransfer = new BFileTransfer(this.ne2DeviceExt);
        Map<String, LocalDateTime> systemFiles = fileTransfer.folderGet("/system/backup");
        systemFiles.keySet().forEach(f -> {
            System.out.println("[doRestoreOnDeviceBackup] backupFiles file: " + f);
            byte[] fileContent = fileTransfer.getFileContent("/system/backup", (String)f);
            if (fileContent != null && fileContent.length > 0) {
                try {
                    OrdQuery[] queries = BOrd.make((BOrd)BNe2DeviceExt.BACKUPS_FILE_ORD, (String)("file:" + backupFileName + "/" + f)).normalize().parse();
                    FilePath filePath = (FilePath)queries[queries.length - 1];
                    BFileSystem fileSystem = BFileSystem.INSTANCE;
                    if (fileSystem.findFile(filePath) != null) {
                        fileSystem.delete(filePath);
                    }
                    BIFile file = fileSystem.makeFile(filePath);
                    OutputStream out = file.getOutputStream();
                    out.write(fileContent);
                    out.flush();
                    out.close();
                }
                catch (Exception e) {
                    System.out.println("[doRestoreOnDeviceBackup] failed to save systemFile: " + f);
                }
            }
        });
        return ok;
    }

    public BListOfBackupFiles doGetOnDeviceBackups() {
        BListOfBackupFiles onDeviceBackups = new BListOfBackupFiles();
        BFileTransfer fileTransfer = new BFileTransfer(this.ne2DeviceExt);
        Map<String, LocalDateTime> files = fileTransfer.folderGet("/system/backup");
        if (files.keySet().contains("manifest.sig")) {
            Map<String, Map<LocalDateTime, Object[]>> map = fileTransfer.fileGet("/system/backup", "manifest.sig");
        }
        if (!files.keySet().contains("manifest.yml")) {
            return new BListOfBackupFiles();
        }
        Map<String, Map<LocalDateTime, Object[]>> manifestYml = fileTransfer.fileGet("/system/backup", "manifest.yml");
        manifestYml.entrySet().stream().forEach(m -> {
            BBackupFile backupFile = new BBackupFile();
            backupFile.setBackupName("Backup_" + String.format("%.0f", this.ne2DeviceExt.getSoftwareManager().getSerialNumber()));
            Map details = (Map)m.getValue();
            Optional key0 = details.keySet().stream().findFirst();
            if (!key0.isPresent()) {
                return;
            }
            Object[] objects = (Object[])details.get(key0.get());
            int length = 0;
            for (Object obj : objects) {
                length += ((byte[])obj).length;
            }
            byte[] fileContent = new byte[length];
            int index = 0;
            for (Object obj : objects) {
                System.arraycopy(obj, 0, fileContent, index, ((byte[])obj).length);
                index += ((byte[])obj).length;
            }
            try (YamlReader yaml = new YamlReader(new String(fileContent));){
                HierarchicalManifest hierarchicalManifest = yaml.read(HierarchicalManifest.class);
                if (null == hierarchicalManifest) {
                    return;
                }
                long timerTicks = hierarchicalManifest.getDate();
                LocalDateTime datetime = ManifestHelper.fromUTCTimeTick(timerTicks);
                DateTimeFormatter dtFormatter = DateTimeFormatter.ofPattern("dd/MM/yyyy HH:mm");
                try {
                    backupFile.setTimestamp(datetime.format(dtFormatter));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    backupFile.setTimestamp(datetime.toString());
                }
                backupFile.setDeviceModel(this.ne2DeviceExt.getSoftwareManager().getModel());
                onDeviceBackups.addBackupFile(backupFile);
            }
            catch (YamlException ye) {
                ye.printStackTrace();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        });
        return onDeviceBackups;
    }

    public ManifestHelper getManifestHelper() {
        return this.manifestHelper;
    }

    public static enum BackupStatus {
        OK,
        BackupInProgress,
        CouldNotStart,
        Disconnected,
        Error;

    }

    public static enum BackupAction {
        None,
        InProgress;

    }
}

