/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.nE2Link.threading;

import java.util.logging.Logger;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Context;
import javax.baja.sys.NotRunningException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BWorker;
import javax.baja.util.CoalesceQueue;
import javax.baja.util.Queue;
import javax.baja.util.Worker;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="queueSize", type="int", defaultValue="100"), @NiagaraProperty(name="isCoalescing", type="boolean", defaultValue="false")})
public class BSingleThreadWorker
extends BWorker {
    public static final Property queueSize = BSingleThreadWorker.newProperty((int)0, (int)100, null);
    public static final Property isCoalescing = BSingleThreadWorker.newProperty((int)0, (boolean)false, null);
    public static final Type TYPE = Sys.loadType(BSingleThreadWorker.class);
    private Worker _worker;
    protected static Logger LOGGER = Logger.getLogger(TYPE.getTypeSpec().getModuleName());

    public int getQueueSize() {
        return this.getInt(queueSize);
    }

    public void setQueueSize(int v) {
        this.setInt(queueSize, v, null);
    }

    public boolean getIsCoalescing() {
        return this.getBoolean(isCoalescing);
    }

    public void setIsCoalescing(boolean v) {
        this.setBoolean(isCoalescing, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BSingleThreadWorker() {
    }

    public BSingleThreadWorker(int queueSize, boolean isCoalescing) {
        this();
        this.setIsCoalescing(isCoalescing);
        this.setQueueSize(queueSize);
    }

    public Worker getWorker() {
        return this._worker != null ? this._worker : this.createWorkerWithQueue();
    }

    public void postAsync(Runnable r) {
        Queue queue = (Queue)this.getWorker().getTodo();
        if (queue == null) {
            throw new NotRunningException();
        }
        queue.enqueue((Object)r);
    }

    public void started() throws Exception {
        this.createWorkerWithQueue();
        LOGGER.finest("Worker for async operations started: " + this.toString(null));
    }

    public void changed(Property prop, Context cx) {
        if (!this.isRunning()) {
            return;
        }
        if (prop.equals(queueSize) || prop.equals(isCoalescing)) {
            this.createWorkerWithQueue();
        }
    }

    public String toString(Context context) {
        return '[' + (this.isMounted() ? this.getNavOrd().relativizeToHost().toString() : ((Object)((Object)this)).getClass().getSimpleName()) + "]:queueSize=" + this.getQueueSize() + ", " + (!this.getIsCoalescing() ? "non-" : "") + "coalescing";
    }

    protected Worker createWorkerWithQueue() {
        this.eraseWorker();
        Object newQueue = this.getIsCoalescing() ? new CoalesceQueue(this.getQueueSize()) : new Queue(this.getQueueSize());
        this._worker = new Worker((Worker.ITodo)newQueue);
        LOGGER.finest("Created new worker for async operations: " + this.toString());
        this._worker.start(this.getWorkerThreadName());
        return this._worker;
    }

    protected void eraseWorker() {
        Queue queue = null;
        if (this._worker != null) {
            queue = (Queue)this._worker.getTodo();
            this._worker.stop();
        }
        if (queue != null) {
            queue.clear();
        }
        this._worker = null;
    }
}

