/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.nE2Link.services;

import java.util.logging.Logger;
import javax.baja.naming.BOrd;
import javax.baja.sys.BAbstractService;
import javax.baja.sys.BObject;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BServiceContainer;

public interface IAutoInstallableService {
    public static final Logger LOGGER = Logger.getLogger("nE2Link");

    public static <T extends BAbstractService> T autoInstall(Class<T> serviceClass) {
        Object service = IAutoInstallableService.get(serviceClass);
        if (service == null) {
            LOGGER.info(String.format("Service '%s' not installed or not running.\nAttempting to auto-install service.", serviceClass.getSimpleName()));
            try {
                BOrd serviceOrd = BOrd.make((String)"slot:/Services");
                BServiceContainer serviceContainer = (BServiceContainer)serviceOrd.get((BObject)Sys.getStation());
                Type serviceType = Sys.loadType(serviceClass);
                service = (BAbstractService)serviceType.getTypeClass().newInstance();
                serviceContainer.add((String)null, service);
                LOGGER.info(String.format("Successfully auto-installed service '%s'.", serviceClass.getSimpleName()));
            }
            catch (Exception e) {
                LOGGER.warning(String.format("Unable to auto-install service '%s'.\nVerify that module nE2Link-rt is present and manually install service", serviceClass.getSimpleName()));
            }
        }
        return service;
    }

    public static <T extends BAbstractService> boolean exists(Class<T> serviceClass) {
        BAbstractService service = null;
        Type serviceType = Sys.loadType(serviceClass);
        try {
            service = (BAbstractService)Sys.getService((Type)serviceType);
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            // empty catch block
        }
        return service != null;
    }

    public static <T extends BAbstractService> T get(Class<T> serviceClass) {
        BAbstractService service = null;
        Type serviceType = Sys.loadType(serviceClass);
        try {
            service = (BAbstractService)Sys.getService((Type)serviceType);
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            // empty catch block
        }
        return (T)service;
    }
}

