/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.nE2Link.services;

import com.ismacontrolli.nE2Link.BNe2DeviceExt;
import com.ismacontrolli.nE2Link.services.BAutoDisconnectSettings;
import com.ismacontrolli.nE2Link.services.BNe2UsbDevice;
import com.ismacontrolli.nE2Link.services.IAutoInstallableService;
import java.util.ArrayList;
import javax.baja.collection.BITable;
import javax.baja.collection.TableCursor;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BAbstractService;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BServiceContainer;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraActions(value={@NiagaraAction(name="getNe2DeviceExtParents", returnType="BOrdList", flags=4), @NiagaraAction(name="applyAutoDisconnectSettings", parameterType="BAutoDisconnectSettings", defaultValue="new BAutoDisconnectSettings()", flags=20)})
@NiagaraProperties(value={@NiagaraProperty(name="usbDevice", type="BNe2UsbDevice", defaultValue="new BNe2UsbDevice()"), @NiagaraProperty(name="isProtected", type="boolean", defaultValue="true", flags=4), @NiagaraProperty(name="autoDisconnectSettings", type="BAutoDisconnectSettings", defaultValue="new BAutoDisconnectSettings()", flags=4)})
public class BNe2LinkService
extends BAbstractService
implements IAutoInstallableService {
    public static final Property usbDevice = BNe2LinkService.newProperty((int)0, (BValue)new BNe2UsbDevice(), null);
    public static final Property isProtected = BNe2LinkService.newProperty((int)4, (boolean)true, null);
    public static final Property autoDisconnectSettings = BNe2LinkService.newProperty((int)4, (BValue)new BAutoDisconnectSettings(), null);
    public static final Action getNe2DeviceExtParents = BNe2LinkService.newAction((int)4, null);
    public static final Action applyAutoDisconnectSettings = BNe2LinkService.newAction((int)20, (BValue)new BAutoDisconnectSettings(), null);
    public static final Type TYPE = Sys.loadType(BNe2LinkService.class);
    private static Type[] SERVICE_TYPES = new Type[]{TYPE};
    protected static final Lexicon LEX = Lexicon.make(BNe2LinkService.class);
    private static final BIcon icon = BIcon.make((String)"module://nE2Link/rc/icons/x16/nE2LinkService.svg");

    public BNe2UsbDevice getUsbDevice() {
        return (BNe2UsbDevice)this.get(usbDevice);
    }

    public void setUsbDevice(BNe2UsbDevice v) {
        this.set(usbDevice, (BValue)v, null);
    }

    public boolean getIsProtected() {
        return this.getBoolean(isProtected);
    }

    public void setIsProtected(boolean v) {
        this.setBoolean(isProtected, v, null);
    }

    public BAutoDisconnectSettings getAutoDisconnectSettings() {
        return (BAutoDisconnectSettings)this.get(autoDisconnectSettings);
    }

    public void setAutoDisconnectSettings(BAutoDisconnectSettings v) {
        this.set(autoDisconnectSettings, (BValue)v, null);
    }

    public BOrdList getNe2DeviceExtParents() {
        return (BOrdList)this.invoke(getNe2DeviceExtParents, null, null);
    }

    public void applyAutoDisconnectSettings(BAutoDisconnectSettings parameter) {
        this.invoke(applyAutoDisconnectSettings, (BValue)parameter, null);
    }

    public Type getType() {
        return TYPE;
    }

    public Type[] getServiceTypes() {
        return SERVICE_TYPES;
    }

    public BValue getActionParameterDefault(Action action) {
        if (action.equals(applyAutoDisconnectSettings)) {
            if (!Sys.isStation()) {
                this.lease(1);
            }
            return this.getAutoDisconnectSettings();
        }
        return super.getActionParameterDefault(action);
    }

    public String getDisplayName(Slot slot, Context cx) {
        String displayName = super.getDisplayName(slot, cx);
        if (slot.equals((Object)usbDevice)) {
            displayName = LEX.get("Ne2LinkService.usbDevice.displayName", displayName);
        }
        return displayName;
    }

    public boolean isParentLegal(BComponent parent) {
        try {
            BComponent[] registeredServices = Sys.getServices((Type)TYPE);
        }
        catch (ServiceNotFoundException e) {
            return parent.getType().is(BServiceContainer.TYPE);
        }
        return false;
    }

    public boolean isComponentReadonly() {
        return this.getIsProtected();
    }

    public BOrdList doGetNe2DeviceExtParents(Context cx) {
        BOrd bqlQuery = BOrd.make((String)String.format("bql: select from %s where nE2Link:Bql.hasChildOfType(%s)", BComponent.TYPE.getTypeSpec().toString(), BNe2DeviceExt.TYPE.getTypeSpec().toString()));
        BITable queryResult = (BITable)bqlQuery.get((BObject)Sys.getStation());
        TableCursor crsr = queryResult.cursor();
        ArrayList<BOrd> componentOrds = new ArrayList<BOrd>();
        while (crsr.next()) {
            BComponent component = (BComponent)crsr.get();
            componentOrds.add(component.getOrdInSpace());
        }
        return BOrdList.make((BOrd[])componentOrds.toArray(new BOrd[0]));
    }

    public void doApplyAutoDisconnectSettings(BAutoDisconnectSettings autoDisconnectSettings, Context cx) {
        BOrd bqlQuery = BOrd.make((String)String.format("bql: select from %s where nE2Link:Bql.hasChildOfType(%s)", BComponent.TYPE.getTypeSpec().toString(), BNe2DeviceExt.TYPE.getTypeSpec().toString()));
        BITable queryResult = (BITable)bqlQuery.get((BObject)Sys.getStation());
        TableCursor crsr = queryResult.cursor();
        while (crsr.next()) {
            BNe2DeviceExt[] ne2DeviceExts;
            BComponent component = (BComponent)crsr.get();
            for (BNe2DeviceExt ne2DeviceExt : ne2DeviceExts = (BNe2DeviceExt[])component.getChildren(BNe2DeviceExt.class)) {
                try {
                    component.getComponentSpace().sync();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ne2DeviceExt.setAutoDisconnectSettings((BAutoDisconnectSettings)autoDisconnectSettings.newCopy());
            }
        }
        try {
            this.setAutoDisconnectSettings((BAutoDisconnectSettings)autoDisconnectSettings.newCopy());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public BIcon getIcon() {
        return icon;
    }
}

