/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.nE2Link.services;

import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="disconnectTime", type="BRelTime", defaultValue="BRelTime.makeMinutes(15)", facets={@Facet(name="BFacets.MIN", value="BRelTime.makeSeconds(0)")}), @NiagaraProperty(name="disconnectWarningTime", type="BRelTime", defaultValue="BRelTime.makeSeconds(30)", facets={@Facet(name="BFacets.MIN", value="BRelTime.makeSeconds(0)"), @Facet(name="BFacets.MAX", value="BRelTime.make(0, 0, 14, 30)")})})
public class BAutoDisconnectSettings
extends BComponent {
    public static final Property disconnectTime = BAutoDisconnectSettings.newProperty((int)0, (BValue)BRelTime.makeMinutes((int)15), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.makeSeconds((int)0)));
    public static final Property disconnectWarningTime = BAutoDisconnectSettings.newProperty((int)0, (BValue)BRelTime.makeSeconds((int)30), (BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.makeSeconds((int)0)), (BFacets)BFacets.make((String)"max", (BIDataValue)BRelTime.make((int)0, (int)0, (int)14, (int)30))));
    public static final Type TYPE = Sys.loadType(BAutoDisconnectSettings.class);
    private static final BIcon icon = BIcon.make((String)"module://nE2Link/rc/icons/x16/autoDisconnectSettings.svg");
    private static boolean disabledLogShown = false;
    protected static Logger LOGGER = Logger.getLogger(TYPE.getTypeSpec().getModuleName());

    public BRelTime getDisconnectTime() {
        return (BRelTime)this.get(disconnectTime);
    }

    public void setDisconnectTime(BRelTime v) {
        this.set(disconnectTime, (BValue)v, null);
    }

    public BRelTime getDisconnectWarningTime() {
        return (BRelTime)this.get(disconnectWarningTime);
    }

    public void setDisconnectWarningTime(BRelTime v) {
        this.set(disconnectWarningTime, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void changed(Property property, Context context) {
        BComplex parent = this.getParent();
        if (parent instanceof BComponent) {
            ((BComponent)parent).changed(this.getPropertyInParent(), context);
        }
        if (property.equals(disconnectTime)) {
            if (this.getDisconnectTime().getMillis() <= 0L && !disabledLogShown) {
                LOGGER.info("Auto-disconnect is disabled.");
                disabledLogShown = true;
            } else if (this.getDisconnectTime().getMillis() > 0L) {
                disabledLogShown = false;
            }
        }
    }

    public BIcon getIcon() {
        return icon;
    }
}

