/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.nE2Link.security;

import com.ismacontrolli.nE2Link.BNanoBaseComponent;
import com.ismacontrolli.nE2Link.actions.BNanoStringAction;
import com.ismacontrolli.nE2Link.security.BNanoPassword;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraAction(name="cp", parameterType="BComponent", defaultValue="new BComponent()", facets={@Facet(name="BFacets.FIELD_EDITOR", value="\"nE2Link:ChangeNanoPasswordFE\"")})
@NiagaraProperties(value={@NiagaraProperty(name="password", type="BNanoPassword", defaultValue="BNanoPassword.make(\"\", BNanoUser.DEFAULT_PASSPHRASE)", flags=4), @NiagaraProperty(name="disablePasswordChange", type="boolean", defaultValue="false", flags=4)})
public class BNanoUser
extends BNanoBaseComponent {
    public static final Property password = BNanoUser.newProperty((int)4, (BValue)BNanoPassword.make("", "Mira-Tech and iSMAControlli have secrets"), null);
    public static final Property disablePasswordChange = BNanoUser.newProperty((int)4, (boolean)false, null);
    public static final Action cp = BNanoUser.newAction((int)0, (BValue)new BComponent(), (BFacets)BFacets.make((String)"fieldEditor", (String)"nE2Link:ChangeNanoPasswordFE"));
    public static final Type TYPE = Sys.loadType(BNanoUser.class);
    static final String DEFAULT_PASSPHRASE = "Mira-Tech and iSMAControlli have secrets";

    public BNanoPassword getPassword() {
        return (BNanoPassword)this.get(password);
    }

    public void setPassword(BNanoPassword v) {
        this.set(password, (BValue)v, null);
    }

    public boolean getDisablePasswordChange() {
        return this.getBoolean(disablePasswordChange);
    }

    public void setDisablePasswordChange(boolean v) {
        this.setBoolean(disablePasswordChange, v, null);
    }

    public void cp(BComponent parameter) {
        this.invoke(cp, (BValue)parameter, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BNanoUser() {
    }

    public BNanoUser(String name) {
        this(name, true);
    }

    public BNanoUser(String name, boolean disablePasswordChange) {
        this.setNanoName(name);
        this.setDisablePasswordChange(disablePasswordChange);
    }

    public BNanoUser(String name, String password, boolean disablePasswordChange) {
        this(name, disablePasswordChange);
        BNanoPassword nanoPassword = BNanoPassword.make(password, DEFAULT_PASSPHRASE);
        this.setDisablePasswordChange(disablePasswordChange);
    }

    @Override
    public BValue getActionParameterDefault(Action action) {
        if (action.getName().equals("cp")) {
            return this;
        }
        return super.getActionParameterDefault(action);
    }

    @Override
    public void changed(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        if (property.equals(disablePasswordChange)) {
            this.setCpActionVisibility(this.getDisablePasswordChange());
        }
        super.changed(property, context);
    }

    @Override
    public void started() throws Exception {
        Property changePasswordProp = (Property)this.nanoActionsByName.get("ChangePassword");
        if (changePasswordProp != null && this.get(changePasswordProp) instanceof BNanoStringAction) {
            this.setFlags((Slot)changePasswordProp, 4);
        }
        this.setCpActionVisibility(this.getDisablePasswordChange());
        super.started();
    }

    private void setCpActionVisibility(boolean disablePasswordChange) {
        int cpFlags = this.getFlags((Slot)cp);
        this.setFlags((Slot)cp, disablePasswordChange ? cpFlags | 4 : cpFlags & 0xFFFFFFFB);
    }

    @Override
    public String getDisplayName(Slot slot, Context cx) {
        if (slot.getName().equals("cp")) {
            return "Change Password";
        }
        return super.getDisplayName(slot, cx);
    }

    public void doCp(BComponent userComponent) {
        BValue propVal;
        if (!(userComponent instanceof BNanoUser)) {
            return;
        }
        BNanoUser userBeforeUpdate = (BNanoUser)userComponent.as(BNanoUser.class);
        Property changePasswordProp = (Property)this.nanoActionsByName.get("ChangePassword");
        if (changePasswordProp != null && (propVal = this.get(changePasswordProp)) instanceof BNanoStringAction) {
            BNanoStringAction changePasswordAction = (BNanoStringAction)propVal;
            try {
                String newPwd = this.getPassword().getDecryptedPassword();
                LOGGER.finest("PASSWORD CHANGED in Niagara!!");
                LOGGER.finest("Forwarding password to Nano controller!");
                changePasswordAction.invoke(this, (BValue)BString.make((String)newPwd));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

