/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.nE2Link.security;

import java.util.Objects;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BFacets;
import javax.baja.sys.BStruct;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="minLength", type="int", facets={@Facet(name="BFacets.MIN", value="0")}, defaultValue="8"), @NiagaraProperty(name="minLowerCase", type="int", facets={@Facet(name="BFacets.MIN", value="0")}, defaultValue="1"), @NiagaraProperty(name="minUpperCase", type="int", facets={@Facet(name="BFacets.MIN", value="0")}, defaultValue="1"), @NiagaraProperty(name="minDigits", type="int", facets={@Facet(name="BFacets.MIN", value="0")}, defaultValue="1"), @NiagaraProperty(name="minSpecialChars", type="int", facets={@Facet(name="BFacets.MIN", value="0")}, defaultValue="1"), @NiagaraProperty(name="spacesAllowed", type="boolean", defaultValue="false")})
public class BNanoPasswordStrength
extends BStruct {
    public static final Property minLength = BNanoPasswordStrength.newProperty((int)0, (int)8, (BFacets)BFacets.make((String)"min", (int)0));
    public static final Property minLowerCase = BNanoPasswordStrength.newProperty((int)0, (int)1, (BFacets)BFacets.make((String)"min", (int)0));
    public static final Property minUpperCase = BNanoPasswordStrength.newProperty((int)0, (int)1, (BFacets)BFacets.make((String)"min", (int)0));
    public static final Property minDigits = BNanoPasswordStrength.newProperty((int)0, (int)1, (BFacets)BFacets.make((String)"min", (int)0));
    public static final Property minSpecialChars = BNanoPasswordStrength.newProperty((int)0, (int)1, (BFacets)BFacets.make((String)"min", (int)0));
    public static final Property spacesAllowed = BNanoPasswordStrength.newProperty((int)0, (boolean)false, null);
    public static final Type TYPE = Sys.loadType(BNanoPasswordStrength.class);
    public static final char[] NANO_VALID_SPECIAL_CHARS = "!\"#$%&'()*+,-./:;<=>?@[\\]^_`{|}~".toCharArray();
    public static final BNanoPasswordStrength DEFAULT = new BNanoPasswordStrength(8, 1, 1, 1, 1, false, NANO_VALID_SPECIAL_CHARS);
    public static final BNanoPasswordStrength NANO_DEFAULT = new BNanoPasswordStrength(8, 1, 1, 1, 1, false, NANO_VALID_SPECIAL_CHARS);
    private char[] allowedSpecialChars;

    public int getMinLength() {
        return this.getInt(minLength);
    }

    public void setMinLength(int v) {
        this.setInt(minLength, v, null);
    }

    public int getMinLowerCase() {
        return this.getInt(minLowerCase);
    }

    public void setMinLowerCase(int v) {
        this.setInt(minLowerCase, v, null);
    }

    public int getMinUpperCase() {
        return this.getInt(minUpperCase);
    }

    public void setMinUpperCase(int v) {
        this.setInt(minUpperCase, v, null);
    }

    public int getMinDigits() {
        return this.getInt(minDigits);
    }

    public void setMinDigits(int v) {
        this.setInt(minDigits, v, null);
    }

    public int getMinSpecialChars() {
        return this.getInt(minSpecialChars);
    }

    public void setMinSpecialChars(int v) {
        this.setInt(minSpecialChars, v, null);
    }

    public boolean getSpacesAllowed() {
        return this.getBoolean(spacesAllowed);
    }

    public void setSpacesAllowed(boolean v) {
        this.setBoolean(spacesAllowed, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BNanoPasswordStrength() {
    }

    public BNanoPasswordStrength(int minLength, int minLowerCase, int minUpperCase, int minDigits, int minSpecialChars, boolean spacesAllowed, char[] allowedSpecialChars) {
        this.setMinLength(minLength);
        this.setMinLowerCase(minLowerCase);
        this.setMinUpperCase(minUpperCase);
        this.setMinDigits(minDigits);
        this.setMinSpecialChars(minSpecialChars);
        this.setSpacesAllowed(spacesAllowed);
        this.allowedSpecialChars = allowedSpecialChars;
    }

    public boolean isSpecialCharacter(char characterToCheck) {
        for (char specialChar : this.allowedSpecialChars) {
            if (characterToCheck != specialChar) continue;
            return true;
        }
        return false;
    }

    public char[] getAllowedSpecialChars() {
        return this.allowedSpecialChars;
    }

    public PasswordCheckResults checkPassword(String password) {
        char[] pwdChars;
        int lowerCase = 0;
        int upperCase = 0;
        int digits = 0;
        int specialChars = 0;
        boolean spacesFound = false;
        boolean allCharsValid = true;
        int len = password.length();
        for (char character : pwdChars = password.toCharArray()) {
            if (this.isSpecialCharacter(character)) {
                ++specialChars;
                continue;
            }
            if (Character.isLetter(character)) {
                if (Character.isUpperCase(character)) {
                    ++upperCase;
                    continue;
                }
                ++lowerCase;
                continue;
            }
            if (Character.isDigit(character)) {
                ++digits;
                continue;
            }
            if (character == ' ') {
                spacesFound = true;
                continue;
            }
            allCharsValid = false;
        }
        boolean spacesOK = this.getSpacesAllowed() || !this.getSpacesAllowed() && !spacesFound;
        return new PasswordCheckResults(allCharsValid &= spacesOK, len >= this.getMinLength(), lowerCase >= this.getMinLowerCase(), upperCase >= this.getMinUpperCase(), digits >= this.getMinDigits(), specialChars >= this.getMinSpecialChars(), spacesOK);
    }

    public class PasswordCheckResults {
        private final boolean allCharsValid;
        private final boolean minLengthOK;
        private final boolean minLowerCaseOK;
        private final boolean minUpperCaseOK;
        private final boolean minDigitsOK;
        private final boolean minSpecialCharsOK;
        private final boolean spacesOK;

        PasswordCheckResults(boolean allCharsValid, boolean minLengthOk, boolean minLowerCaseOK, boolean minUpperCaseOK, boolean minDigitsOK, boolean minSpecialCharsOK, boolean spacesOK) {
            this.allCharsValid = allCharsValid;
            this.minLengthOK = minLengthOk;
            this.minLowerCaseOK = minLowerCaseOK;
            this.minUpperCaseOK = minUpperCaseOK;
            this.minDigitsOK = minDigitsOK;
            this.minSpecialCharsOK = minSpecialCharsOK;
            this.spacesOK = spacesOK;
        }

        public boolean allCharactersValid() {
            return this.allCharsValid;
        }

        public boolean isMinLengthOK() {
            return this.minLengthOK;
        }

        public boolean isMinLowerCaseOK() {
            return this.minLowerCaseOK;
        }

        public boolean isMinUpperCaseOK() {
            return this.minUpperCaseOK;
        }

        public boolean isMinDigitsOK() {
            return this.minDigitsOK;
        }

        public boolean isMinSpecialCharsOK() {
            return this.minSpecialCharsOK;
        }

        public boolean isSpacesOK() {
            return this.spacesOK;
        }

        public boolean isAllOk() {
            return this.minDigitsOK && this.minLengthOK && this.minSpecialCharsOK && this.minUpperCaseOK && this.minLowerCaseOK && this.spacesOK && this.allCharsValid;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PasswordCheckResults that = (PasswordCheckResults)o;
            return this.allCharsValid == that.allCharactersValid() && this.minLengthOK == that.minLengthOK && this.minLowerCaseOK == that.minLowerCaseOK && this.minUpperCaseOK == that.minUpperCaseOK && this.minDigitsOK == that.minDigitsOK && this.minSpecialCharsOK == that.minSpecialCharsOK && this.spacesOK == that.spacesOK;
        }

        public int hashCode() {
            return Objects.hash(this.allCharsValid, this.minLengthOK, this.minLowerCaseOK, this.minUpperCaseOK, this.minDigitsOK, this.minSpecialCharsOK, this.spacesOK);
        }

        public String toString() {
            return "PasswordCheckResults{allCharactersValid" + this.allCharsValid + "minLengthOK=" + this.minLengthOK + ", minLowerCaseOK=" + this.minLowerCaseOK + ", minUpperCaseOK=" + this.minUpperCaseOK + ", minNumbersOK=" + this.minDigitsOK + ", minSpecialCharsOK=" + this.minSpecialCharsOK + ", spacesOk=" + this.spacesOK + '}';
        }
    }
}

