/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.nE2Link.security;

import com.ismacontrolli.nE2Link.security.AesUtil;
import com.ismacontrolli.nE2Link.security.CipherInfo;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;

@NiagaraType
public final class BNanoPassword
extends BSimple {
    private final String passphrase;
    private final SecretKey key;
    private final byte[] salt;
    private IvParameterSpec iv;
    private boolean encryptionOK;
    private boolean decryptionOK;
    public static final BNanoPassword DEFAULT = new BNanoPassword("", "Mira-Tech and iSMAControlli have secrets");
    private String encryptedPwd;
    private String decryptedPwd;
    public static final Type TYPE = Sys.loadType(BNanoPassword.class);

    public Type getType() {
        return TYPE;
    }

    public static BNanoPassword make(String clearTextPwd) {
        return BNanoPassword.make(clearTextPwd, "Mira-Tech and iSMAControlli have secrets");
    }

    public static BNanoPassword make(String clearTextPwd, String passphrase) {
        if (clearTextPwd.equals("")) {
            return DEFAULT;
        }
        return new BNanoPassword(clearTextPwd, passphrase);
    }

    public static BNanoPassword makeFromEncrypted(String encryptedPassword, String passphrase) {
        byte[] combinedCipher = AesUtil.decodeFromBase64(encryptedPassword);
        CipherInfo cipherInfo = AesUtil.extractCipherInfo(combinedCipher);
        BNanoPassword newPwd = new BNanoPassword(passphrase, cipherInfo.getIv(), cipherInfo.getSalt());
        newPwd.encryptedPwd = encryptedPassword;
        newPwd.decryptedPwd = newPwd.decrypt(encryptedPassword);
        return newPwd;
    }

    private BNanoPassword() {
        this("Mira-Tech and iSMAControlli have secrets", null, null);
    }

    private BNanoPassword(String passphrase, byte[] iv, byte[] salt) {
        this.passphrase = passphrase;
        this.salt = salt != null && salt.length > 0 ? salt : AesUtil.generateRandomSalt(128);
        this.iv = iv != null && iv.length > 0 ? new IvParameterSpec(iv) : AesUtil.generateIv();
        SecretKey secretKey = null;
        try {
            secretKey = AesUtil.generateKeyFromPassphrase(passphrase, this.salt);
        }
        catch (Exception e) {
            System.out.println("Faild to generate key. Exception is: ");
            e.printStackTrace();
        }
        this.key = secretKey;
    }

    private BNanoPassword(String clearTextPwd, String passphrase) {
        this(passphrase, null, null);
        this.decryptedPwd = clearTextPwd;
        this.decryptionOK = true;
        this.encryptedPwd = this.encrypt(this.decryptedPwd);
    }

    public String getDecryptedPassword() {
        return this.decryptedPwd;
    }

    public String getEncryptedPassword() {
        return this.encryptedPwd;
    }

    public int hashCode() {
        return this.encryptedPwd.hashCode();
    }

    public static boolean equals(BNanoPassword a, BNanoPassword b) {
        if (a.decryptedPwd == null) {
            return b.decryptedPwd == null;
        }
        if (b.decryptedPwd == null) {
            return false;
        }
        return a.equals((Object)b);
    }

    public boolean equals(Object obj) {
        if (obj instanceof BNanoPassword) {
            BNanoPassword that = (BNanoPassword)((Object)obj);
            try {
                return this.getDecryptedPassword().equals(that.getDecryptedPassword());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public String toString(Context context) {
        return this.encryptedPwd;
    }

    public void encode(DataOutput out) throws IOException {
        out.writeUTF(this.encryptedPwd);
    }

    public BObject decode(DataInput in) throws IOException {
        String encryptedPwd = in.readUTF();
        return BNanoPassword.makeFromEncrypted(encryptedPwd, "Mira-Tech and iSMAControlli have secrets");
    }

    public String encodeToString() throws IOException {
        return this.encryptedPwd;
    }

    public BObject decodeFromString(String encryptedPwd) throws IOException {
        return BNanoPassword.makeFromEncrypted(encryptedPwd, "Mira-Tech and iSMAControlli have secrets");
    }

    private String encrypt(String decryptedPwd) {
        byte[] cipherText;
        boolean sucessfullyEncrypted = false;
        try {
            cipherText = AesUtil.encrypt("AES/CBC/PKCS5Padding", decryptedPwd, this.key, this.iv);
            sucessfullyEncrypted = true;
        }
        catch (Exception e) {
            System.out.println("ATTENTION: UNABLE TO ENCRYPT PASSWORD. STORING AS CLEAR TEXT. Exception is below:");
            e.printStackTrace();
            cipherText = this.encryptedPwd.getBytes();
        }
        byte[] combinedCipher = AesUtil.generateCombinedCipher(this.iv.getIV(), this.salt, sucessfullyEncrypted, cipherText);
        this.encryptionOK = sucessfullyEncrypted;
        return AesUtil.encodeToBase64(combinedCipher);
    }

    private String decrypt(String encryptedPwd) {
        if (encryptedPwd == null) {
            return null;
        }
        byte[] combinedCipher = AesUtil.decodeFromBase64(encryptedPwd);
        CipherInfo cipherInfo = AesUtil.extractCipherInfo(combinedCipher);
        String cipherText = null;
        if (cipherInfo.isCipherEncrypted()) {
            try {
                byte[] plainText = AesUtil.decrypt("AES/CBC/PKCS5Padding", cipherInfo.getCipherText(), this.key, this.iv);
                this.decryptionOK = true;
                cipherText = new String(plainText);
            }
            catch (Exception e) {
                this.decryptionOK = false;
                System.out.println("Decoding the encrypted password " + encryptedPwd + " failed. Exception is:");
                e.printStackTrace();
                cipherText = null;
            }
        } else {
            this.decryptionOK = true;
            cipherText = new String(cipherInfo.getCipherText());
        }
        return cipherText;
    }
}

