/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.nE2Link.schedules.utils;

import com.ismacontrolli.nE2Link.schedules.BNanoDateSchedule;
import com.ismacontrolli.nE2Link.schedules.BNanoWeekAndDaySchedule;
import com.ismacontrolli.nE2Link.schedules.utils.BPosixDstWeekEnum;
import java.io.IOException;
import java.time.LocalDate;
import java.util.Objects;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BDate;
import javax.baja.sys.BMonth;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BTime;
import javax.baja.sys.BWeekday;
import javax.baja.sys.Context;
import javax.baja.timezone.BTimeZone;
import javax.baja.timezone.DstRule;
import javax.baja.timezone.TimeZoneDatabase;
import javax.baja.util.Lexicon;

public class ScheduleUtils {
    static int[] oddMonths = new int[]{1, 3, 5, 7, 9, 11};
    static int[] evenMonths = new int[]{2, 4, 6, 8, 10, 12};
    public static String BACNET_PRIORITY = "bacnetPriority";
    private static long NET_TO_UNIX_EPOCH_OFFSET_MILLIS = 62135596800000L;
    public static long NET_TICKS_PER_MILLI = 10000L;
    private static String POSIX_TIME_FORMAT = "%02d:%02d:%02d";
    private static String POSIX_WEEKDAY_RULE_FORMAT = "M%d.%d.%d";

    public static LocalDate getStartDatePattern(BAbsTime after, BNanoDateSchedule start) {
        int weekday = start.getWeekday();
        int day = start.getDay();
        int month = start.getMonth() + 1;
        int year = start.getYear();
        int nextDay = after.getDay();
        int nextMonth = after.getMonth().getOrdinal() + 1;
        int nextYear = after.getYear();
        if (nextYear < year) {
            nextYear = year;
            nextMonth = 1;
            nextDay = 1;
        }
        while (year == -1 || nextYear == year) {
            if (ScheduleUtils.properMonth(nextMonth, month)) {
                int lastDay = ScheduleUtils.getLastDay(nextMonth, nextYear);
                while (nextDay <= lastDay && nextDay != -1) {
                    if (ScheduleUtils.properDay(nextDay, day, lastDay) && ScheduleUtils.properWeekday(nextDay, nextMonth, nextYear, weekday)) {
                        return LocalDate.of(nextYear, nextMonth, nextDay);
                    }
                    nextDay = ScheduleUtils.getNextProperDayInMonth(nextDay, day, ScheduleUtils.getLastDay(nextMonth, nextYear));
                }
            }
            switch (month) {
                case 0: {
                    if (++nextMonth <= 12) break;
                    nextMonth = 1;
                    ++nextYear;
                    break;
                }
                case 13: {
                    nextMonth = nextMonth % 2 == 1 ? (nextMonth += 2) : ++nextMonth;
                    if (nextMonth <= 12) break;
                    nextMonth = 1;
                    ++nextYear;
                    break;
                }
                case 14: {
                    nextMonth = nextMonth % 2 == 0 ? (nextMonth += 2) : ++nextMonth;
                    if (nextMonth <= 12) break;
                    nextMonth = 1;
                    ++nextYear;
                    break;
                }
                default: {
                    if (month > nextMonth) {
                        nextMonth = month;
                        break;
                    }
                    nextMonth = month;
                    ++nextYear;
                }
            }
            nextDay = ScheduleUtils.getNextProperDayInMonth(0, day, ScheduleUtils.getLastDay(nextMonth, nextYear));
        }
        return null;
    }

    private static boolean properWeekday(int day, int month, int year, int type) {
        if (type == -1) {
            return true;
        }
        return LocalDate.of(year, month, day).getDayOfWeek().getValue() % 7 == type;
    }

    private static boolean properDay(int day, int wanted, int lastDayOfMonth) {
        switch (wanted) {
            case -1: {
                return true;
            }
            case 32: {
                return day == lastDayOfMonth;
            }
            case 33: {
                return day % 2 == 1;
            }
            case 34: {
                return day % 2 == 0;
            }
        }
        return day == wanted;
    }

    private static int getNextProperDayInMonth(int day, int wanted, int lastDayOfMonth) {
        switch (wanted) {
            case -1: {
                if (day < lastDayOfMonth) {
                    return day + 1;
                }
                return -1;
            }
            case 32: {
                if (day < lastDayOfMonth) {
                    return lastDayOfMonth;
                }
                return -1;
            }
            case 33: {
                day = day % 2 == 1 ? (day += 2) : ++day;
                if (day <= lastDayOfMonth) {
                    return day;
                }
                return -1;
            }
            case 34: {
                day = day % 2 == 0 ? (day += 2) : ++day;
                if (day <= lastDayOfMonth) {
                    return day;
                }
                return -1;
            }
        }
        if (day != wanted && day < wanted) {
            return wanted;
        }
        return -1;
    }

    private static boolean properMonth(int month, int wanted) {
        switch (wanted) {
            case 0: {
                return true;
            }
            case 13: {
                return month % 2 == 1;
            }
            case 14: {
                return month % 2 == 0;
            }
        }
        return month == wanted;
    }

    public static LocalDate getStartDateWeekAndDay(BAbsTime after, BNanoWeekAndDaySchedule weekAndDaySchedule) {
        int firstDayOfWeekOfMonth;
        int nextYear = after.getYear();
        int nextMonth = after.getMonth().getOrdinal() + 1;
        int nextDay = after.getDay();
        if (nextDay < (firstDayOfWeekOfMonth = ScheduleUtils.getStartDayOfWeekOfMonth(weekAndDaySchedule.getWeek(), ScheduleUtils.getLastDay(nextMonth, nextYear)))) {
            nextDay = firstDayOfWeekOfMonth;
        }
        int lastDayOfWeekOfMonth = ScheduleUtils.getLastDayOfWeekOfMonth(weekAndDaySchedule.getWeek(), ScheduleUtils.getLastDay(nextMonth, nextYear));
        while (true) {
            if (ScheduleUtils.properMonth(nextMonth, weekAndDaySchedule.getMonth() + 1)) {
                while (nextDay <= lastDayOfWeekOfMonth) {
                    if (weekAndDaySchedule.getWeekday() == -1) {
                        return LocalDate.of(nextYear, nextMonth, nextDay);
                    }
                    LocalDate date = LocalDate.of(nextYear, nextMonth, nextDay);
                    if (date.getDayOfWeek().getValue() % 7 == weekAndDaySchedule.getWeekday()) {
                        return LocalDate.of(nextYear, nextMonth, nextDay);
                    }
                    int k = date.getDayOfWeek().getValue();
                    int j = weekAndDaySchedule.getWeekday();
                    nextDay += (7 + j - k) % 7;
                }
            }
            switch (weekAndDaySchedule.getMonth() + 1) {
                case 0: {
                    if (++nextMonth <= 12) break;
                    nextMonth = 1;
                    ++nextYear;
                    break;
                }
                case 13: {
                    nextMonth = nextMonth % 2 == 0 ? ++nextMonth : (nextMonth += 2);
                    if (nextMonth <= 12) break;
                    nextMonth = 1;
                    ++nextYear;
                    break;
                }
                case 14: {
                    nextMonth = nextMonth % 2 == 0 ? (nextMonth += 2) : ++nextMonth;
                    if (nextMonth <= 12) break;
                    nextMonth = 1;
                    ++nextYear;
                    break;
                }
                default: {
                    if (nextMonth >= weekAndDaySchedule.getMonth() + 1) {
                        ++nextYear;
                    }
                    nextMonth = weekAndDaySchedule.getMonth() + 1;
                }
            }
            nextDay = ScheduleUtils.getStartDayOfWeekOfMonth(weekAndDaySchedule.getWeek(), ScheduleUtils.getLastDay(nextMonth, nextYear));
            lastDayOfWeekOfMonth = ScheduleUtils.getLastDayOfWeekOfMonth(weekAndDaySchedule.getWeek(), ScheduleUtils.getLastDay(nextMonth, nextYear));
        }
    }

    public static int getStartDayOfWeekOfMonth(int weekday, int lastDay) {
        int startDayOfMonth = 1;
        if (weekday <= 5) {
            startDayOfMonth = weekday == -1 ? 1 : (weekday - 1) * 7 + 1;
        } else {
            switch (weekday) {
                case 6: {
                    startDayOfMonth = lastDay - 6;
                    break;
                }
                case 7: {
                    startDayOfMonth = lastDay - 13;
                    break;
                }
                case 8: {
                    startDayOfMonth = lastDay - 20;
                    break;
                }
                default: {
                    startDayOfMonth = lastDay - 27;
                }
            }
        }
        return startDayOfMonth;
    }

    public static int getLastDayOfWeekOfMonth(int weekday, int lastDay) {
        int lastDayOfWeek = 1;
        if (-1 < weekday && weekday < 5) {
            lastDayOfWeek = weekday * 7;
        } else {
            switch (weekday) {
                case -1: 
                case 5: 
                case 6: {
                    lastDayOfWeek = lastDay;
                    break;
                }
                case 7: {
                    lastDayOfWeek = lastDay - 7;
                    break;
                }
                case 8: {
                    lastDayOfWeek = lastDay - 14;
                    break;
                }
                case 9: {
                    lastDayOfWeek = lastDay - 21;
                }
            }
        }
        return lastDayOfWeek;
    }

    static boolean isOddMonth(int month) {
        boolean found = false;
        for (int i : oddMonths) {
            if (month != i) continue;
            found = true;
            break;
        }
        return found;
    }

    static boolean isEvenMonth(int month) {
        return !ScheduleUtils.isOddMonth(month);
    }

    public static int getLastDay(int month, int year) {
        if (month < 1) {
            return 30;
        }
        return BAbsTime.getDaysInMonth((int)year, (BMonth)BMonth.make((int)(month - 1)));
    }

    static boolean isLeapYear(int year) {
        return BAbsTime.isLeapYear((int)year);
    }

    public static long unixToDotnetEpochMillis(long unixMillis) {
        return unixMillis + NET_TO_UNIX_EPOCH_OFFSET_MILLIS;
    }

    public static long dotnetToUnixEpochMillis(long dotnetMillis) {
        return dotnetMillis - NET_TO_UNIX_EPOCH_OFFSET_MILLIS;
    }

    public static long niagaraTimeToNanoUtcMillis(BAbsTime niagaraTime) {
        return ScheduleUtils.unixToDotnetEpochMillis(niagaraTime.toUtcTime().getMillis());
    }

    public static long niagaraTimeToNanoUtcTicks(BAbsTime niagaraTime) {
        return ScheduleUtils.niagaraTimeToNanoUtcMillis(niagaraTime) * NET_TICKS_PER_MILLI;
    }

    public static String timeZoneToPosix(BTimeZone timeZone, Context cx) {
        StringBuilder sb = new StringBuilder(ScheduleUtils.makeTimeZoneAbbreviation(timeZone.getShortDisplayName(false, cx)));
        sb.append(ScheduleUtils.offsetMillisToPosix(timeZone.getUtcOffset()));
        if (timeZone.getDaylightStartRule() != null && timeZone.getDaylightEndRule() != null) {
            sb.append(ScheduleUtils.makeTimeZoneAbbreviation(timeZone.getShortDisplayName(true, cx)));
            sb.append(ScheduleUtils.offsetMillisToPosix(timeZone.getUtcOffset() + timeZone.getDaylightAdjustment()));
            String dstRules = ScheduleUtils.dstRulesToPosix(timeZone);
            sb.append(dstRules);
        }
        return sb.toString();
    }

    private static String makeTimeZoneAbbreviation(String shortDisplayName) {
        if (shortDisplayName.contains(":") || shortDisplayName.contains("+") || shortDisplayName.contains("-")) {
            return '<' + shortDisplayName + '>';
        }
        return shortDisplayName;
    }

    private static String offsetMillisToPosix(int offset) {
        BRelTime utcOffsetRel = BRelTime.make((long)offset).abs();
        String utcOffset = String.format(POSIX_TIME_FORMAT, utcOffsetRel.getHoursPart(), utcOffsetRel.getMinutesPart(), utcOffsetRel.getSecondsPart());
        if (offset > 0) {
            utcOffset = '-' + utcOffset;
        }
        return utcOffset;
    }

    private static String timeToPosix(BTime time) {
        if (time == null) {
            return "";
        }
        String timeString = String.format(POSIX_TIME_FORMAT, time.getHour(), time.getMinute(), time.getSecond());
        return timeString;
    }

    private static String dstRulesToPosix(BTimeZone timeZone) {
        DstRule dstEndRule;
        DstRule dstStartRule = timeZone.getDaylightStartRule() != null ? timeZone.getDaylightStartRule().asWallTimeRule(0, timeZone) : null;
        DstRule dstRule = dstEndRule = timeZone.getDaylightEndRule() != null ? timeZone.getDaylightEndRule().asWallTimeRule(1, timeZone) : null;
        if (dstStartRule == null || dstEndRule == null) {
            return "";
        }
        String posixStartRule = ScheduleUtils.dstRuleToPosix(dstStartRule);
        String posixEndRule = ScheduleUtils.dstRuleToPosix(dstEndRule);
        return "," + posixStartRule + ',' + posixEndRule;
    }

    private static String dstRuleToPosix(DstRule dstRule) {
        String dstRuleString = "invalid dstRule";
        try {
            dstRuleString = dstRule.encodeToString();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        int monthOfYear = dstRule.getMonth().getMonthOfYear();
        String posixRule = "";
        switch (dstRule.getDayMode()) {
            case 0: {
                BMonth month = dstRule.getMonth();
                int year = BDate.today().getYear();
                int day = dstRule.getDay();
                BDate dstDate = BDate.make((int)year, (BMonth)month, (int)day);
                int dayOfYear = dstDate.getDayOfYear();
                if (dstDate.isLeapDay()) {
                    posixRule = String.valueOf(dayOfYear - 1);
                    break;
                }
                if (BAbsTime.isLeapYear((int)year) && dstDate.isAfter(BDate.make((int)year, (BMonth)BMonth.february, (int)28))) {
                    posixRule = "J" + String.valueOf(dayOfYear - 1);
                    break;
                }
                posixRule = "J" + String.valueOf(dayOfYear);
                break;
            }
            case -1: 
            case 1: {
                int weekday = dstRule.getWeekday().getOrdinal();
                BPosixDstWeekEnum weekEnum = ScheduleUtils.getWeekdayOccurrance(dstRule);
                posixRule = String.format(POSIX_WEEKDAY_RULE_FORMAT, monthOfYear, weekEnum.getOrdinal(), weekday);
                break;
            }
            default: {
                throw new IllegalStateException("[getDstRuleToPosix]: Unsupported dayMode for " + dstRuleString);
            }
        }
        posixRule = posixRule + '/' + ScheduleUtils.timeToPosix(dstRule.getTime());
        return posixRule;
    }

    private static BPosixDstWeekEnum getWeekdayOccurrance(DstRule dstRule) {
        String dstRuleString = "invalid dstRule";
        try {
            dstRuleString = dstRule.encodeToString();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        int dayMode = dstRule.getDayMode();
        switch (dayMode) {
            case -1: {
                int week = dstRule.getWeek() + 1;
                if (week < 0 || week > 5) {
                    throw new IllegalStateException("[getWeekdayOccurrance]: Unsupported week for " + dstRuleString);
                }
                return BPosixDstWeekEnum.make(week);
            }
            case 1: {
                BDate firstMatchingDate;
                int firstMatchingDay;
                BWeekday dstTargetWeekday = dstRule.getWeekday();
                int day = dstRule.getDay();
                BMonth month = dstRule.getMonth();
                int currentYear = BDate.today().getYear();
                BDate dstDate = BDate.make((int)currentYear, (BMonth)month, (int)day);
                BWeekday dstDateWeekday = dstDate.getWeekday();
                int dayDiff = dstTargetWeekday.getOrdinal() - dstDateWeekday.getOrdinal();
                if (dayDiff < 0) {
                    dayDiff += 7;
                }
                if (1 <= (firstMatchingDay = (firstMatchingDate = dstDate.add(dayDiff)).getDay()) && firstMatchingDay <= 7) {
                    return BPosixDstWeekEnum.first;
                }
                if (8 <= firstMatchingDay && firstMatchingDay <= 14) {
                    return BPosixDstWeekEnum.second;
                }
                if (15 <= firstMatchingDay && firstMatchingDay <= 21) {
                    return BPosixDstWeekEnum.third;
                }
                if (22 <= firstMatchingDay && firstMatchingDay <= 28) {
                    BDate nextMatchingDate = firstMatchingDate.add(7);
                    if (nextMatchingDate.getMonth().equals((Object)firstMatchingDate.getMonth())) {
                        return BPosixDstWeekEnum.fourth;
                    }
                    return BPosixDstWeekEnum.last;
                }
                if (firstMatchingDay <= 28) break;
                return BPosixDstWeekEnum.last;
            }
        }
        throw new IllegalStateException("[getWeekdayOccurrance]: Unsupported day mode for " + dstRuleString);
    }

    public static String[] getNiagaraTimeZoneInfo(Context context, boolean showDebugOutput) throws IOException {
        String[] timeZoneIds = TimeZoneDatabase.getAllSupportedZoneIds();
        if (showDebugOutput) {
            for (String timeZoneId : timeZoneIds) {
                BTimeZone timeZone = TimeZoneDatabase.getTimeZone((String)timeZoneId);
                System.out.println(String.format("-------------------------------------------\ntime zone id: '%s', UTC offset: '%s', Java time zone: '%s', tz-support: '%s',\ndisplayName not in DST: '%s', displayName in DST: '%s'\nshortDisplayName not in DST: '%s', shortDisplayName in DST: '%s'\nDstStartRule: '%s', DstEndRule: : '%s'\nposix Time Zone format: '%s'", timeZoneId, timeZone.getUtcOffset(), timeZone.isJavaTimeZone(), timeZone.tzSupport(), timeZone.getDisplayName(false, context), timeZone.getDisplayName(true, context), timeZone.getShortDisplayName(false, context), timeZone.getShortDisplayName(true, context), timeZone.getDaylightStartRule() != null ? timeZone.getDaylightStartRule().encodeToString() : "no daylight start rule", timeZone.getDaylightEndRule() != null ? timeZone.getDaylightEndRule().encodeToString() : "no daylight end rule", ScheduleUtils.timeZoneToPosix(timeZone, context)));
            }
        }
        return timeZoneIds;
    }

    public static class DateDiff {
        int years;
        int months;
        int days;

        public int getYears() {
            return this.years;
        }

        public int getMonths() {
            return this.months;
        }

        public int getDays() {
            return this.days;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DateDiff dateDiff = (DateDiff)o;
            return this.years == dateDiff.years && this.months == dateDiff.months && this.days == dateDiff.days;
        }

        public int hashCode() {
            return Objects.hash(this.years, this.months, this.days);
        }

        private DateDiff(int years, int months, int days) {
            this.years = years;
            this.months = months;
            this.days = days;
        }

        public static DateDiff make(BAbsTime start, BAbsTime end) {
            int yearDiff = 0;
            int monthDiff = 0;
            int dayDiff = 0;
            BAbsTime startAsUtc = null;
            BAbsTime endAsUtc = null;
            boolean invert = start.isAfter(end);
            if (!invert) {
                startAsUtc = start.toUtcTime();
                endAsUtc = end.toUtcTime();
            } else {
                startAsUtc = end.toUtcTime();
                endAsUtc = start.toUtcTime();
            }
            yearDiff = endAsUtc.getYear() - startAsUtc.getYear();
            monthDiff = endAsUtc.getMonth().getMonthOfYear() - startAsUtc.getMonth().getMonthOfYear();
            if (monthDiff < 0 && yearDiff >= 1) {
                --yearDiff;
                monthDiff += 12;
            }
            if ((dayDiff = endAsUtc.getDay() - startAsUtc.getDay()) < 0 && monthDiff >= 1) {
                int adjustedMonthOrdinal = startAsUtc.getMonth().getOrdinal();
                BMonth adjustedMonth = BMonth.make((int)adjustedMonthOrdinal);
                int adjustedYear = startAsUtc.getYear() + yearDiff + (endAsUtc.getMonth().getOrdinal() + --monthDiff) / 11;
                int daysInMonth = BAbsTime.getDaysInMonth((int)adjustedYear, (BMonth)adjustedMonth);
                dayDiff = daysInMonth - startAsUtc.getDay() + endAsUtc.getDay();
            } else {
                BMonth firstMonth = BMonth.make((int)startAsUtc.getMonth().getOrdinal());
                int firstYear = startAsUtc.getYear() + yearDiff + (endAsUtc.getMonth().getOrdinal() + monthDiff) / 11;
                int firstDayInMonth = BAbsTime.getDaysInMonth((int)firstYear, (BMonth)firstMonth);
                BMonth secondMonth = BMonth.make((int)endAsUtc.getMonth().getOrdinal());
                int secondYear = endAsUtc.getYear() + yearDiff + (endAsUtc.getMonth().getOrdinal() + monthDiff) / 11;
                int secondDayInMonth = BAbsTime.getDaysInMonth((int)secondYear, (BMonth)secondMonth);
                dayDiff = firstDayInMonth - startAsUtc.getDay() + endAsUtc.getDay() - secondDayInMonth;
            }
            if (invert) {
                yearDiff *= -1;
                monthDiff *= -1;
                dayDiff *= -1;
            }
            return new DateDiff(yearDiff, monthDiff, dayDiff);
        }

        public String toString() {
            String yearTag = this.years != 0 ? this.years + " years" : "";
            String monthTag = this.months > 0 ? this.months + " months" : "";
            String dayTag = this.days > 0 ? this.days + " days" : "";
            return yearTag + (!yearTag.isEmpty() ? ", " + monthTag : monthTag) + (!monthTag.isEmpty() ? ", " + dayTag : dayTag);
        }

        public String toString(Context cx) {
            Lexicon lex = Lexicon.make((String)"nE2Link", (Context)cx);
            if (this.years == 0 && this.months == 0 && this.days == 0) {
                return lex.get("ScheduleUtils.today", "Today");
            }
            if (this.years == 0 && this.months == 0 && this.days == 1) {
                return lex.get("ScheduleUtils.tomorrow", "Tomorrow");
            }
            if (this.years < 0 || this.years == 0 && this.months < 0 || this.years == 0 && this.months == 0 && this.days < 0) {
                return lex.get("ScheduleUtils.past", "Past");
            }
            String yearTag = this.years != 0 ? this.years + " " + lex.get("ScheduleUtils.years", "years") : "";
            String monthTag = this.months > 0 ? this.months + " " + lex.get("ScheduleUtils.months", "months") : "";
            String dayTag = this.days > 0 ? this.days + " " + lex.get("ScheduleUtils.days", "days") : "";
            return lex.get("ScheduleUtils.occursIn", "Occurs in") + " " + yearTag + (!yearTag.isEmpty() ? ", " + monthTag : monthTag) + (!monthTag.isEmpty() ? ", " + dayTag : dayTag);
        }
    }
}

