/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.nE2Link.schedules;

import java.time.DayOfWeek;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.schedule.BDailySchedule;
import javax.baja.schedule.BWeekSchedule;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BNanoWeekSchedule
extends BWeekSchedule {
    public static final Type TYPE = Sys.loadType(BNanoWeekSchedule.class);

    public Type getType() {
        return TYPE;
    }

    public static DayOfWeek[] getDaysInOrder(Context cx) {
        DayOfWeek[] ret = new DayOfWeek[7];
        int i = DayOfWeek.MONDAY.getValue();
        for (int j = 0; j < 7; ++j) {
            ret[j] = DayOfWeek.of(i);
            if (++i != 8) continue;
            i = 1;
        }
        return ret;
    }

    public BDailySchedule[] schedulesInOrder(Context cx) {
        BDailySchedule[] ret = new BDailySchedule[7];
        int i = DayOfWeek.MONDAY.getValue();
        for (int j = 0; j < 7; ++j) {
            ret[j] = this.schedule(i);
            if (++i != 7) continue;
            i = 0;
        }
        return ret;
    }

    public final BDailySchedule schedule(int weekday) {
        switch (--weekday) {
            case 0: {
                return this.getMonday();
            }
            case 1: {
                return this.getTuesday();
            }
            case 2: {
                return this.getWednesday();
            }
            case 3: {
                return this.getThursday();
            }
            case 4: {
                return this.getFriday();
            }
            case 5: {
                return this.getSaturday();
            }
        }
        return this.getSunday();
    }
}

