/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.nE2Link.schedules;

import com.ismacontrolli.nE2Link.schedules.utils.ScheduleUtils;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.schedule.BWeekOfMonthSchedule;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BMonth;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;

@NiagaraType
public class BNanoWeekOfMonthSchedule
extends BWeekOfMonthSchedule {
    public static final Type TYPE = Sys.loadType(BNanoWeekOfMonthSchedule.class);

    public Type getType() {
        return TYPE;
    }

    public int weekFromEnd(BAbsTime at) {
        int lastDay = ScheduleUtils.getLastDay(at.getMonth().getMonthOfYear(), at.getYear());
        int diff = lastDay - at.getDay();
        if (diff < 7) {
            return 1;
        }
        if (diff < 14) {
            return 2;
        }
        if (diff < 21) {
            return 3;
        }
        if (diff < 28) {
            return 4;
        }
        return 5;
    }

    public boolean isEffective(BAbsTime at) {
        int wk = BNanoWeekOfMonthSchedule.dayToWeek((int)at.getDay());
        int calWk = this.weekFromEnd(at);
        if (this.isEffective(wk)) {
            return true;
        }
        return this.isEffective(calWk + 5);
    }

    public BAbsTime nextEvent(BAbsTime from) {
        if (!this.isAlwaysEffective() && !this.isNeverEffective()) {
            boolean effective = this.isEffective(from);
            from = BAbsTime.make((int)from.getYear(), (BMonth)from.getMonth(), (int)from.getDay(), (int)0, (int)0, (int)0, (int)0, (BTimeZone)from.getTimeZone());
            while (this.isEffective(from) == effective) {
                from = from.nextDay();
            }
            return from;
        }
        return null;
    }
}

