/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.nE2Link.schedules;

import com.ismacontrolli.ifnetclient.model.scheduleLogic.Month;
import com.ismacontrolli.ifnetclient.model.scheduleLogic.NanoScheduleUtil;
import com.ismacontrolli.ifnetclient.model.scheduleLogic.WeekOfMonth;
import com.ismacontrolli.nE2Link.schedules.BNanoWeekOfMonthSchedule;
import com.ismacontrolli.nE2Link.schedules.ISpecialEvent;
import com.ismacontrolli.nE2Link.schedules.utils.ScheduleUtils;
import java.time.LocalDate;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.schedule.BCompositeSchedule;
import javax.baja.schedule.BEnumSetSchedule;
import javax.baja.schedule.BMonthSchedule;
import javax.baja.schedule.BWeekdaySchedule;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BMonth;
import javax.baja.sys.BValue;
import javax.baja.sys.BWeekday;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="union", type="boolean", flags=0x10000001, defaultValue="false"), @NiagaraProperty(name="months", type="BMonthSchedule", flags=0, defaultValue="(new BMonthSchedule()).initEffectiveWhenEmpty(true).initSingleSelection(true)"), @NiagaraProperty(name="weeksOfMonth", type="BNanoWeekOfMonthSchedule", flags=0, defaultValue="(new BNanoWeekOfMonthSchedule()).initEffectiveWhenEmpty(true).initSingleSelection(true)"), @NiagaraProperty(name="weekdays", type="BWeekdaySchedule", flags=0, defaultValue="(new BWeekdaySchedule()).initEffectiveWhenEmpty(true).initSingleSelection(true)")})
public class BNanoWeekAndDaySchedule
extends BCompositeSchedule
implements ISpecialEvent {
    public static final Property union = BNanoWeekAndDaySchedule.newProperty((int)0x10000001, (boolean)false, null);
    public static final Property months = BNanoWeekAndDaySchedule.newProperty((int)0, (BValue)new BMonthSchedule().initEffectiveWhenEmpty(true).initSingleSelection(true), null);
    public static final Property weeksOfMonth = BNanoWeekAndDaySchedule.newProperty((int)0, (BValue)new BNanoWeekOfMonthSchedule().initEffectiveWhenEmpty(true).initSingleSelection(true), null);
    public static final Property weekdays = BNanoWeekAndDaySchedule.newProperty((int)0, (BValue)new BWeekdaySchedule().initEffectiveWhenEmpty(true).initSingleSelection(true), null);
    public static final Type TYPE = Sys.loadType(BNanoWeekAndDaySchedule.class);
    private static String[] weekOfMonDisplayNames = new String[]{"Any Week", "Days 1-7", "Days 8-14", "Days 15-21", "Days 22-28", "Days after 28th", "1-7 days till end", "8-14 days till end", "15-21 days till end", "22-28 days till end"};

    public boolean getUnion() {
        return this.getBoolean(union);
    }

    public void setUnion(boolean v) {
        this.setBoolean(union, v, null);
    }

    public BMonthSchedule getMonths() {
        return (BMonthSchedule)this.get(months);
    }

    public void setMonths(BMonthSchedule v) {
        this.set(months, (BValue)v, null);
    }

    public BNanoWeekOfMonthSchedule getWeeksOfMonth() {
        return (BNanoWeekOfMonthSchedule)this.get(weeksOfMonth);
    }

    public void setWeeksOfMonth(BNanoWeekOfMonthSchedule v) {
        this.set(weeksOfMonth, (BValue)v, null);
    }

    public BWeekdaySchedule getWeekdays() {
        return (BWeekdaySchedule)this.get(weekdays);
    }

    public void setWeekdays(BWeekdaySchedule v) {
        this.set(weekdays, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BNanoWeekAndDaySchedule() {
    }

    public BNanoWeekAndDaySchedule(int dayOfWeek, WeekOfMonth weekOfMonth, Month startMonthOfYear) {
        if (dayOfWeek >= 0) {
            this.setWeekday(dayOfWeek);
        }
        if (weekOfMonth != null) {
            this.setWeek(weekOfMonth.getValue());
        }
        if (startMonthOfYear != null) {
            this.setMonth(startMonthOfYear.getValue() - 1);
        }
    }

    public void started() {
        try {
            super.started();
            if (this.getMonths().getSlotFacets(this.getMonths().getSlot("set")).getFacet("range") == null) {
                this.getMonths().setFacets(this.getMonths().getSlot("set"), BFacets.make((String)"range", (BIDataValue)BEnumRange.make((String[])NanoScheduleUtil.months)));
            }
            if (this.getWeeksOfMonth().getSlotFacets(this.getWeeksOfMonth().getSlot("set")).getFacet("range") == null) {
                this.getWeeksOfMonth().setFacets(this.getWeeksOfMonth().getSlot("set"), BFacets.make((String)"range", (BIDataValue)BEnumRange.make((String[])NanoScheduleUtil.weeksOfMonth)));
            }
            if (this.getWeekdays().getSlotFacets(this.getWeekdays().getSlot("set")).getFacet("range") == null) {
                this.getWeekdays().setFacets(this.getWeekdays().getSlot("set"), BFacets.make((String)"range", (BIDataValue)BEnumRange.make((String[])NanoScheduleUtil.weekdays)));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public BAbsTime nearestRelevantDay(BAbsTime after) {
        LocalDate localDate = ScheduleUtils.getStartDateWeekAndDay(after, this);
        BAbsTime nextEvent = BAbsTime.make((int)localDate.getYear(), (BMonth)BMonth.make((int)(localDate.getMonthValue() - 1)), (int)localDate.getDayOfMonth());
        return nextEvent;
    }

    public BAbsTime nextEvent(BAbsTime after) {
        BAbsTime nextEvent = this.nearestRelevantDay(after);
        if (nextEvent.equals((Object)after)) {
            nextEvent = super.nextEvent(after);
        }
        return nextEvent;
    }

    public String toString(Context cx) {
        Lexicon l = Lexicon.make(BAbstractSchedule.class);
        boolean criteria = false;
        StringBuffer buf = new StringBuffer("");
        int i = this.getWeekday();
        if (i >= 0) {
            BWeekday w = BWeekday.make((int)i);
            buf.append(w.getDisplayTag(cx));
            criteria = true;
        }
        if ((i = this.getWeek()) >= 0) {
            if (criteria) {
                buf.append(", ");
            }
            buf.append(weekOfMonDisplayNames[i]);
            criteria = true;
        } else if (criteria) {
            buf.append(", ").append(l.get("week.everyWeek"));
        }
        i = this.getMonth();
        if (i >= 0) {
            if (criteria) {
                buf.append(", ");
            }
            if (i == 12) {
                buf.append("Odd Months");
            } else if (i == 13) {
                buf.append("Even Months");
            } else {
                BMonth m = BMonth.make((int)i);
                buf.append(m.getDisplayTag(cx));
            }
            criteria = true;
        } else if (criteria) {
            buf.append(", ").append(l.get("month.everyMonth"));
        }
        if (!criteria) {
            buf.append("Every Day");
        }
        return buf.toString();
    }

    public int getMonth() {
        return this.getField((BEnumSetSchedule)this.getMonths());
    }

    public int getWeek() {
        return this.getField((BEnumSetSchedule)this.getWeeksOfMonth());
    }

    public int getWeekday() {
        return this.getField((BEnumSetSchedule)this.getWeekdays());
    }

    public void setMonth(int val) {
        this.getMonths().clear();
        if (val == -1) {
            this.getMonths().setAlwaysEffective(true);
        } else {
            this.getWeekdays().setAlwaysEffective(false);
            this.getMonths().add(val);
        }
    }

    public void setWeek(int val) {
        this.getWeeksOfMonth().clear();
        if (val == -1) {
            this.getWeeksOfMonth().setAlwaysEffective(true);
        } else {
            this.getWeekdays().setAlwaysEffective(false);
            this.getWeeksOfMonth().add(val);
        }
    }

    public void setWeekday(int val) {
        this.getWeekdays().clear();
        if (val == -1) {
            this.getWeekdays().setAlwaysEffective(true);
        } else {
            this.getWeekdays().setAlwaysEffective(false);
            this.getWeekdays().add(val);
        }
    }

    protected int getField(BEnumSetSchedule sch) {
        if (this.getAlwaysEffective()) {
            return -1;
        }
        return sch.isAlwaysEffective() ? -1 : sch.first();
    }
}

