/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.nE2Link.schedules;

import com.ismacontrolli.nE2Link.schedules.BNanoDateSchedule;
import com.ismacontrolli.nE2Link.schedules.ISpecialEvent;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="start", type="BNanoDateSchedule", defaultValue="new BNanoDateSchedule()"), @NiagaraProperty(name="end", type="BNanoDateSchedule", defaultValue="new BNanoDateSchedule()")})
public class BNanoDateRangeSchedule
extends BAbstractSchedule
implements ISpecialEvent {
    public static final Property start = BNanoDateRangeSchedule.newProperty((int)0, (BValue)new BNanoDateSchedule(), null);
    public static final Property end = BNanoDateRangeSchedule.newProperty((int)0, (BValue)new BNanoDateSchedule(), null);
    public static final Type TYPE = Sys.loadType(BNanoDateRangeSchedule.class);

    public BNanoDateSchedule getStart() {
        return (BNanoDateSchedule)this.get(start);
    }

    public void setStart(BNanoDateSchedule v) {
        this.set(start, (BValue)v, null);
    }

    public BNanoDateSchedule getEnd() {
        return (BNanoDateSchedule)this.get(end);
    }

    public void setEnd(BNanoDateSchedule v) {
        this.set(end, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BNanoDateRangeSchedule() {
    }

    public BNanoDateRangeSchedule(BNanoDateSchedule start, BNanoDateSchedule end) {
        this.setStart(start);
        this.setEnd(end);
    }

    public boolean isEffective(BAbsTime t) {
        if (this.getAlwaysEffective()) {
            return true;
        }
        BNanoDateSchedule start = this.getStart();
        BNanoDateSchedule end = this.getEnd();
        if (start.getMonth() == -1) {
            if (t.getYear() > end.getYear()) {
                return false;
            }
            if (t.getYear() == end.getYear()) {
                if (t.getMonth().getMonthOfYear() > end.getMonth() + 1) {
                    return false;
                }
                return t.getMonth().getMonthOfYear() != end.getMonth() + 1 || t.getDay() <= end.getDay();
            }
            return true;
        }
        if (end.getMonth() == -1) {
            if (t.getYear() < start.getYear()) {
                return false;
            }
            if (t.getYear() == start.getYear()) {
                if (t.getMonth().getMonthOfYear() < start.getMonth() + 1) {
                    return false;
                }
                return t.getMonth().getMonthOfYear() != start.getMonth() + 1 || t.getDay() >= start.getDay();
            }
            return true;
        }
        int strTo = start.compareTo(t);
        int endTo = end.compareTo(t);
        return strTo <= 0 && endTo >= 0;
    }

    public BAbsTime nextEvent(BAbsTime after) {
        BAbsTime startNext = this.getStart().nextEvent(after);
        BAbsTime endNext = this.getEnd().nextEvent(after);
        if (startNext == null) {
            if (endNext == null || endNext.isBefore(after)) {
                return null;
            }
            return after;
        }
        if (endNext == null) {
            return null;
        }
        if (endNext.equals((Object)startNext)) {
            return endNext;
        }
        if (this.toString().split("-")[0].contains("Always")) {
            if (endNext.isBefore(after)) {
                return null;
            }
            return after;
        }
        if (this.toString().split("-")[1].contains("Future")) {
            if (after.isBefore(startNext)) {
                return startNext;
            }
            return after;
        }
        if (startNext.isBefore(endNext)) {
            if (after.isBefore(startNext)) {
                return startNext;
            }
            if (endNext.isBefore(after)) {
                return null;
            }
            return after;
        }
        if (endNext.isBefore(after)) {
            if (startNext.isBefore(after)) {
                return null;
            }
            return startNext;
        }
        return after;
    }

    @Override
    public BAbsTime nearestRelevantDay(BAbsTime after) {
        return this.nextEvent(after);
    }

    public String toString(Context cx) {
        String e;
        String s = this.getStart().toString(cx);
        if (s.equals("Every Day")) {
            s = "Always";
        }
        if ((e = this.getEnd().toString(cx)).equals("Every Day")) {
            e = "Future";
        }
        Lexicon l = Lexicon.make(BAbstractSchedule.class);
        return s + " - " + e;
    }
}

