/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.nE2Link.parser.xml;

import com.ismacontrolli.nE2Link.BLibrary;
import com.ismacontrolli.nE2Link.BNanoApplication;
import com.ismacontrolli.nE2Link.BNanoApplicationContainer;
import com.ismacontrolli.nE2Link.BNanoBaseComponent;
import com.ismacontrolli.nE2Link.BNanoComponent;
import com.ismacontrolli.nE2Link.BNanoContainer;
import com.ismacontrolli.nE2Link.BNanoEquipment;
import com.ismacontrolli.nE2Link.BNanoFolder;
import com.ismacontrolli.nE2Link.BNanoInterfaces;
import com.ismacontrolli.nE2Link.BNanoNetworkContainer;
import com.ismacontrolli.nE2Link.BNanoSpecializedContainer;
import com.ismacontrolli.nE2Link.BNe2DeviceExt;
import com.ismacontrolli.nE2Link.datatypes.BUInt64;
import com.ismacontrolli.nE2Link.parser.xml.BXmlParserSlotInfo;
import com.ismacontrolli.nE2Link.parser.xml.XParserEx;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.baja.naming.BOrd;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.sys.BValue;
import javax.baja.xml.XElem;

public class XmlApplicationParser {
    public static final Logger LOGGER = Logger.getLogger("nE2Link");
    public static final String ELEM_NAME_SCHEMA = "schema";
    public static final String ELEM_NAME_LIBRARIES = "libraries";
    public static final String ELEM_NAME_LIBRARY = "library";
    public static final String ELEM_NAME_COMPONENT = "component";
    public static final String ELEM_NAME_SLOT = "slot";
    public static final String ELEM_NAME_TREE = "tree";
    public static final String ATTRIB_NAME_ID = "id";
    public static final String ATTRIB_NAME_NAME = "name";
    public static final String ATTRIB_NAME_VERSION = "version";
    public static final String ATTRIB_NAME_TYPE_ID = "typeId";
    public static final String ATTRIB_NAME_BASE_NAME = "baseName";
    public static final String ATTRIB_NAME_TYPE = "type";
    public static final String ATTRIB_NAME_MIN = "min";
    public static final String ATTRIB_NAME_MAX = "max";
    public static final String ATTRIB_NAME_NOTATION = "notation";
    public static final String ATTRIB_NAME_RANGE = "range";
    public static final String ATTRIB_NAME_VISIBILITY = "visibility";
    public static final String ATTRIB_NAME_READ_ONLY_DEFAULT = "readOnly";
    public static final String ATTRIB_NAME_NULLABLE_DEFAULT = "nullable";
    public static final String ATTRIB_NAME_IS_HIDDEN = "isHidden";
    public static final String ATTRIB_NAME_IS_READ_ONLY = "isReadOnly";
    public static final String ATTRIB_NAME_IS_NULLABLE = "isNullable";
    public static final String ATTRIB_NAME_IS_PERSISTENT = "isPersistent";
    public static final String ATTRIB_NAME_LINK_SOURCE_COMPONENT = "linkSourceComponent";
    public static final String ATTRIB_NAME_LINK_SOURCE_SLOT = "linkSourceSlot";
    public static final String ATTRIB_NAME_VALUE = "value";
    public static final String ATTRIB_NAME_UNIT = "unit";
    public static final String ATTRIB_NAME_TRUE_TEXT = "trueText";
    public static final String ATTRIB_NAME_FALSE_TEXT = "falseText";
    public static final String ATTRIB_NAME_PERSISTENT_ID = "persistentId";
    public static final String FRAMEWORK_SDK_COMPONENT = "Framework.SDK.Component";
    public static final String FRAMEWORK_CORE_CONTAINER = "Framework.Core.Container";
    public static final String FRAMEWORK_CORE_APPLICATION_CONTAINER = "Framework.Core.ApplicationContainer";
    public static final String LIBRARY_CORE_APPLICATION = "Library.Core.Application";
    public static final String FRAMEWORK_CORE_NETWORK_CONTAINER = "Framework.Core.NetworkContainer";
    public static final String FRAMEWORK_CORE_SPECIALIZED_CONTAINER = "Framework.Core.SpecializedContainer";
    public static final String LIBRARY_CORE_INTERFACES = "Library.Core.Interfaces";
    public static final String LIBRARY_CORE_EQUIPMENT = "Library.Core.Equipment";
    public static final String LIBRARY_CORE_FOLDER = "Library.Core.Folder";

    public static synchronized XElem loadXml(BOrd xmlFileOrd) {
        return XParserEx.loadXml(xmlFileOrd);
    }

    public static BLibrary[] parseLibraries(XElem xmlRoot) {
        ArrayList<BLibrary> libraries = new ArrayList<BLibrary>();
        try {
            XElem[] xmlLibs;
            for (XElem xmlLib : xmlLibs = xmlRoot.elem(ELEM_NAME_SCHEMA).elem(ELEM_NAME_LIBRARIES).elems(ELEM_NAME_LIBRARY)) {
                BLibrary library = XmlApplicationParser.parseLibrary(xmlLib);
                if (library == null) continue;
                libraries.add(library);
            }
        }
        catch (Exception e) {
            LOGGER.severe("NO LIBRARIES IN XML FILE");
        }
        return libraries.toArray(new BLibrary[0]);
    }

    private static BLibrary parseLibrary(XElem xmlLib) {
        if (!xmlLib.name().equals(ELEM_NAME_LIBRARY)) {
            LOGGER.warning("Unexpected tag in parseLibrary\nSkipping Library Creation for " + xmlLib);
            return null;
        }
        Integer id = XParserEx.readIntegerFromXMLAttribute(xmlLib, ATTRIB_NAME_ID);
        String name = XParserEx.readStringFromXMLAttribute(xmlLib, ATTRIB_NAME_NAME);
        String version = XParserEx.readStringFromXMLAttribute(xmlLib, ATTRIB_NAME_VERSION);
        if (id == null || name == null || version == null) {
            LOGGER.warning("One or more attributes missing [" + (id == null ? "id, " : "") + (name == null ? "name, " : "") + (version == null ? ATTRIB_NAME_VERSION : "") + "]\nSkipping Library Creation for " + xmlLib);
            return null;
        }
        return new BLibrary(id, name, version);
    }

    public static BNanoBaseComponent[] parseLibraryComponents(XElem xmlRoot, BLibrary lib) {
        ArrayList<BNanoBaseComponent> components = new ArrayList<BNanoBaseComponent>();
        try {
            XElem[] xmlLibs;
            for (XElem xmlLib : xmlLibs = xmlRoot.elem(ELEM_NAME_SCHEMA).elems(ELEM_NAME_LIBRARY)) {
                XElem[] xmlComponents;
                if (XParserEx.readLongFromXMLAttribute(xmlLib, ATTRIB_NAME_ID) != (long)lib.getId()) continue;
                for (XElem xmlComponent : xmlComponents = xmlLib.elems(ELEM_NAME_COMPONENT)) {
                    BNanoBaseComponent component = XmlApplicationParser.parseLibraryComponent(xmlComponent);
                    if (component == null) continue;
                    components.add(component);
                }
            }
        }
        catch (Exception e) {
            LOGGER.severe("NO COMPONENTS IN LIBRARY '" + (Object)((Object)lib) + "'");
        }
        return components.toArray(new BNanoBaseComponent[0]);
    }

    private static BNanoBaseComponent parseLibraryComponent(XElem xmlComponent) {
        BXmlParserSlotInfo[] componentSlots;
        BNanoBaseComponent component;
        if (!xmlComponent.name().equals(ELEM_NAME_COMPONENT)) {
            LOGGER.warning("Unexpected tag in parseLibraryComponent\nSkipping Component Creation for " + xmlComponent);
            return null;
        }
        Integer typeId = XParserEx.readIntegerFromXMLAttribute(xmlComponent, ATTRIB_NAME_TYPE_ID);
        String name = XParserEx.readStringFromXMLAttribute(xmlComponent, ATTRIB_NAME_NAME);
        String baseName = XParserEx.readStringFromXMLAttribute(xmlComponent, ATTRIB_NAME_BASE_NAME);
        if (typeId == null || name == null || name.length() == 0 || baseName == null) {
            LOGGER.warning("One or more attributes missing or empty [" + (typeId == null ? "typeId, " : "") + (name == null || name.length() == 0 ? "name, " : "") + (baseName == null ? ATTRIB_NAME_BASE_NAME : "") + "]\nSkipping Component Creation for " + xmlComponent);
            return null;
        }
        block4 : switch (baseName) {
            case "Framework.SDK.Component": {
                switch (name) {
                    case "Framework.Core.Container": {
                        component = new BNanoContainer();
                        break block4;
                    }
                    case "Library.Core.Application": {
                        component = new BNanoApplication();
                        break block4;
                    }
                    case "Library.Core.Interfaces": {
                        component = new BNanoInterfaces();
                        break block4;
                    }
                    case "Library.Core.Equipment": {
                        component = new BNanoEquipment();
                        break block4;
                    }
                    case "Library.Core.Folder": {
                        component = new BNanoFolder();
                        break block4;
                    }
                }
                component = new BNanoComponent();
                break;
            }
            case "Framework.Core.Container": {
                switch (name) {
                    case "Framework.Core.ApplicationContainer": {
                        component = new BNanoApplicationContainer();
                        break block4;
                    }
                    case "Framework.Core.NetworkContainer": {
                        component = new BNanoNetworkContainer();
                        break block4;
                    }
                    case "Framework.Core.SpecializedContainer": {
                        component = new BNanoSpecializedContainer();
                        break block4;
                    }
                }
                component = new BNanoContainer();
                break;
            }
            default: {
                component = new BNanoComponent();
            }
        }
        component.setTypeId(typeId);
        component.setIsLibraryComponent(true);
        component.setNanoName(name);
        component.setBaseName(baseName);
        for (BXmlParserSlotInfo componentSlot : componentSlots = XmlApplicationParser.parseSlotInfos(xmlComponent)) {
            componentSlot.createProperty(component);
        }
        return component;
    }

    private static BXmlParserSlotInfo[] parseSlotInfos(XElem xmlComponent) {
        ArrayList<BXmlParserSlotInfo> slotInfos = new ArrayList<BXmlParserSlotInfo>();
        if (!xmlComponent.name().equals(ELEM_NAME_COMPONENT)) {
            LOGGER.warning("Unexpected tag in parseSlotInfos\nSkipping all slot creation for " + xmlComponent);
        } else {
            XElem[] xmlSlots = xmlComponent.elems(ELEM_NAME_SLOT);
            for (int slotIndex = 0; slotIndex < xmlSlots.length; ++slotIndex) {
                XElem xmlSlot = xmlSlots[slotIndex];
                BXmlParserSlotInfo slotInfo = XmlApplicationParser.parseSlotInfo(xmlSlot, slotIndex);
                if (slotInfo == null) continue;
                slotInfos.add(slotInfo);
            }
        }
        return slotInfos.toArray(new BXmlParserSlotInfo[0]);
    }

    private static BXmlParserSlotInfo parseSlotInfo(XElem xmlSlot, int slotIndex) {
        String visibility;
        Boolean isReadOnly;
        if (!xmlSlot.name().equals(ELEM_NAME_SLOT)) {
            LOGGER.warning("Unexpected tag in parseSlotInfo\nSkipping slot creation for " + xmlSlot);
            return null;
        }
        String name = XParserEx.readStringFromXMLAttribute(xmlSlot, ATTRIB_NAME_NAME);
        String type = XParserEx.readStringFromXMLAttribute(xmlSlot, ATTRIB_NAME_TYPE);
        if (name == null || name.length() == 0) {
            LOGGER.warning("Missing attribute [name]\nSkipping slot creation for " + xmlSlot);
            return null;
        }
        if ((type == null || type.length() == 0) && xmlSlot.parent().parent().name().equals(ELEM_NAME_LIBRARY)) {
            LOGGER.warning("Missing attribute [type]\nSkipping slot creation for " + xmlSlot);
            return null;
        }
        BXmlParserSlotInfo slotInfo = new BXmlParserSlotInfo();
        slotInfo.setNanoName(name);
        if (type != null) {
            slotInfo.setNanoType(type);
        }
        slotInfo.setNanoId(slotIndex);
        Boolean readOnlyDefault = XParserEx.readBooleanFromXMLAttribute(xmlSlot, ATTRIB_NAME_READ_ONLY_DEFAULT);
        if (readOnlyDefault != null) {
            slotInfo.setReadOnlyDefault(new BStatusBoolean(readOnlyDefault.booleanValue()));
        }
        if ((isReadOnly = XParserEx.readBooleanFromXMLAttribute(xmlSlot, ATTRIB_NAME_IS_READ_ONLY)) != null) {
            slotInfo.setIsReadOnly(new BStatusBoolean(isReadOnly.booleanValue()));
        }
        slotInfo.setNullableDefault(XParserEx.readBooleanFromXMLAttribute(xmlSlot, ATTRIB_NAME_NULLABLE_DEFAULT, false));
        Boolean isNullable = XParserEx.readBooleanFromXMLAttribute(xmlSlot, ATTRIB_NAME_IS_NULLABLE);
        if (isNullable != null) {
            slotInfo.setIsNullable(new BStatusBoolean(isNullable.booleanValue()));
        }
        switch (visibility = XParserEx.readStringFromXMLAttribute(xmlSlot, ATTRIB_NAME_VISIBILITY, "")) {
            case "everywhere": 
            case "normal": 
            case "nowhere": {
                slotInfo.setVisibility(visibility);
                break;
            }
            default: {
                slotInfo.setVisibility("normal");
            }
        }
        slotInfo.setIsHidden(XParserEx.readBooleanFromXMLAttribute(xmlSlot, ATTRIB_NAME_IS_HIDDEN, false));
        slotInfo.setNotation(XParserEx.readIntegerFromXMLAttribute(xmlSlot, ATTRIB_NAME_NOTATION, 0));
        slotInfo.setNanoRange(XParserEx.readStringFromXMLAttribute(xmlSlot, ATTRIB_NAME_RANGE, ""));
        slotInfo.setTrueText(XParserEx.readStringFromXMLAttribute(xmlSlot, ATTRIB_NAME_TRUE_TEXT, ""));
        slotInfo.setFalseText(XParserEx.readStringFromXMLAttribute(xmlSlot, ATTRIB_NAME_FALSE_TEXT, ""));
        Double min = XParserEx.readDoubleFromXMLAttribute(xmlSlot, ATTRIB_NAME_MIN);
        if (min != null) {
            slotInfo.setMin(new BStatusNumeric(min.doubleValue()));
        } else {
            slotInfo.setMin(new BStatusNumeric(0.0, BStatus.nullStatus));
        }
        Double max = XParserEx.readDoubleFromXMLAttribute(xmlSlot, ATTRIB_NAME_MAX);
        if (max != null) {
            slotInfo.setMax(new BStatusNumeric(max.doubleValue()));
        } else {
            slotInfo.setMax(new BStatusNumeric(0.0, BStatus.nullStatus));
        }
        Double unit = XParserEx.readDoubleFromXMLAttribute(xmlSlot, ATTRIB_NAME_UNIT);
        if (unit != null) {
            slotInfo.setNanoUnitId(new BStatusNumeric(unit.doubleValue()));
        } else {
            slotInfo.setNanoUnitId(new BStatusNumeric(0.0, BStatus.nullStatus));
        }
        slotInfo.setIsPersistent(XParserEx.readBooleanFromXMLAttribute(xmlSlot, ATTRIB_NAME_IS_PERSISTENT, false));
        String value = XParserEx.readStringFromXMLAttribute(xmlSlot, ATTRIB_NAME_VALUE);
        if (value != null) {
            slotInfo.setValue(new BStatusString(value));
        } else {
            slotInfo.setValue(new BStatusString("", BStatus.nullStatus));
        }
        slotInfo.getLinkInfo().setSourceComponentPersistentId(XParserEx.readStringFromXMLAttribute(xmlSlot, ATTRIB_NAME_LINK_SOURCE_COMPONENT, ""));
        slotInfo.getLinkInfo().setSourceSlotName(XParserEx.readStringFromXMLAttribute(xmlSlot, ATTRIB_NAME_LINK_SOURCE_SLOT, ""));
        slotInfo.getLinkInfo().setTargetSlotName(slotInfo.getNanoName());
        return slotInfo;
    }

    public static BNanoBaseComponent[] parseTree(XElem xmlRoot, BNe2DeviceExt controller) {
        ArrayList<BNanoBaseComponent> components = new ArrayList<BNanoBaseComponent>();
        XElem treeRoot = xmlRoot.elem(ELEM_NAME_TREE);
        if (treeRoot == null) {
            LOGGER.severe("Invalid XML File: Missing application tree");
        } else {
            XElem[] xmlComponents = treeRoot.elems(ELEM_NAME_COMPONENT);
            if (xmlComponents.length == 0) {
                LOGGER.warning("Empty application tree");
            } else {
                for (XElem xmlComponent : xmlComponents) {
                    BNanoBaseComponent component = XmlApplicationParser.parseTreeComponent(xmlComponent, controller);
                    if (component == null) continue;
                    components.add(component);
                }
            }
        }
        return components.toArray(new BNanoBaseComponent[0]);
    }

    private static BNanoBaseComponent parseTreeComponent(XElem xmlComponent, BNe2DeviceExt controller) {
        XElem[] xmlChildren;
        BXmlParserSlotInfo[] componentSlots;
        if (!xmlComponent.name().equals(ELEM_NAME_COMPONENT)) {
            LOGGER.warning("Unexpected tag in parseTreeComponent\nSkipping Component Creation for " + xmlComponent);
            return null;
        }
        Integer typeId = XParserEx.readIntegerFromXMLAttribute(xmlComponent, ATTRIB_NAME_TYPE_ID);
        String name = XParserEx.readStringFromXMLAttribute(xmlComponent, ATTRIB_NAME_NAME);
        if (typeId == null || name == null || name.length() == 0) {
            LOGGER.warning("One or more attributes missing or empty [" + (typeId == null ? "typeId, " : "") + (name == null || name.length() == 0 ? "name, " : "") + "]\nSkipping Component Creation for " + xmlComponent);
            return null;
        }
        BNanoBaseComponent component = controller.getLibraries().getLibraryComponentsCache().get(typeId);
        if (component == null) {
            LOGGER.severe("Component with typeId '" + typeId + "' not found in any library]\nSkipping Component Creation for " + xmlComponent);
            return null;
        }
        component = (BNanoBaseComponent)component.newCopy();
        component.setNanoName(name);
        Long persistentId = XParserEx.readLongFromXMLAttribute(xmlComponent, ATTRIB_NAME_PERSISTENT_ID);
        if (persistentId != null) {
            component.setPersistentId(BUInt64.make(String.valueOf(persistentId)));
        }
        for (BXmlParserSlotInfo componentSlot : componentSlots = XmlApplicationParser.parseSlotInfos(xmlComponent)) {
            componentSlot.updateProperty(component);
            if (!componentSlot.isLinkTarget()) continue;
            controller.getXmlLinkCache().put(component, componentSlot.getLinkInfo());
        }
        LOGGER.info("Successfully parsed component '" + xmlComponent + "'   , child of '" + xmlComponent.parent() + "'");
        for (XElem xmlChild : xmlChildren = xmlComponent.elems(ELEM_NAME_COMPONENT)) {
            BNanoBaseComponent childComponent = XmlApplicationParser.parseTreeComponent(xmlChild, controller);
            if (childComponent == null) continue;
            component.add(childComponent.getDefaultPropertyName(), (BValue)childComponent, null);
        }
        return component;
    }
}

