/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.nE2Link.parser.xml;

import com.ismacontrolli.nE2Link.BLinkInfo;
import com.ismacontrolli.nE2Link.BNanoBaseComponent;
import com.ismacontrolli.nE2Link.BNanoBaseNamed;
import com.ismacontrolli.nE2Link.BUnitMap;
import javax.baja.data.BIDataValue;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BDouble;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="nanoId", type="int", defaultValue="0", flags=1), @NiagaraProperty(name="nanoType", type="String", defaultValue="", flags=1), @NiagaraProperty(name="value", type="BStatusString", defaultValue="new BStatusString(\"\", BStatus.nullStatus)", flags=1), @NiagaraProperty(name="visibility", type="String", defaultValue="", flags=1), @NiagaraProperty(name="isHidden", type="boolean", defaultValue="false", flags=1), @NiagaraProperty(name="readOnlyDefault", type="BStatusBoolean", defaultValue="new BStatusBoolean(false, BStatus.ok)", flags=1), @NiagaraProperty(name="isReadOnly", type="BStatusBoolean", defaultValue="new BStatusBoolean(false, BStatus.nullStatus)", flags=1), @NiagaraProperty(name="notation", type="int", defaultValue="0", flags=1), @NiagaraProperty(name="nanoRange", type="String", defaultValue="", flags=1), @NiagaraProperty(name="trueText", type="String", defaultValue="", flags=1), @NiagaraProperty(name="falseText", type="String", defaultValue="", flags=1), @NiagaraProperty(name="nanoUnitId", type="BStatusNumeric", defaultValue="new BStatusNumeric(0, BStatus.nullStatus)", flags=1), @NiagaraProperty(name="min", type="BStatusNumeric", defaultValue="new BStatusNumeric()", flags=1), @NiagaraProperty(name="max", type="BStatusNumeric", defaultValue="new BStatusNumeric(0, BStatus.nullStatus)", flags=1), @NiagaraProperty(name="nullableDefault", type="boolean", defaultValue="false", flags=1), @NiagaraProperty(name="isNullable", type="BStatusBoolean", defaultValue="new BStatusBoolean(false, BStatus.nullStatus)", flags=1), @NiagaraProperty(name="isPersistent", type="boolean", defaultValue="false", flags=1), @NiagaraProperty(name="linkInfo", type="BLinkInfo", defaultValue="new BLinkInfo()")})
public class BXmlParserSlotInfo
extends BNanoBaseNamed {
    public static final Property nanoId = BXmlParserSlotInfo.newProperty((int)1, (int)0, null);
    public static final Property nanoType = BXmlParserSlotInfo.newProperty((int)1, (String)"", null);
    public static final Property value = BXmlParserSlotInfo.newProperty((int)1, (BValue)new BStatusString("", BStatus.nullStatus), null);
    public static final Property visibility = BXmlParserSlotInfo.newProperty((int)1, (String)"", null);
    public static final Property isHidden = BXmlParserSlotInfo.newProperty((int)1, (boolean)false, null);
    public static final Property readOnlyDefault = BXmlParserSlotInfo.newProperty((int)1, (BValue)new BStatusBoolean(false, BStatus.ok), null);
    public static final Property isReadOnly = BXmlParserSlotInfo.newProperty((int)1, (BValue)new BStatusBoolean(false, BStatus.nullStatus), null);
    public static final Property notation = BXmlParserSlotInfo.newProperty((int)1, (int)0, null);
    public static final Property nanoRange = BXmlParserSlotInfo.newProperty((int)1, (String)"", null);
    public static final Property trueText = BXmlParserSlotInfo.newProperty((int)1, (String)"", null);
    public static final Property falseText = BXmlParserSlotInfo.newProperty((int)1, (String)"", null);
    public static final Property nanoUnitId = BXmlParserSlotInfo.newProperty((int)1, (BValue)new BStatusNumeric(0.0, BStatus.nullStatus), null);
    public static final Property min = BXmlParserSlotInfo.newProperty((int)1, (BValue)new BStatusNumeric(), null);
    public static final Property max = BXmlParserSlotInfo.newProperty((int)1, (BValue)new BStatusNumeric(0.0, BStatus.nullStatus), null);
    public static final Property nullableDefault = BXmlParserSlotInfo.newProperty((int)1, (boolean)false, null);
    public static final Property isNullable = BXmlParserSlotInfo.newProperty((int)1, (BValue)new BStatusBoolean(false, BStatus.nullStatus), null);
    public static final Property isPersistent = BXmlParserSlotInfo.newProperty((int)1, (boolean)false, null);
    public static final Property linkInfo = BXmlParserSlotInfo.newProperty((int)0, (BValue)new BLinkInfo(), null);
    public static final Type TYPE = Sys.loadType(BXmlParserSlotInfo.class);
    public static final String VISIBILITY_NOWHERE = "nowhere";
    public static final String VISIBILITY_EVERYWHERE = "everywhere";
    public static final String VISIBILITY_NORMAL = "normal";
    private BEnumRange _cachedRange = null;
    private BUnit _cachedUnit = null;

    public int getNanoId() {
        return this.getInt(nanoId);
    }

    public void setNanoId(int v) {
        this.setInt(nanoId, v, null);
    }

    public String getNanoType() {
        return this.getString(nanoType);
    }

    public void setNanoType(String v) {
        this.setString(nanoType, v, null);
    }

    public BStatusString getValue() {
        return (BStatusString)this.get(value);
    }

    public void setValue(BStatusString v) {
        this.set(value, (BValue)v, null);
    }

    public String getVisibility() {
        return this.getString(visibility);
    }

    public void setVisibility(String v) {
        this.setString(visibility, v, null);
    }

    public boolean getIsHidden() {
        return this.getBoolean(isHidden);
    }

    public void setIsHidden(boolean v) {
        this.setBoolean(isHidden, v, null);
    }

    public BStatusBoolean getReadOnlyDefault() {
        return (BStatusBoolean)this.get(readOnlyDefault);
    }

    public void setReadOnlyDefault(BStatusBoolean v) {
        this.set(readOnlyDefault, (BValue)v, null);
    }

    public BStatusBoolean getIsReadOnly() {
        return (BStatusBoolean)this.get(isReadOnly);
    }

    public void setIsReadOnly(BStatusBoolean v) {
        this.set(isReadOnly, (BValue)v, null);
    }

    public int getNotation() {
        return this.getInt(notation);
    }

    public void setNotation(int v) {
        this.setInt(notation, v, null);
    }

    public String getNanoRange() {
        return this.getString(nanoRange);
    }

    public void setNanoRange(String v) {
        this.setString(nanoRange, v, null);
    }

    public String getTrueText() {
        return this.getString(trueText);
    }

    public void setTrueText(String v) {
        this.setString(trueText, v, null);
    }

    public String getFalseText() {
        return this.getString(falseText);
    }

    public void setFalseText(String v) {
        this.setString(falseText, v, null);
    }

    public BStatusNumeric getNanoUnitId() {
        return (BStatusNumeric)this.get(nanoUnitId);
    }

    public void setNanoUnitId(BStatusNumeric v) {
        this.set(nanoUnitId, (BValue)v, null);
    }

    public BStatusNumeric getMin() {
        return (BStatusNumeric)this.get(min);
    }

    public void setMin(BStatusNumeric v) {
        this.set(min, (BValue)v, null);
    }

    public BStatusNumeric getMax() {
        return (BStatusNumeric)this.get(max);
    }

    public void setMax(BStatusNumeric v) {
        this.set(max, (BValue)v, null);
    }

    public boolean getNullableDefault() {
        return this.getBoolean(nullableDefault);
    }

    public void setNullableDefault(boolean v) {
        this.setBoolean(nullableDefault, v, null);
    }

    public BStatusBoolean getIsNullable() {
        return (BStatusBoolean)this.get(isNullable);
    }

    public void setIsNullable(BStatusBoolean v) {
        this.set(isNullable, (BValue)v, null);
    }

    public boolean getIsPersistent() {
        return this.getBoolean(isPersistent);
    }

    public void setIsPersistent(boolean v) {
        this.setBoolean(isPersistent, v, null);
    }

    public BLinkInfo getLinkInfo() {
        return (BLinkInfo)this.get(linkInfo);
    }

    public void setLinkInfo(BLinkInfo v) {
        this.set(linkInfo, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BXmlParserSlotInfo() {
    }

    public BXmlParserSlotInfo(int slotIndex, String nanoName, String nanoType) {
        this();
        this.setNanoId(slotIndex);
        this.setNanoName(nanoName);
        this.setNanoType(nanoType);
    }

    private boolean hasUnit() {
        return BXmlParserSlotInfo.hasUnit(this.getNanoUnitId());
    }

    private static boolean hasUnit(@NotNull BStatusNumeric nanoUnitId) {
        return !nanoUnitId.getStatus().isNull();
    }

    private BUnit getNiagaraUnit() {
        if (this._cachedUnit != null) {
            return this._cachedUnit;
        }
        this._cachedUnit = BXmlParserSlotInfo.makeUnit(this.getNanoUnitId());
        return this._cachedUnit;
    }

    private static boolean hasRange(@NotNull String nanoRange) {
        return nanoRange.length() > 0;
    }

    private boolean hasRange() {
        return BXmlParserSlotInfo.hasRange(this.getNanoRange());
    }

    public static boolean isBoolean(String nanoType) {
        return "boolean".equalsIgnoreCase(nanoType) || "bool".equalsIgnoreCase(nanoType);
    }

    public boolean isBoolean() {
        return BXmlParserSlotInfo.isBoolean(this.getNanoType());
    }

    public static boolean isDouble(String nanoType) {
        return "double".equalsIgnoreCase(nanoType);
    }

    public boolean isDouble() {
        return BXmlParserSlotInfo.isDouble(this.getNanoType());
    }

    public boolean isEnum() {
        return this.hasRange();
    }

    public static boolean isString(String nanoType) {
        return "string".equalsIgnoreCase(nanoType);
    }

    public boolean isString() {
        return BXmlParserSlotInfo.isString(this.getNanoType());
    }

    private BEnumRange getNiagaraRange() {
        if (this._cachedRange != null) {
            return this._cachedRange;
        }
        if (this.hasRange()) {
            this._cachedRange = BXmlParserSlotInfo.makeRange(this.getNanoRange());
            return this._cachedRange;
        }
        return null;
    }

    private static BEnumRange makeRange(String nanoRangeString) {
        try {
            String[] rangeTags = nanoRangeString.split(",\\s*");
            int[] rangeOrdinals = new int[rangeTags.length];
            int lastOrdinal = 0;
            for (int i = 0; i < rangeTags.length; ++i) {
                String[] tagAndOrdinal = rangeTags[i].split("\\s*=\\s*");
                rangeTags[i] = SlotPath.escape((String)tagAndOrdinal[0]);
                if (tagAndOrdinal.length >= 2) {
                    Integer ordinal = Integer.parseInt(tagAndOrdinal[1]);
                    if (ordinal != null) {
                        lastOrdinal = ordinal;
                    } else {
                        LOGGER.warning("Invalid enum range ordinal in '" + nanoRangeString + "' for tag '" + tagAndOrdinal[0] + "'\nApplying default ordinal '" + lastOrdinal + "'");
                    }
                }
                rangeOrdinals[i] = lastOrdinal++;
            }
            return BEnumRange.make((int[])rangeOrdinals, (String[])rangeTags);
        }
        catch (Exception e) {
            LOGGER.warning("Invalid enum range '" + nanoRangeString + "'\nApplying BEnumRange.NULL '");
            return BEnumRange.NULL;
        }
    }

    private static BFacets makeFacets(@NotNull String nanoType, int nanoId, @NotNull String visibility, boolean nullableDefault, int precision, @NotNull BStatusNumeric min, @NotNull BStatusNumeric max, @Nullable BUnit unit, @Nullable BEnumRange range, @NotNull String falseText, @NotNull String trueText) {
        BFacets facets = BFacets.make((String)"nano_type", (String)nanoType);
        facets = BFacets.make((BFacets)facets, (BFacets)BFacets.make((String)"nano_slotId", (int)nanoId));
        facets = BFacets.make((BFacets)facets, (String)"fieldEditor", (BIDataValue)BString.make((String)"nE2Link:NanoStatusValueFE"));
        facets = BFacets.make((BFacets)facets, (String)"nano_attr_visibility", (BIDataValue)BString.make((String)visibility));
        facets = BFacets.make((BFacets)facets, (String)"allowNull", (BIDataValue)BBoolean.make((boolean)nullableDefault));
        facets = BFacets.make((BFacets)facets, (String)"precision", (BIDataValue)BInteger.make((int)precision));
        if (range != null) {
            facets = BFacets.make((BFacets)facets, (String)"range", (BIDataValue)range);
        }
        if (BXmlParserSlotInfo.isBoolean(nanoType)) {
            if (falseText.length() > 0) {
                facets = BFacets.make((BFacets)facets, (String)"falseText", (BIDataValue)BString.make((String)falseText));
            }
            if (trueText.length() > 0) {
                facets = BFacets.make((BFacets)facets, (String)"trueText", (BIDataValue)BString.make((String)trueText));
            }
        }
        if (unit != null) {
            facets = BFacets.make((BFacets)facets, (String)"units", (BIDataValue)unit);
        }
        if (!min.getStatus().isNull()) {
            facets = BFacets.make((BFacets)facets, (String)"min", (BIDataValue)BDouble.make((double)min.getValue()));
        }
        if (!max.getStatus().isNull()) {
            facets = BFacets.make((BFacets)facets, (String)"max", (BIDataValue)BDouble.make((double)max.getValue()));
        }
        return facets;
    }

    private static BFacets makeFacets(BFacets initialFacets, boolean isPersistent, BStatusBoolean isNullable) {
        if (!isNullable.getStatus().isNull()) {
            initialFacets = BFacets.make((BFacets)initialFacets, (String)"allowNull", (BIDataValue)BBoolean.make((boolean)isNullable.getValue()));
        }
        initialFacets = BFacets.make((BFacets)initialFacets, (String)"isPersistent", (BIDataValue)BBoolean.make((boolean)isPersistent));
        return initialFacets;
    }

    private static int makeFlags(int initialFlags, BFacets facets, boolean isHidden, BStatusBoolean isReadOnly) {
        String visibility = facets.gets("nano_attr_visibility", VISIBILITY_NORMAL);
        return BXmlParserSlotInfo.makeFlags(initialFlags, visibility, isHidden, isReadOnly);
    }

    private static int makeFlags(int initialFlags, String visibility, boolean isHidden, BStatusBoolean isReadOnly) {
        switch (visibility) {
            case "nowhere": {
                initialFlags = Flags.add((int)initialFlags, (int[])new int[]{4});
                initialFlags = Flags.remove((int)initialFlags, (int[])new int[]{8});
                break;
            }
            case "everywhere": {
                initialFlags = isHidden ? Flags.add((int)initialFlags, (int[])new int[]{4}) : Flags.remove((int)initialFlags, (int[])new int[]{4});
                initialFlags = Flags.add((int)initialFlags, (int[])new int[]{8});
                break;
            }
            case "normal": {
                initialFlags = Flags.remove((int)initialFlags, (int[])new int[]{8});
                int n = initialFlags = isHidden ? Flags.add((int)initialFlags, (int[])new int[]{4}) : Flags.remove((int)initialFlags, (int[])new int[]{4});
            }
        }
        if (!isReadOnly.getStatus().isNull()) {
            initialFlags = isReadOnly.getValue() ? Flags.add((int)initialFlags, (int[])new int[]{1}) : Flags.remove((int)initialFlags, (int[])new int[]{1});
        }
        return initialFlags;
    }

    private static BUnit makeUnit(@NotNull BStatusNumeric nanoUnitId) {
        if (BXmlParserSlotInfo.hasUnit(nanoUnitId)) {
            return BUnitMap.getNiagaraUnit((int)nanoUnitId.getValue());
        }
        return null;
    }

    private static void setPropertyValue(BNanoBaseComponent component, Slot slot, String stringValue) {
        if (!slot.isProperty()) {
            return;
        }
        boolean success = true;
        Property targetProp = slot.asProperty();
        BNanoBaseComponent targetComponent = component;
        switch (targetProp.getTypeAccess()) {
            case 0: {
                Boolean booleanValue = new Boolean(stringValue);
                if (booleanValue != null) {
                    targetComponent.setBoolean(targetProp, booleanValue);
                    break;
                }
                success = false;
                break;
            }
            case 5: {
                Double doubleValue = new Double(stringValue);
                if (doubleValue != null) {
                    targetComponent.setDouble(targetProp, doubleValue);
                    break;
                }
                success = false;
                break;
            }
            case 4: {
                Float floatValue = new Float(stringValue);
                if (floatValue != null) {
                    targetComponent.setFloat(targetProp, floatValue.floatValue());
                    break;
                }
                success = false;
                break;
            }
            case 2: {
                Integer intValue = new Integer(stringValue);
                if (intValue != null) {
                    targetComponent.setInt(targetProp, intValue);
                    break;
                }
                success = false;
                break;
            }
            case 3: {
                Long longValue = new Long(stringValue);
                if (longValue != null) {
                    targetComponent.setFloat(targetProp, longValue.longValue());
                    break;
                }
                success = false;
                break;
            }
            case 6: {
                if (stringValue != null) {
                    targetComponent.setString(targetProp, stringValue);
                    break;
                }
                success = false;
                break;
            }
            case 7: {
                if (targetProp.getType().is(BStatusNumeric.TYPE)) {
                    Double doubleValue = new Double(stringValue);
                    if (doubleValue != null) {
                        targetComponent.set(targetProp, (BValue)new BStatusNumeric(doubleValue.doubleValue()));
                        break;
                    }
                    success = false;
                    break;
                }
                if (targetProp.getType().is(BStatusEnum.TYPE)) {
                    Integer intValue = new Integer(stringValue);
                    if (intValue != null) {
                        targetComponent.set(targetProp, (BValue)new BStatusEnum((BEnum)BDynamicEnum.make((int)intValue)));
                        break;
                    }
                    success = false;
                    break;
                }
                if (targetProp.getType().is(BStatusBoolean.TYPE)) {
                    Boolean booleanValue = new Boolean(stringValue);
                    if (booleanValue != null) {
                        targetComponent.set(targetProp, (BValue)new BStatusBoolean(booleanValue.booleanValue()));
                        break;
                    }
                    success = false;
                    break;
                }
                if (!targetProp.getType().is(BStatusString.TYPE)) break;
                if (stringValue != null) {
                    targetComponent.set(targetProp, (BValue)new BStatusString(stringValue));
                    break;
                }
                success = false;
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value type: " + targetProp.getType() + " (" + targetProp.getTypeAccess() + ")");
            }
        }
        if (!success) {
            LOGGER.severe("Cannot set value '" + stringValue + "' for '" + (Object)((Object)component) + "." + slot.getName() + " [" + slot.asProperty().getType().getTypeClass() + "]'.");
        }
    }

    private int getNiagaraDefaultFlags() {
        int flagBits = BXmlParserSlotInfo.makeFlags(0, this.getVisibility(), false, this.getReadOnlyDefault());
        return flagBits;
    }

    private BFacets getNiagaraDefaultFacets() {
        return BXmlParserSlotInfo.makeFacets(this.getNanoType(), this.getNanoId(), this.getVisibility(), this.getNullableDefault(), this.getNotation(), this.getMin(), this.getMax(), this.getNiagaraUnit(), this.getNiagaraRange(), this.getFalseText(), this.getTrueText());
    }

    private BValue getNiagaraDefaultValue() {
        if (this.isBoolean()) {
            if (this.getNullableDefault()) {
                return new BStatusBoolean(false, BStatus.nullStatus);
            }
            return new BStatusBoolean(false);
        }
        if (this.isDouble()) {
            if (this.isEnum()) {
                if (this.getNullableDefault()) {
                    return new BStatusEnum((BEnum)BDynamicEnum.make((BEnumRange)this.getNiagaraRange()), BStatus.nullStatus);
                }
                return new BStatusEnum((BEnum)BDynamicEnum.make((BEnumRange)this.getNiagaraRange()));
            }
            if (this.getNullableDefault()) {
                return new BStatusNumeric(0.0, BStatus.nullStatus);
            }
            return new BStatusNumeric(0.0);
        }
        if (this.isString()) {
            if (this.getNullableDefault()) {
                return new BStatusString("", BStatus.nullStatus);
            }
            return new BStatusString("");
        }
        if ("String".equals(this.getNanoType())) {
            return new BStatusString("");
        }
        return null;
    }

    public boolean isLinkTarget() {
        return this.getLinkInfo().isLinkInfoComplete();
    }

    public Property createProperty(BNanoBaseComponent targetComponent) {
        String slotName = this.getDefaultPropertyName();
        if (slotName == null || !SlotPath.isValidName((String)slotName)) {
            LOGGER.severe("Could not add slot with name '" + slotName + "' to component '" + (Object)((Object)targetComponent) + "'\nInvalid Slotname");
            return null;
        }
        if (targetComponent.getSlot(slotName) != null) {
            LOGGER.severe("Could not add slot with name '" + slotName + "' to component '" + (Object)((Object)targetComponent) + "'\nSlot already present");
            return null;
        }
        BValue value = this.getNiagaraDefaultValue();
        if (value == null) {
            LOGGER.severe("Could not add slot with name '" + slotName + "' to component '" + (Object)((Object)targetComponent) + "'\nDefault value is null. Unknown Slot type.");
            return null;
        }
        return targetComponent.add(slotName, value, this.getNiagaraDefaultFlags(), this.getNiagaraDefaultFacets(), null);
    }

    public void updateProperty(BNanoBaseComponent targetComponent) {
        String slotName = this.getDefaultPropertyName();
        if (slotName == null || !SlotPath.isValidName((String)slotName)) {
            LOGGER.warning("Could not find slot with name '" + slotName + "' on component '" + (Object)((Object)targetComponent) + "'\nInvalid Slotname. Skipping slot update.");
            return;
        }
        if (targetComponent == null) {
            LOGGER.warning("Target component is null.\nCannot perform slot update for slot '" + slotName + "'");
            return;
        }
        Slot targetSlot = targetComponent.getSlot(slotName);
        if (targetSlot == null) {
            LOGGER.warning("Could not find slot with name '" + slotName + "' on component '" + (Object)((Object)targetComponent) + "'\nSkipping slot update");
            return;
        }
        if (!targetComponent.isNanoSlot(targetSlot)) {
            LOGGER.warning("Slot with name '" + slotName + "' on component '" + (Object)((Object)targetComponent) + "' is not a NANO slot.\nSkipping slot update");
            return;
        }
        BFacets facets = targetComponent.getSlotFacets(targetSlot);
        int flags = BXmlParserSlotInfo.makeFlags(targetComponent.getFlags(targetSlot), facets, this.getIsHidden(), this.getIsReadOnly());
        targetComponent.setFlags(targetSlot, flags);
        facets = BXmlParserSlotInfo.makeFacets(facets, this.getIsPersistent(), this.getIsNullable());
        targetComponent.setFacets(targetSlot, facets);
        if (!this.getValue().getStatus().isNull()) {
            BXmlParserSlotInfo.setPropertyValue(targetComponent, targetSlot, this.getValue().getValue());
        }
    }
}

