/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.nE2Link.parser.binary;

import com.ismacontrolli.nE2Link.BNanoBaseComponent;
import com.ismacontrolli.nE2Link.parser.binary.AbstractNanoData;
import com.ismacontrolli.nE2Link.parser.binary.AbstractNanoRequest;
import com.ismacontrolli.nE2Link.parser.binary.AbstractNanoResponse;
import com.ismacontrolli.nE2Link.parser.binary.ObjectIdsData;
import com.ismacontrolli.nE2Link.parser.binary.ResponseCode;
import com.ismacontrolli.serialization.DataMarker;
import com.ismacontrolli.serialization.SerializableForm;
import java.util.ArrayList;
import java.util.List;

public class UnsubscribeResponse
extends AbstractNanoResponse {
    private final List<BNanoBaseComponent> successfullyUnsubscribed = new ArrayList<BNanoBaseComponent>();

    private UnsubscribeResponse(AbstractNanoRequest request, ResponseCode responseCode) {
        super(request, responseCode);
    }

    private UnsubscribeResponse(AbstractNanoRequest request, List<SerializableForm> response) {
        super(request, response);
    }

    public static UnsubscribeResponse make(AbstractNanoRequest request, ResponseCode responseCode) {
        return new UnsubscribeResponse(request, responseCode);
    }

    public static UnsubscribeResponse parse(AbstractNanoRequest request, List<SerializableForm> response) {
        return new UnsubscribeResponse(request, response);
    }

    @Override
    public ObjectIdsData getResponseData() {
        return (ObjectIdsData)super.getResponseData();
    }

    public List<BNanoBaseComponent> getSuccessfullyUnsubscribedComponents() {
        return this.successfullyUnsubscribed;
    }

    @Override
    protected boolean isMalformedResponse(SerializableForm responseContentElement) {
        return !responseContentElement.marker.equals((Object)DataMarker.ObjectIdsData);
    }

    @Override
    protected AbstractNanoData doParseResponseContentElement(SerializableForm responseContentElement) {
        return ObjectIdsData.parse(responseContentElement);
    }

    @Override
    public String getLocalizedMessage(int index) {
        StringBuilder sb = new StringBuilder();
        if (this.getResponseData() == null || this.getResponseData().getGlobalIds().length == 0) {
            sb.append(LEX.getText("NONE"));
        } else {
            int[] unsubscribedComponentIds;
            for (int unsubscribedComponentId : unsubscribedComponentIds = this.getResponseData().getGlobalIds()) {
                BNanoBaseComponent unsubscribedComponent = this.getRequest().getNe2DeviceExt().getComponentCache().get(unsubscribedComponentId);
                this.successfullyUnsubscribed.add(unsubscribedComponent);
                String unsubscribedComponentNavOrd = unsubscribedComponent != null ? unsubscribedComponent.getNavOrd().toString() : "unresolvable component";
                sb.append(LEX.getText("UNSUBSCRIBE_LIST_ENTRY", new Object[]{unsubscribedComponentId, unsubscribedComponentNavOrd})).append('\n');
            }
        }
        switch (this.getResponseCode()) {
            case OK: {
                return LEX.getText("UNSUBSCRIBE_OK", new Object[]{sb.toString()});
            }
            case ERROR: {
                return LEX.getText("UNSUBSCRIBE_ERROR", new Object[]{this.getErrorMessage(), this.getExceptionMessage(), this.getStackTrace(), sb.toString()});
            }
            case NOT_CONNECTED: {
                return LEX.getText("UNSUBSCRIBE_NOT_CONNECTED", new Object[]{sb.toString()});
            }
            case NO_RESPONSE: {
                return LEX.getText("UNSUBSCRIBE_NO_RESPONSE");
            }
            case INVALID_RESPONSE: {
                return LEX.getText("UNSUBSCRIBE_INVALID_RESPONSE", new Object[]{sb.toString()});
            }
        }
        return LEX.getText("ILLEGAL_RESPONSE_CODE");
    }
}

