/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.nE2Link.parser.binary;

import com.ismacontrolli.ifnetclient.model.RemoteDevice;
import com.ismacontrolli.nE2Link.BNanoBaseComponent;
import com.ismacontrolli.nE2Link.BNe2DeviceExt;
import com.ismacontrolli.nE2Link.actions.BNanoLinkInfoArg;
import com.ismacontrolli.nE2Link.parser.binary.AbstractNanoRequest;
import com.ismacontrolli.nE2Link.parser.binary.ExtinctLinkData;
import com.ismacontrolli.nE2Link.parser.binary.ResponseCode;
import com.ismacontrolli.nE2Link.parser.binary.UnlinkResponse;
import com.ismacontrolli.serialization.SerializableForm;
import java.util.ArrayList;
import javax.baja.sys.Property;

public class UnlinkRequest
extends AbstractNanoRequest {
    private UnlinkRequest(BNe2DeviceExt ne2DeviceExt, BNanoLinkInfoArg clientRequestData, ExtinctLinkData requestData) {
        super(ne2DeviceExt, (Object)clientRequestData, requestData);
    }

    public static UnlinkRequest make(BNe2DeviceExt ne2DeviceExt, BNanoLinkInfoArg addLinkArg) {
        return new UnlinkRequest(ne2DeviceExt, addLinkArg, ExtinctLinkData.make(addLinkArg));
    }

    @Override
    public UnlinkResponse postRequest(RemoteDevice remoteDevice) {
        if (remoteDevice == null || !remoteDevice.Remote.isConnected()) {
            return UnlinkResponse.make(this, ResponseCode.NOT_CONNECTED);
        }
        ArrayList<SerializableForm> response = remoteDevice.Remote.Unlink(this.getRequestData().getSerializableForm());
        if (response == null) {
            return UnlinkResponse.make(this, ResponseCode.NO_RESPONSE);
        }
        if (this.isResponseMalformed(response)) {
            return UnlinkResponse.make(this, ResponseCode.INVALID_RESPONSE);
        }
        return UnlinkResponse.parse(this, response);
    }

    @Override
    public ExtinctLinkData getRequestData() {
        return (ExtinctLinkData)super.getRequestData();
    }

    public BNanoLinkInfoArg getClientRequestData() {
        return (BNanoLinkInfoArg)((Object)super.getClientRequestData());
    }

    @Override
    public String getLocalizedMessage() {
        BNanoLinkInfoArg requestData = this.getClientRequestData();
        int sourceComponentId = requestData.getSourceComponentGlobalIndex();
        int sourceSlotId = requestData.getSourceSlotId();
        int targetComponentId = requestData.getTargetComponentGlobalIndex();
        int targetSlotId = requestData.getTargetSlotId();
        BNanoBaseComponent sourceComponent = this.getNe2DeviceExt().getComponentCache().get(sourceComponentId);
        BNanoBaseComponent targetComponent = this.getNe2DeviceExt().getComponentCache().get(targetComponentId);
        String sourceComponentNavOrd = sourceComponent != null ? sourceComponent.getNavOrd().toString() : "unresolvable component";
        String targetComponentNavOrd = targetComponent != null ? targetComponent.getNavOrd().toString() : "unresolvable component";
        Property sourceSlot = sourceComponent != null ? sourceComponent.getNanoSlot(sourceSlotId) : null;
        Property targetSlot = targetComponent != null ? targetComponent.getNanoSlot(targetSlotId) : null;
        String sourceSlotName = sourceSlot != null ? sourceSlot.getName() : "unknown source slot";
        String targetSlotName = targetSlot != null ? targetSlot.getName() : "unknown target slot";
        return LEX.getText("UNLINK_REQUEST", new Object[]{sourceComponentId, sourceSlotId, sourceComponentNavOrd + "/" + sourceSlotName, targetComponentId, targetSlotId, targetComponentNavOrd + "/" + targetSlotName});
    }
}

