/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.nE2Link.parser.binary;

import com.ismacontrolli.nE2Link.datatypes.BInt64;
import com.ismacontrolli.nE2Link.parser.binary.AbstractNanoData;
import com.ismacontrolli.nE2Link.trends.BTrendRemovingArgs;
import com.ismacontrolli.serialization.DataMarker;
import com.ismacontrolli.serialization.SerializableForm;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;

public class TrendRemovingData
extends AbstractNanoData {
    private TrendRemovingData(SerializableForm serializableForm) {
        super(serializableForm);
    }

    public static TrendRemovingData make(BTrendRemovingArgs trendRemovingArgs) {
        SerializableForm serializableForm = new SerializableForm(DataMarker.TrendRemoving, new Object[]{trendRemovingArgs.getGuid(), trendRemovingArgs.getStartedStampRemoving() == -1L ? BInt64.make(String.valueOf(-1)) : TrendRemovingData.unixToDotnetEpochMillis(trendRemovingArgs.getStartedStampRemoving())}, null);
        return new TrendRemovingData(serializableForm);
    }

    private static BInt64 unixToDotnetEpochMillis(long unixMillis) {
        LocalDateTime ldt = Instant.ofEpochMilli(unixMillis).atZone(ZoneId.systemDefault()).toLocalDateTime();
        LocalDateTime uldt = LocalDateTime.of(1970, 1, 1, 0, 0, 0).atZone(ZoneId.of("UTC")).toLocalDateTime();
        Duration d = Duration.between(uldt, ldt);
        return BInt64.make(String.valueOf(d.toMillis() * 1000000L));
    }
}

