/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.nE2Link.parser.binary;

import com.ismacontrolli.ifnetclient.model.scheduleLogic.DaysFromCalendar;
import com.ismacontrolli.ifnetclient.model.scheduleLogic.ISchedule;
import com.ismacontrolli.nE2Link.BNanoBaseComponent;
import com.ismacontrolli.nE2Link.BNe2DeviceExt;
import com.ismacontrolli.nE2Link.datatypes.BUInt64;
import com.ismacontrolli.nE2Link.parser.binary.AbstractNanoData;
import com.ismacontrolli.nE2Link.parser.binary.ObjectData;
import com.ismacontrolli.nE2Link.schedules.BNanoSchedule;
import com.ismacontrolli.serialization.DataMarker;
import com.ismacontrolli.serialization.SerializableForm;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.baja.naming.BOrd;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.schedule.BDailySchedule;
import javax.baja.schedule.BScheduleReference;
import javax.baja.sys.BComplex;
import javax.baja.sys.Context;
import javax.baja.sys.Property;

public class TreeData
extends AbstractNanoData {
    private int globalIndex = -1;
    private List<ObjectData> nanoObjects = new ArrayList<ObjectData>();

    protected TreeData(SerializableForm serializableForm) {
        super(serializableForm);
    }

    public int getGlobalIndex() {
        return this.globalIndex;
    }

    public static TreeData parse(SerializableForm serializedTreeData, BNe2DeviceExt controller) {
        TreeData treeData = new TreeData(serializedTreeData);
        treeData.globalIndex = Short.toUnsignedInt((Short)serializedTreeData.data[0]);
        for (SerializableForm serializedElement : serializedTreeData.elements.toSerializableForms()) {
            if (serializedElement.marker == DataMarker.ObjectData) {
                ObjectData nanoObject = ObjectData.parse(serializedElement, controller);
                treeData.nanoObjects.add(nanoObject);
                continue;
            }
            LOGGER.severe(String.format("[TreeData.parse] Unknown marker type. Expected %s, received, %s", new Object[]{DataMarker.ObjectData, serializedElement.marker}));
            return null;
        }
        return treeData;
    }

    public void updateNiagaraTree(BNe2DeviceExt controller) {
        BNanoBaseComponent rootComponent = controller.getComponentCache().get(this.globalIndex);
        LOGGER.info(String.format("[TreeData.parse] component: %s global index %d", rootComponent.getNanoName(), rootComponent.getGlobalIndex()));
        this.nanoObjects.stream().filter(nanoObject -> controller.getComponentCache().get(nanoObject.getGlobalIndex()) == null || controller.getComponentCache().get(nanoObject.getGlobalIndex()).getParentGlobalIndex() != nanoObject.getParentGlobalIndex()).forEach(nanoObject -> {
            nanoObject.createNiagaraComponent(controller);
            LOGGER.fine(String.format("[TreeData.updateNiagaraTree]: Other tool changed Niagara tree. Added component %s", nanoObject.getNanoName()));
        });
        Set existingNanoIds = this.nanoObjects.stream().mapToInt(ObjectData::getGlobalIndex).boxed().collect(Collectors.toSet());
        Arrays.stream(rootComponent.getDescendants(BNanoBaseComponent.class, false, false)).filter(niagaraChild -> !existingNanoIds.contains(niagaraChild.getGlobalIndex())).forEach(niagaraChild -> {
            BNanoBaseComponent parent = (BNanoBaseComponent)niagaraChild.getParent();
            parent.remove((BComplex)niagaraChild);
            if (rootComponent.getGlobalIndex() == controller.getComponentCache().get(niagaraChild.getGlobalIndex()).getParentGlobalIndex()) {
                controller.getComponentCache().remove(niagaraChild.getGlobalIndex());
                LOGGER.fine(String.format("[TreeData.updateNiagaraTree]: Other tool changed Niagara tree. Removed component %s", niagaraChild.getNanoName()));
            }
        });
        HashMap<Integer, BNanoBaseComponent> cacheComponents = controller.getComponentCache().getAllComponents();
        Arrays.stream(rootComponent.getDescendants(BNanoBaseComponent.class, false, false)).filter(niagaraChild -> niagaraChild.getOriginNameFromLibrary().equals("Library.Schedules.Calendar")).forEach(calendar -> {
            LOGGER.fine(String.format("The Calendar %s changed, need to update schedules referring to it", calendar.getNanoName()));
            cacheComponents.values().forEach(c -> {
                if (c.getOriginNameFromLibrary().startsWith("Library.Schedules.") && c.getOriginNameFromLibrary().endsWith("Schedule")) {
                    try {
                        BNanoSchedule nanoSchedule = (BNanoSchedule)c.get("NanoWeeklySchedule");
                        List<ISchedule> specialEventsList = nanoSchedule.getSpecialEventsList();
                        for (ISchedule specialEvent : specialEventsList) {
                            BUInt64 persistentId;
                            if (!(specialEvent instanceof DaysFromCalendar) || (persistentId = ((DaysFromCalendar)specialEvent).getCalendarPersistentId()).equals("0") || !persistentId.equals(calendar.getPersistentId())) continue;
                            BOrd refOrd = BOrd.make((String)(calendar.getSlotPathOrd().toString() + "/NanoCalendar"));
                            BAbstractSchedule event = ((BDailySchedule)nanoSchedule.getSpecialEvents().get(specialEvent.getScheduleName())).getDays();
                            ((BScheduleReference)event).setRef(refOrd);
                        }
                    }
                    catch (Exception e) {
                        LOGGER.severe(String.format("[TreeData.updateNiagaraTree]: not able to update the schedule %s", c.getNanoName()));
                    }
                }
            });
        });
        rootComponent.loadSlots();
        if (rootComponent.isReorderSupported()) {
            ArrayList<Property> dynProps = new ArrayList<Property>();
            for (Property dynProp : rootComponent.getDynamicPropertiesArray()) {
                if (dynProp.getType().getInstance() instanceof BNanoBaseComponent) continue;
                dynProps.add(dynProp);
            }
            for (ObjectData obj : this.nanoObjects) {
                Property dynProp = rootComponent.getProperty(controller.getComponentCache().get(obj.getGlobalIndex()).getNanoName());
                if (null == dynProp || dynProps.contains(dynProp)) continue;
                dynProps.add(dynProp);
            }
            try {
                rootComponent.reorder(dynProps.toArray(new Property[dynProps.size()]), Context.decoding);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

