/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.nE2Link.parser.binary;

import com.ismacontrolli.nE2Link.BNanoBaseComponent;
import com.ismacontrolli.nE2Link.BNanoStatusNumeric;
import com.ismacontrolli.nE2Link.datatypes.choice.BDynamicChoice;
import com.ismacontrolli.nE2Link.datatypes.choice.BStatusDynamicChoice;
import com.ismacontrolli.nE2Link.parser.binary.AbstractNanoData;
import com.ismacontrolli.nE2Link.parser.binary.BNanoReference;
import com.ismacontrolli.serialization.DataMarker;
import com.ismacontrolli.serialization.SerializableForm;
import java.text.MessageFormat;
import java.util.Arrays;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;

public class SlotsValuesData
extends AbstractNanoData {
    private Object[] _slotsValues = new Object[0];

    private SlotsValuesData(SerializableForm serializedSlotsValues) {
        super(serializedSlotsValues);
        this._slotsValues = serializedSlotsValues.data;
    }

    public static SlotsValuesData parse(SerializableForm serializedSlotsValues) {
        DataMarker marker = serializedSlotsValues.marker;
        if (marker.getValue() != 71) {
            LOGGER.severe(String.format("[SlotsValuesData.parse()]: Unexpected Data type: Expected marker: '%s', Received marker: '%s'.\nSkipping data processing.", new Object[]{DataMarker.SlotsValuesData, marker}));
            return null;
        }
        SlotsValuesData slotsValuesData = new SlotsValuesData(serializedSlotsValues);
        return slotsValuesData;
    }

    public static SlotsValuesData make(BNanoBaseComponent component) {
        Object[] slotsValuesData = new Object[component.getMaxNanoSlotId() + 1];
        for (int slotId = 0; slotId <= component.getMaxNanoSlotId(); ++slotId) {
            Property slot = component.getNanoSlot(slotId);
            if (slot == null) continue;
            slotsValuesData[slotId] = SlotsValuesData.slotValueToObject(component, slot);
        }
        SerializableForm serializedSlotsValues = new SerializableForm(DataMarker.SlotsValuesData, slotsValuesData);
        return new SlotsValuesData(serializedSlotsValues);
    }

    public int size() {
        return this._slotsValues.length;
    }

    public Object getSlotValueData(int slotId) {
        return this._slotsValues[slotId];
    }

    public Object[] getSlotsValueData() {
        return this._slotsValues;
    }

    public String toDebugString() {
        StringBuffer sb = new StringBuffer();
        sb.append("SlotsValuesData :");
        int i = 0;
        for (Object obj : this._slotsValues) {
            sb.append(MessageFormat.format("\n  Slot Value[{0}]= {1}", i++, obj != null ? obj.toString() : "null"));
        }
        return sb.toString();
    }

    public static Object slotValueToObject(BNanoBaseComponent component, Property slot) {
        Object slotValue = null;
        if (component.getInitComplete() || slot.getName().equals("meta") || slot.getName().equals("unitsAreSet")) {
            BValue niagaraValue = component.get(slot);
            if (niagaraValue instanceof BStatusValue && ((BStatusValue)niagaraValue).getStatus().isNull()) {
                return null;
            }
            if (niagaraValue.getType().is(BNanoStatusNumeric.TYPE)) {
                slotValue = ((BNanoStatusNumeric)niagaraValue).getNumeric();
            } else if (niagaraValue.getType().is(BStatusNumeric.TYPE)) {
                slotValue = ((BStatusNumeric)niagaraValue).getNumeric();
            } else if (niagaraValue.getType().is(BStatusBoolean.TYPE)) {
                slotValue = ((BStatusBoolean)niagaraValue).getBoolean();
            } else if (niagaraValue.getType().is(BStatusEnum.TYPE)) {
                slotValue = Double.valueOf(((BStatusEnum)niagaraValue).getValue().getOrdinal());
            } else if (niagaraValue.getType().is(BStatusString.TYPE)) {
                slotValue = ((BStatusString)niagaraValue).getValue();
            } else if (niagaraValue.getType().is(BDynamicChoice.TYPE)) {
                slotValue = ((BDynamicChoice)niagaraValue).getKeyAsNanoObject((Slot)slot);
            } else if (niagaraValue.getType().is(BStatusDynamicChoice.TYPE)) {
                slotValue = ((BStatusDynamicChoice)niagaraValue).getValue().getKeyAsNanoObject((Slot)slot);
            } else if (!niagaraValue.getType().is(BNanoReference.TYPE)) {
                throw new RuntimeException("Unsupported data type or null value");
            }
        } else {
            slotValue = DataMarker.DefaultValue;
        }
        return slotValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SlotsValuesData that = (SlotsValuesData)o;
        return Arrays.equals(this._slotsValues, that._slotsValues);
    }

    public int hashCode() {
        return Arrays.hashCode(this._slotsValues);
    }

    public String toString() {
        return "SlotsValuesData{slotsValues=" + Arrays.toString(this._slotsValues) + '}';
    }
}

