/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.nE2Link.parser.binary;

import com.ismacontrolli.nE2Link.BSlotMetaDataFlags;
import java.util.Objects;
import javax.baja.sys.BFacets;

public class SlotMetaData {
    private final int precision;
    private final int slotId;
    private final long metaData;
    private final BSlotMetaDataFlags metaDataFlags;

    public SlotMetaData(long slotMetaData) {
        this.metaData = slotMetaData;
        this.metaDataFlags = BSlotMetaDataFlags.make((int)(slotMetaData & 0xFFFFFFFFL));
        this.precision = (int)(slotMetaData >>> 8 & 0xFL);
        this.slotId = (int)(slotMetaData >>> 16 & 0xFFL);
    }

    public long asLong() {
        return this.metaData;
    }

    public BFacets asFacets() {
        return BFacets.make((String)"slotMetaData", (long)this.metaData);
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getSlotId() {
        return this.slotId;
    }

    public BSlotMetaDataFlags getMetaDataFlags() {
        return this.metaDataFlags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SlotMetaData that = (SlotMetaData)o;
        return this.precision == that.precision && this.slotId == that.slotId && this.metaDataFlags.equals(that.metaDataFlags);
    }

    public int hashCode() {
        return Objects.hash(this.precision, this.slotId, this.metaDataFlags);
    }
}

