/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.nE2Link.parser.binary;

import com.ismacontrolli.nE2Link.BNanoBaseComponent;
import com.ismacontrolli.nE2Link.parser.binary.AbstractNanoData;
import com.ismacontrolli.nE2Link.parser.binary.AbstractNanoRequest;
import com.ismacontrolli.nE2Link.parser.binary.AbstractNanoResponse;
import com.ismacontrolli.nE2Link.parser.binary.ObjectData;
import com.ismacontrolli.nE2Link.parser.binary.ReorderRequest;
import com.ismacontrolli.nE2Link.parser.binary.ResponseCode;
import com.ismacontrolli.serialization.DataMarker;
import com.ismacontrolli.serialization.SerializableForm;
import java.util.List;

public class ReorderResponse
extends AbstractNanoResponse {
    private ReorderResponse(AbstractNanoRequest request, ResponseCode responseCode) {
        super(request, responseCode);
    }

    private ReorderResponse(AbstractNanoRequest request, List<SerializableForm> response) {
        super(request, response);
    }

    public static ReorderResponse make(AbstractNanoRequest request, ResponseCode responseCode) {
        return new ReorderResponse(request, responseCode);
    }

    public static ReorderResponse parse(AbstractNanoRequest request, List<SerializableForm> response) {
        return new ReorderResponse(request, response);
    }

    @Override
    public ObjectData getResponseData() {
        return (ObjectData)super.getResponseData(0);
    }

    @Override
    protected boolean isMalformedResponse(SerializableForm responseContentElement) {
        return !responseContentElement.marker.equals((Object)DataMarker.ObjectData);
    }

    @Override
    protected AbstractNanoData doParseResponseContentElement(SerializableForm responseContentElement) {
        ObjectData nanoObject = ObjectData.parse(responseContentElement, this.getRequest().getNe2DeviceExt());
        return nanoObject;
    }

    @Override
    protected boolean isParsedDataInvalid(AbstractNanoData parsedData) {
        ObjectData objectData = (ObjectData)parsedData;
        return super.isParsedDataInvalid(parsedData) || objectData.getGlobalIndex() == -1;
    }

    @Override
    public String getLocalizedMessage(int index) {
        BNanoBaseComponent requestData = ((ReorderRequest)this.getRequest()).getClientRequestData();
        String extTypeName = requestData.getOriginNameFromLibrary();
        String extAssemblyName = requestData.getAssemblyInfo();
        ObjectData responseData = this.getResponseData();
        String message = "";
        switch (this.getResponseCode()) {
            case OK: {
                message = LEX.getText("REORDER_OK", new Object[]{requestData.getNanoName(), extTypeName, extAssemblyName});
                break;
            }
            case ERROR: {
                message = LEX.getText("REORDER_ERROR", new Object[]{this.getErrorMessage(), this.getExceptionMessage(), this.getStackTrace()});
                break;
            }
            case NOT_CONNECTED: {
                message = LEX.getText("REORDER_NOT_CONNECTED", new Object[]{requestData.getNanoName(), extTypeName, extAssemblyName});
                break;
            }
            case NO_RESPONSE: {
                message = LEX.getText("REORDER_NO_RESPONSE", new Object[]{requestData.getNanoName(), extTypeName, extAssemblyName});
                break;
            }
            case INVALID_RESPONSE: {
                message = LEX.getText("REORDER_INVALID_RESPONSE", new Object[]{requestData.getNanoName(), extTypeName, extAssemblyName});
                break;
            }
            default: {
                return LEX.getText("ILLEGAL_RESPONSE_CODE");
            }
        }
        return message;
    }
}

