/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.nE2Link.parser.binary;

import com.ismacontrolli.nE2Link.BNanoBaseComponent;
import com.ismacontrolli.nE2Link.actions.BNanoComponentRenameArg;
import com.ismacontrolli.nE2Link.parser.binary.AbstractNanoData;
import com.ismacontrolli.nE2Link.parser.binary.AbstractNanoRequest;
import com.ismacontrolli.nE2Link.parser.binary.AbstractNanoResponse;
import com.ismacontrolli.nE2Link.parser.binary.ObjectData;
import com.ismacontrolli.nE2Link.parser.binary.RenameRequest;
import com.ismacontrolli.nE2Link.parser.binary.ResponseCode;
import com.ismacontrolli.serialization.DataMarker;
import com.ismacontrolli.serialization.SerializableForm;
import java.util.List;

public class RenameResponse
extends AbstractNanoResponse {
    protected RenameResponse(AbstractNanoRequest request, ResponseCode responseCode) {
        super(request, responseCode);
    }

    private RenameResponse(AbstractNanoRequest request, List<SerializableForm> response) {
        super(request, response);
    }

    public static RenameResponse make(AbstractNanoRequest request, ResponseCode responseCode) {
        return new RenameResponse(request, responseCode);
    }

    public static RenameResponse parse(AbstractNanoRequest request, List<SerializableForm> response) {
        return new RenameResponse(request, response);
    }

    @Override
    protected boolean isMalformedResponse(SerializableForm responseContentElement) {
        return !responseContentElement.marker.equals((Object)DataMarker.ObjectData);
    }

    @Override
    protected AbstractNanoData doParseResponseContentElement(SerializableForm responseContentElement) {
        return ObjectData.parse(responseContentElement, this.getRequest().getNe2DeviceExt());
    }

    @Override
    public RenameRequest getRequest() {
        return (RenameRequest)super.getRequest();
    }

    @Override
    public ObjectData getResponseData() {
        return (ObjectData)super.getResponseData();
    }

    @Override
    public String getLocalizedMessage(int index) {
        BNanoComponentRenameArg requestData = this.getRequest().getClientRequestData();
        int renamedComponentId = requestData.getRenamedComponentGlobalIndex();
        String oldName = requestData.getOldName();
        String newName = requestData.getNewName();
        BNanoBaseComponent renamedComponent = this.getRequest().getNe2DeviceExt().getComponentCache().get(renamedComponentId);
        String renamedComponentNavOrd = renamedComponent != null ? renamedComponent.getNavOrd().toString() : "unresolvable component";
        switch (this.getResponseCode()) {
            case OK: {
                return LEX.getText("RENAME_OK", new Object[]{renamedComponentNavOrd, renamedComponentId, oldName, this.getResponseData().getNanoName()});
            }
            case ERROR: {
                return LEX.getText("RENAME_ERROR", new Object[]{renamedComponentNavOrd, renamedComponentId, oldName, newName, this.getErrorMessage(), this.getExceptionMessage(), this.getStackTrace()});
            }
            case NOT_CONNECTED: {
                return LEX.getText("RENAME_NOT_CONNECTED", new Object[]{renamedComponentNavOrd, renamedComponentId, oldName, newName});
            }
            case NO_RESPONSE: {
                return LEX.getText("RENAME_NO_RESPONSE", new Object[]{renamedComponentNavOrd, renamedComponentId, oldName, newName});
            }
            case INVALID_RESPONSE: {
                return LEX.getText("RENAME_INVALID_RESPONSE", new Object[]{renamedComponentNavOrd, renamedComponentId, oldName, newName});
            }
        }
        return LEX.getText("ILLEGAL_RESPONSE_CODE");
    }
}

