/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.nE2Link.parser.binary;

import com.ismacontrolli.ifnetclient.model.RemoteDevice;
import com.ismacontrolli.nE2Link.BNanoBaseComponent;
import com.ismacontrolli.nE2Link.BNe2DeviceExt;
import com.ismacontrolli.nE2Link.actions.BNanoComponentRenameArg;
import com.ismacontrolli.nE2Link.parser.binary.AbstractNanoRequest;
import com.ismacontrolli.nE2Link.parser.binary.RenameData;
import com.ismacontrolli.nE2Link.parser.binary.RenameResponse;
import com.ismacontrolli.nE2Link.parser.binary.ResponseCode;
import com.ismacontrolli.serialization.SerializableForm;
import java.util.ArrayList;

public class RenameRequest
extends AbstractNanoRequest {
    private RenameRequest(BNe2DeviceExt ne2DeviceExt, BNanoComponentRenameArg clientRequestData, RenameData requestData) {
        super(ne2DeviceExt, (Object)clientRequestData, requestData);
    }

    public static RenameRequest make(BNe2DeviceExt ne2DeviceExt, BNanoComponentRenameArg renameArg) {
        return new RenameRequest(ne2DeviceExt, renameArg, RenameData.make(renameArg));
    }

    public BNanoComponentRenameArg getClientRequestData() {
        return (BNanoComponentRenameArg)((Object)super.getClientRequestData());
    }

    @Override
    public RenameData getRequestData() {
        return (RenameData)super.getRequestData();
    }

    @Override
    public RenameResponse postRequest(RemoteDevice remoteDevice) {
        if (remoteDevice == null || !remoteDevice.Remote.isConnected()) {
            return RenameResponse.make(this, ResponseCode.NOT_CONNECTED);
        }
        ArrayList<SerializableForm> response = remoteDevice.Remote.Rename(this.getRequestData().getSerializableForm());
        if (response == null) {
            return RenameResponse.make(this, ResponseCode.NO_RESPONSE);
        }
        if (this.isResponseMalformed(response)) {
            return RenameResponse.make(this, ResponseCode.INVALID_RESPONSE);
        }
        return RenameResponse.parse(this, response);
    }

    @Override
    public String getLocalizedMessage() {
        BNanoComponentRenameArg requestData = this.getClientRequestData();
        int renamedComponentId = requestData.getRenamedComponentGlobalIndex();
        String oldName = requestData.getOldName();
        String newName = requestData.getNewName();
        BNanoBaseComponent renamedComponent = this.getNe2DeviceExt().getComponentCache().get(renamedComponentId);
        String renamedComponentNavOrd = renamedComponent != null ? renamedComponent.getNavOrd().toString() : "unresolvable component";
        return LEX.getText("RENAME_REQUEST", new Object[]{renamedComponentNavOrd, renamedComponentId, oldName, newName});
    }
}

