/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.nE2Link.parser.binary;

import com.ismacontrolli.nE2Link.actions.BNanoComponentRenameArg;
import com.ismacontrolli.nE2Link.parser.binary.AbstractNanoData;
import com.ismacontrolli.serialization.DataMarker;
import com.ismacontrolli.serialization.SerializableForm;
import java.util.Objects;

public class RenameData
extends AbstractNanoData {
    private int componentId;
    private String newName;

    private RenameData(SerializableForm serializedRenameData) {
        super(serializedRenameData);
        this.componentId = Short.toUnsignedInt((Short)serializedRenameData.data[0]);
        this.newName = (String)serializedRenameData.data[1];
    }

    public static RenameData make(BNanoComponentRenameArg renameArg) {
        SerializableForm serializableForm = new SerializableForm(DataMarker.RenameData, new Object[]{(short)renameArg.getRenamedComponentGlobalIndex(), renameArg.getNewName()});
        return new RenameData(serializableForm);
    }

    public static RenameData parse(SerializableForm serializedRenameData) {
        DataMarker marker = serializedRenameData.marker;
        if (marker.getValue() != 75) {
            LOGGER.severe(String.format("[RenameData.parse](): Unexpected Data type: Expected marker: '%s', Received marker: '%s'.\nSkipping data processing.", new Object[]{DataMarker.RenameData, marker}));
            return null;
        }
        return new RenameData(serializedRenameData);
    }

    public int getComponentId() {
        return this.componentId;
    }

    public String getNewName() {
        return this.newName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RenameData that = (RenameData)o;
        return this.componentId == that.componentId && Objects.equals(this.newName, that.newName);
    }

    public int hashCode() {
        return Objects.hash(this.componentId, this.newName);
    }

    public String toString() {
        return "RenameData{componentId=" + this.componentId + ", newName='" + this.newName + '\'' + '}';
    }
}

