/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.nE2Link.parser.binary;

import com.ismacontrolli.nE2Link.parser.binary.AbstractNanoData;
import com.ismacontrolli.nE2Link.parser.binary.AbstractNanoRequest;
import com.ismacontrolli.nE2Link.parser.binary.AbstractNanoResponse;
import com.ismacontrolli.nE2Link.parser.binary.FileData;
import com.ismacontrolli.nE2Link.parser.binary.PutFileRequest;
import com.ismacontrolli.nE2Link.parser.binary.ResponseCode;
import com.ismacontrolli.nE2Link.utils.BFileDataArgs;
import com.ismacontrolli.serialization.DataMarker;
import com.ismacontrolli.serialization.SerializableForm;
import java.util.List;

public class PutFileResponse
extends AbstractNanoResponse {
    private PutFileResponse(AbstractNanoRequest request, ResponseCode responseCode) {
        super(request, responseCode);
    }

    private PutFileResponse(AbstractNanoRequest request, List<SerializableForm> response) {
        super(request, response);
    }

    public static PutFileResponse make(AbstractNanoRequest request, ResponseCode responseCode) {
        return new PutFileResponse(request, responseCode);
    }

    public static PutFileResponse parse(AbstractNanoRequest request, List<SerializableForm> response) {
        return new PutFileResponse(request, response);
    }

    @Override
    public AbstractNanoData getResponseData() {
        return super.getResponseData();
    }

    @Override
    protected boolean isMalformedResponse(SerializableForm responseContentElement) {
        return !responseContentElement.marker.equals((Object)DataMarker.FileData);
    }

    @Override
    protected AbstractNanoData doParseResponseContentElement(SerializableForm responseContentElement) {
        return FileData.parse(responseContentElement);
    }

    @Override
    protected boolean isParsedDataInvalid(AbstractNanoData parsedData) {
        FileData fileData = (FileData)parsedData;
        return super.isParsedDataInvalid(parsedData);
    }

    @Override
    public String getLocalizedMessage(int index) {
        BFileDataArgs requestData = ((PutFileRequest)this.getRequest()).getClientRequestData();
        String folderPath = requestData.getFolderPath();
        String filePath = requestData.getFilePath();
        String message = "";
        switch (this.getResponseCode()) {
            case OK: {
                message = LEX.getText("PUT_FILE_OK", new Object[]{folderPath, filePath});
                break;
            }
            case ERROR: {
                message = LEX.getText("PUT_FILE_ERROR", new Object[]{folderPath, filePath});
                break;
            }
            case NOT_CONNECTED: {
                message = LEX.getText("PUT_FILE_NOT_CONNECTED", new Object[]{folderPath, filePath});
                break;
            }
            case NO_RESPONSE: {
                message = LEX.getText("PUT_FILE_NO_RESPONSE", new Object[]{folderPath, filePath});
                break;
            }
            case INVALID_RESPONSE: {
                message = LEX.getText("PUT_FILE_INVALID_RESPONSE", new Object[]{folderPath, filePath});
                break;
            }
            default: {
                return LEX.getText("ILLEGAL_RESPONSE_CODE");
            }
        }
        return message;
    }
}

