/*
 * Decompiled with CFR 0.152.
 */
package com.ismacontrolli.nE2Link.parser.binary;

import com.ismacontrolli.nE2Link.BNanoBaseComponent;
import com.ismacontrolli.nE2Link.BNe2DeviceExt;
import com.ismacontrolli.nE2Link.datatypes.choice.BDynamicChoiceRange;
import com.ismacontrolli.nE2Link.notifications.BRefreshNotification;
import com.ismacontrolli.nE2Link.notifications.BRefreshTargets;
import com.ismacontrolli.nE2Link.parser.binary.AbstractNanoData;
import com.ismacontrolli.nE2Link.parser.binary.ExistingLinkData;
import com.ismacontrolli.nE2Link.parser.binary.ObjectData;
import com.ismacontrolli.nE2Link.parser.binary.SlotMetaData;
import com.ismacontrolli.nE2Link.parser.binary.SlotsMetaData;
import com.ismacontrolli.nE2Link.parser.binary.SlotsValuesData;
import com.ismacontrolli.serialization.SerializableForm;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;

public class PollData
extends AbstractNanoData {
    private int globalId;
    private SlotsValuesData slotsValuesData;
    private SlotsMetaData slotsMetaData;
    private ArrayList<ExistingLinkData> links = new ArrayList();
    protected static Collection<String> PROPERTIES_REQUIRING_UI_UPDATE_ON_FLAG_CHANGE = Arrays.asList("action.*Value", "samplingInterval", "deadband");
    private Map<String, BDynamicChoiceRange> dynamicChoiceRanges = new HashMap<String, BDynamicChoiceRange>();

    protected PollData(SerializableForm serializableForm) {
        super(serializableForm);
    }

    protected static PollData parse(SerializableForm serializedPollData) {
        throw new RuntimeException("Not Implemented. Please use PollData.parse(SerializableForm serializedPollData, BNe2DeviceExt controller)");
    }

    public static PollData parse(SerializableForm serializedPollData, BNe2DeviceExt controller) {
        PollData pollData = new PollData(serializedPollData);
        pollData.globalId = Short.toUnsignedInt((Short)serializedPollData.data[0]);
        List<SerializableForm> dataElements = serializedPollData.elements.toSerializableForms();
        block7: for (SerializableForm dataElement : dataElements) {
            int marker = Byte.toUnsignedInt(dataElement.marker.getValue());
            switch (marker) {
                case 71: {
                    pollData.slotsValuesData = SlotsValuesData.parse(dataElement);
                    continue block7;
                }
                case 92: {
                    pollData.slotsMetaData = SlotsMetaData.parse(dataElement);
                    continue block7;
                }
                case 68: {
                    ExistingLinkData existingLinkData = ExistingLinkData.parse(dataElement);
                    if (existingLinkData == null) continue block7;
                    pollData.links.add(existingLinkData);
                    continue block7;
                }
                case 204: {
                    BDynamicChoiceRange dynamicChoiceRange = BDynamicChoiceRange.parse(dataElement, null);
                    if (dynamicChoiceRange == null || dynamicChoiceRange.getOwnerSlotId() == -1) continue block7;
                    pollData.dynamicChoiceRanges.put(dynamicChoiceRange.getGenuineId(), dynamicChoiceRange);
                    continue block7;
                }
                case 254: {
                    continue block7;
                }
            }
            LOGGER.severe(String.format("[poll]: Unexpected Data type: marker: '%s'.\nIgnoring this part of object data and proceeding with other data.", marker));
        }
        return pollData;
    }

    public BNanoBaseComponent updateNiagaraComponent(BNe2DeviceExt controller) {
        BNanoBaseComponent nanoComponent = controller.getComponentCache().get(this.globalId);
        if (nanoComponent != null) {
            boolean refreshRequired = false;
            LOGGER.finest(String.format("[pollData.updateNiagaraComponent] component: %s global index %d", nanoComponent.getNanoName(), nanoComponent.getGlobalIndex()));
            if (this.slotsValuesData != null && this.slotsMetaData != null && this.slotsValuesData.size() == this.slotsMetaData.size()) {
                for (int i = 0; i < this.slotsMetaData.size(); ++i) {
                    SlotMetaData slotMetaData = this.slotsMetaData.getSlotMetaData(i);
                    Property slot = nanoComponent.getNanoSlot(slotMetaData.getSlotId());
                    if (slot != null) {
                        ObjectData.updateNiagaraPropertyValue(nanoComponent, (Slot)slot, this.slotsValuesData.getSlotValueData(i), this.dynamicChoiceRanges);
                        boolean flagsChanged = ObjectData.updateNiagaraSlotDef(nanoComponent, (Slot)slot, slotMetaData);
                        if (!flagsChanged) continue;
                        System.out.println(String.format("FLAGS CHANGED in Poll data for slot %s on %s", slot.getName(), nanoComponent.getNanoName()));
                        String slotName = BNanoBaseComponent.getOriginNameFromProperty(slot);
                        if (!PROPERTIES_REQUIRING_UI_UPDATE_ON_FLAG_CHANGE.stream().anyMatch(s -> slotName.matches((String)s))) continue;
                        refreshRequired = true;
                        continue;
                    }
                    LOGGER.severe(String.format("[pollData.updateNiagaraComponent]: Invalid SlotsMetaData: Slot with slotId=%d not found in component %s with global id=%d .\nSkipping update of this slot.", slotMetaData.getSlotId(), nanoComponent.getNanoName(), nanoComponent.getGlobalIndex()));
                }
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.finest(String.format("[pollData.updateNiagaraComponent] %s", this.toString()));
                }
            } else {
                LOGGER.severe("[pollData.updateNiagaraComponent]: SlotsMetaData or SlotsValuesData unavailable or invalid size.\nSkipping component flag & facet update.");
            }
            if (refreshRequired && !controller.getApplicationIsLoading()) {
                BRefreshNotification refresh = BRefreshNotification.make(BRefreshTargets.propertySheet, nanoComponent);
                refresh.raise(null);
            }
            return nanoComponent;
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PollData pollData = (PollData)o;
        return this.globalId == pollData.globalId && this.slotsValuesData.equals(pollData.slotsValuesData) && this.slotsMetaData.equals(pollData.slotsMetaData) && this.links.equals(pollData.links) && this.dynamicChoiceRanges.equals(pollData.dynamicChoiceRanges);
    }

    public int hashCode() {
        return Objects.hash(this.globalId, this.slotsValuesData, this.slotsMetaData, this.links, this.dynamicChoiceRanges);
    }

    public String toString() {
        return "PollData{globalId=" + this.globalId + ", slotsValuesData=" + this.slotsValuesData + ", slotsMetaData=" + this.slotsMetaData + ", links=" + this.links + ", dynamicChoiceRanges=" + this.dynamicChoiceRanges + '}';
    }

    public int getGlobalId() {
        return this.globalId;
    }

    public SlotsValuesData getSlotsValuesData() {
        return this.slotsValuesData;
    }

    public SlotsMetaData getSlotsMetaData() {
        return this.slotsMetaData;
    }

    public ArrayList<ExistingLinkData> getLinks() {
        return this.links;
    }

    public Map<String, BDynamicChoiceRange> getDynamicChoiceRanges() {
        return this.dynamicChoiceRanges;
    }
}

